/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.BsonRegularExpression;
import de.bwaldvogel.mongo.bson.BsonTimestamp;
import de.bwaldvogel.mongo.bson.Decimal128;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.LegacyUUID;
import de.bwaldvogel.mongo.bson.MaxKey;
import de.bwaldvogel.mongo.bson.MinKey;
import de.bwaldvogel.mongo.bson.ObjectId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;

public class ValueComparator
implements Comparator<Object> {
    private static final List<Class<?>> SORT_PRIORITY = new ArrayList();
    private static final ValueComparator ASCENDING = new ValueComparator(true);
    private static final ValueComparator DESCENDING = new ValueComparator(false);
    private static final ValueComparator ASCENDING_NO_LIST_HANDLING = new ValueComparator(true, false, false);
    private final boolean ascending;
    private final boolean handleLists;
    private final boolean useDefaultComparatorForUuids;

    public static ValueComparator asc() {
        return ASCENDING;
    }

    public static ValueComparator ascWithoutListHandling() {
        return ASCENDING_NO_LIST_HANDLING;
    }

    public static ValueComparator desc() {
        return DESCENDING;
    }

    private ValueComparator(boolean ascending) {
        this(ascending, true, false);
    }

    private ValueComparator(boolean ascending, boolean handleLists, boolean useDefaultComparatorForUuids) {
        this.ascending = ascending;
        this.handleLists = handleLists;
        this.useDefaultComparatorForUuids = useDefaultComparatorForUuids;
    }

    public ValueComparator withDefaultComparatorForUuids() {
        return new ValueComparator(this.ascending, this.handleLists, true);
    }

    public ValueComparator reversed() {
        return this.ascending ? ValueComparator.desc() : ValueComparator.asc();
    }

    static int compareTypes(Object value1, Object value2) {
        if (Missing.isNullOrMissing(value1) && Missing.isNullOrMissing(value2)) {
            return 0;
        }
        if (Missing.isNullOrMissing(value1)) {
            return -1;
        }
        if (Missing.isNullOrMissing(value2)) {
            return 1;
        }
        int t1 = ValueComparator.getTypeOrder(value1);
        int t2 = ValueComparator.getTypeOrder(value2);
        return Integer.compare(t1, t2);
    }

    @Override
    public int compare(Object o1, Object o2) {
        int cmp = this.doCompare(o1, o2);
        return this.ascending ? cmp : -cmp;
    }

    private static int compareAsc(Object value1, Object value2) {
        return ValueComparator.asc().compare(value1, value2);
    }

    private int doCompare(Object value1, Object value2) {
        Comparable<UUID> uuid1;
        Class<?> componentType;
        if (value1 == value2) {
            return 0;
        }
        if (this.handleLists && (value1 instanceof Collection || value2 instanceof Collection)) {
            return this.compareLists(value1, value2);
        }
        if (value1 instanceof MinKey) {
            return value2 instanceof MinKey ? 0 : -1;
        }
        if (value2 instanceof MinKey) {
            return 1;
        }
        if (Missing.isNullOrMissing(value1) && Missing.isNullOrMissing(value2)) {
            return 0;
        }
        int typeComparision = ValueComparator.compareTypes(value1, value2);
        if (typeComparision != 0) {
            return typeComparision;
        }
        Class<?> clazz = value1.getClass();
        if (ObjectId.class.isAssignableFrom(clazz)) {
            return ((ObjectId)value1).compareTo((ObjectId)value2);
        }
        if (value1 instanceof Decimal128 && value2 instanceof Decimal128) {
            Decimal128 decimal1 = (Decimal128)value1;
            Decimal128 decimal2 = (Decimal128)value2;
            return decimal1.compareTo(decimal2);
        }
        if (Number.class.isAssignableFrom(clazz)) {
            Number number1 = Utils.normalizeNumber((Number)value1);
            Number number2 = Utils.normalizeNumber((Number)value2);
            return Double.compare(number1.doubleValue(), number2.doubleValue());
        }
        if (String.class.isAssignableFrom(clazz)) {
            return value1.toString().compareTo(value2.toString());
        }
        if (Instant.class.isAssignableFrom(clazz)) {
            Instant date1 = (Instant)value1;
            Instant date2 = (Instant)value2;
            return date1.compareTo(date2);
        }
        if (BsonTimestamp.class.isAssignableFrom(clazz)) {
            BsonTimestamp bt1 = (BsonTimestamp)value1;
            BsonTimestamp bt2 = (BsonTimestamp)value2;
            return Long.compare(bt1.getTimestamp(), bt2.getTimestamp());
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            boolean b1 = (Boolean)value1;
            boolean b2 = (Boolean)value2;
            return !b1 && b2 ? -1 : (b1 && !b2 ? 1 : 0);
        }
        if (List.class.isAssignableFrom(clazz)) {
            return this.compareListsForEquality((Collection)value1, (Collection)value2);
        }
        if (clazz.isArray() && Byte.TYPE.isAssignableFrom(componentType = clazz.getComponentType())) {
            byte[] bytes1 = (byte[])value1;
            byte[] bytes2 = (byte[])value2;
            if (bytes1.length != bytes2.length) {
                return Integer.compare(bytes1.length, bytes2.length);
            }
            for (int i = 0; i < bytes1.length; ++i) {
                int compare = ValueComparator.compareUnsigned(bytes1[i], bytes2[i]);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
        if (Document.class.isAssignableFrom(clazz)) {
            return this.compareDocuments((Document)value1, (Document)value2);
        }
        if (UUID.class.isAssignableFrom(clazz)) {
            uuid1 = (UUID)value1;
            UUID uuid2 = (UUID)value2;
            if (this.useDefaultComparatorForUuids) {
                return ((UUID)uuid1).compareTo(uuid2);
            }
            int cmp1 = Long.compare(((UUID)uuid1).getLeastSignificantBits(), uuid2.getLeastSignificantBits());
            if (cmp1 != 0) {
                return cmp1;
            }
            return Long.compare(((UUID)uuid1).getMostSignificantBits(), uuid2.getMostSignificantBits());
        }
        if (LegacyUUID.class.isAssignableFrom(clazz)) {
            uuid1 = (LegacyUUID)value1;
            LegacyUUID uuid2 = (LegacyUUID)value2;
            return ((LegacyUUID)uuid1).compareTo(uuid2);
        }
        if (MaxKey.class.isAssignableFrom(clazz)) {
            return value2 instanceof MaxKey ? 0 : 1;
        }
        throw new UnsupportedOperationException("can't compare " + clazz);
    }

    private int compareListsForEquality(Collection<?> value1, Collection<?> value2) {
        Assert.isFalse(this.handleLists, () -> "Unexpected state");
        ArrayList collection1 = new ArrayList(value1);
        ArrayList collection2 = new ArrayList(value2);
        for (int i = 0; i < Math.max(collection1.size(), collection2.size()); ++i) {
            Missing v2;
            Missing v1 = i >= collection1.size() ? Missing.getInstance() : collection1.get(i);
            int cmp = this.compare(v1, v2 = i >= collection2.size() ? Missing.getInstance() : collection2.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static boolean isEmptyList(Object value1) {
        return value1 instanceof Collection && ((Collection)value1).isEmpty();
    }

    private int compareLists(Object value1, Object value2) {
        Object valueForComparison1 = this.getListValueForComparison(value1);
        Object valueForComparison2 = this.getListValueForComparison(value2);
        if (ValueComparator.isEmptyList(value1) && Missing.isNullOrMissing(valueForComparison2)) {
            return -1;
        }
        if (ValueComparator.isEmptyList(value2) && Missing.isNullOrMissing(valueForComparison1)) {
            return 1;
        }
        return ValueComparator.compareAsc(valueForComparison1, valueForComparison2);
    }

    private Object getListValueForComparison(Object value) {
        if (value instanceof Collection) {
            ArrayList<Object> values = new ArrayList<Object>((Collection)value);
            if (values.isEmpty()) {
                return Missing.getInstance();
            }
            values.sort(this);
            return values.get(0);
        }
        return value;
    }

    private int compareDocuments(Document document1, Document document2) {
        ArrayList<String> keys1 = new ArrayList<String>(document1.keySet());
        ArrayList<String> keys2 = new ArrayList<String>(document2.keySet());
        for (int i = 0; i < Math.max(keys1.size(), keys2.size()); ++i) {
            Object value2;
            String key1 = i >= keys1.size() ? null : (String)keys1.get(i);
            String key2 = i >= keys2.size() ? null : (String)keys2.get(i);
            Object value1 = document1.getOrMissing(key1);
            int typeComparison = ValueComparator.compareTypes(value1, value2 = document2.getOrMissing(key2));
            if (typeComparison != 0) {
                return typeComparison;
            }
            int keyComparison = ValueComparator.compareAsc(key1, key2);
            if (keyComparison != 0) {
                return keyComparison;
            }
            int valueComparison = ValueComparator.compareAsc(value1, value2);
            if (valueComparison == 0) continue;
            return valueComparison;
        }
        return 0;
    }

    private static int compareUnsigned(byte b1, byte b2) {
        int v1 = b1 & 0xFF;
        int v2 = b2 & 0xFF;
        return Integer.compare(v1, v2);
    }

    private static int getTypeOrder(Object obj) {
        for (int idx = 0; idx < SORT_PRIORITY.size(); ++idx) {
            if (!SORT_PRIORITY.get(idx).isAssignableFrom(obj.getClass())) continue;
            return idx;
        }
        throw new UnsupportedOperationException("can't sort " + obj.getClass());
    }

    static {
        SORT_PRIORITY.add(Number.class);
        SORT_PRIORITY.add(String.class);
        SORT_PRIORITY.add(Document.class);
        SORT_PRIORITY.add(List.class);
        SORT_PRIORITY.add(byte[].class);
        SORT_PRIORITY.add(LegacyUUID.class);
        SORT_PRIORITY.add(UUID.class);
        SORT_PRIORITY.add(ObjectId.class);
        SORT_PRIORITY.add(Boolean.class);
        SORT_PRIORITY.add(Instant.class);
        SORT_PRIORITY.add(BsonTimestamp.class);
        SORT_PRIORITY.add(BsonRegularExpression.class);
        SORT_PRIORITY.add(MaxKey.class);
    }
}

