/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.backend.CollectionUtils;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.backend.aggregation.Expression;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.Accumulator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.AddToSetAccumulator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.AvgAccumulator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.FirstAccumulator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.LastAccumulator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.MaxAccumulator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.MinAccumulator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.PushAccumulator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.SumAccumulator;
import de.bwaldvogel.mongo.backend.aggregation.stage.AggregationStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GroupStage
implements AggregationStage {
    private final Map<String, Supplier<Accumulator>> accumulatorSuppliers;
    private final Object idExpression;

    public GroupStage(Document groupQuery) {
        if (!groupQuery.containsKey("_id")) {
            throw new MongoServerError(15955, "a group specification must include an _id");
        }
        this.idExpression = groupQuery.get("_id");
        this.accumulatorSuppliers = GroupStage.parseAccumulators(groupQuery);
    }

    @Override
    public Stream<Document> apply(Stream<Document> stream) {
        TreeMap accumulatorsPerKey = new TreeMap(ValueComparator.asc());
        stream.forEach(document -> {
            Object key = Expression.evaluateDocument(this.idExpression, document);
            if (key instanceof Missing) {
                key = null;
            }
            Collection accumulators = accumulatorsPerKey.computeIfAbsent(key, k -> this.accumulatorSuppliers.values().stream().map(Supplier::get).collect(Collectors.toList()));
            for (Accumulator accumulator : accumulators) {
                Object expression = accumulator.getExpression();
                accumulator.aggregate(Expression.evaluateDocument(expression, document));
            }
        });
        ArrayList<Document> result = new ArrayList<Document>();
        for (Map.Entry entry : accumulatorsPerKey.entrySet()) {
            Document groupResult = new Document();
            groupResult.put("_id", entry.getKey());
            for (Accumulator accumulator : (Collection)entry.getValue()) {
                groupResult.put(accumulator.getField(), accumulator.getResult());
            }
            result.add(groupResult);
        }
        return result.stream();
    }

    private static Map<String, Supplier<Accumulator>> parseAccumulators(Document groupStage) {
        LinkedHashMap<String, Supplier<Accumulator>> accumulators = new LinkedHashMap<String, Supplier<Accumulator>>();
        for (Map.Entry<String, Object> accumulatorEntry : groupStage.entrySet()) {
            if (accumulatorEntry.getKey().equals("_id")) continue;
            String field = accumulatorEntry.getKey();
            Document entryValue = (Document)accumulatorEntry.getValue();
            Map.Entry<String, Object> aggregation = CollectionUtils.getSingleElement(entryValue.entrySet(), () -> {
                throw new MongoServerError(40238, "The field '" + field + "' must specify one accumulator");
            });
            String groupOperator = aggregation.getKey();
            Object expression = aggregation.getValue();
            if (groupOperator.equals("$sum")) {
                accumulators.put(field, () -> new SumAccumulator(field, expression));
                continue;
            }
            if (groupOperator.equals("$min")) {
                accumulators.put(field, () -> new MinAccumulator(field, expression));
                continue;
            }
            if (groupOperator.equals("$max")) {
                accumulators.put(field, () -> new MaxAccumulator(field, expression));
                continue;
            }
            if (groupOperator.equals("$avg")) {
                accumulators.put(field, () -> new AvgAccumulator(field, expression));
                continue;
            }
            if (groupOperator.equals("$addToSet")) {
                accumulators.put(field, () -> new AddToSetAccumulator(field, expression));
                continue;
            }
            if (groupOperator.equals("$push")) {
                accumulators.put(field, () -> new PushAccumulator(field, expression));
                continue;
            }
            if (groupOperator.equals("$first")) {
                accumulators.put(field, () -> new FirstAccumulator(field, expression));
                continue;
            }
            if (groupOperator.equals("$last")) {
                accumulators.put(field, () -> new LastAccumulator(field, expression));
                continue;
            }
            throw new MongoServerError(15952, "unknown group operator '" + groupOperator + "'");
        }
        return accumulators;
    }
}

