/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.BadValueException;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.exception.PathNotViableException;
import de.bwaldvogel.mongo.wire.BsonEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class Utils {
    public static Number addNumbers(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() + b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() + b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() + b.longValue();
        }
        if (a instanceof Integer || b instanceof Integer) {
            return a.intValue() + b.intValue();
        }
        if (a instanceof Short || b instanceof Short) {
            return (short)(a.shortValue() + b.shortValue());
        }
        throw new UnsupportedOperationException("cannot add " + a + " and " + b);
    }

    public static Number subtractNumbers(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() - b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() - b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() - b.longValue();
        }
        if (a instanceof Integer || b instanceof Integer) {
            return a.intValue() - b.intValue();
        }
        if (a instanceof Short || b instanceof Short) {
            return (short)(a.shortValue() - b.shortValue());
        }
        throw new UnsupportedOperationException("cannot subtract " + a + " and " + b);
    }

    static Number multiplyNumbers(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() * b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() * b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() * b.longValue();
        }
        if (a instanceof Integer || b instanceof Integer) {
            return a.intValue() * b.intValue();
        }
        if (a instanceof Short || b instanceof Short) {
            return (short)(a.shortValue() * b.shortValue());
        }
        throw new UnsupportedOperationException("can not multiply " + a + " and " + b);
    }

    public static Object getSubdocumentValue(Document document, String key) {
        if (key.endsWith(".")) {
            throw new MongoServerError(40353, "FieldPath must not end with a '.'.");
        }
        if (key.startsWith(".") || key.contains("..")) {
            throw new MongoServerError(15998, "FieldPath field names may not be empty strings.");
        }
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = key.substring(dotPos + 1);
            Assert.doesNotStartWith(subKey, "$.");
            Object subObject = Utils.getFieldValueListSafe(document, mainKey);
            if (subObject instanceof Document) {
                return Utils.getSubdocumentValue((Document)subObject, subKey);
            }
            return Missing.getInstance();
        }
        return Utils.getFieldValueListSafe(document, key);
    }

    public static String getDatabaseNameFromFullName(String fullName) {
        int dotPos = fullName.indexOf(46);
        return fullName.substring(0, dotPos);
    }

    public static String getCollectionNameFromFullName(String fullName) {
        int dotPos = fullName.indexOf(46);
        return fullName.substring(dotPos + 1);
    }

    public static boolean isTrue(Object value) {
        if (Missing.isNullOrMissing(value)) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        return true;
    }

    static Object normalizeValue(Object value) {
        if (Missing.isNullOrMissing(value)) {
            return null;
        }
        if (value instanceof Number) {
            double doubleValue = ((Number)value).doubleValue();
            if (doubleValue == -0.0) {
                doubleValue = 0.0;
            }
            return doubleValue;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            Document result = new Document();
            for (Map.Entry entry : map.entrySet()) {
                result.put((String)entry.getKey(), Utils.normalizeValue(entry.getValue()));
            }
            return result;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.stream().map(Utils::normalizeValue).collect(Collectors.toList());
        }
        return value;
    }

    public static Number normalizeNumber(Number value) {
        if (value == null) {
            return null;
        }
        double doubleValue = value.doubleValue();
        if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
            return doubleValue;
        }
        if ((double)value.intValue() == doubleValue) {
            return value.intValue();
        }
        if ((double)value.longValue() == doubleValue) {
            return value.longValue();
        }
        return doubleValue;
    }

    static boolean nullAwareEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (Missing.isNullOrMissing(a) && Missing.isNullOrMissing(b)) {
            return true;
        }
        if (Missing.isNullOrMissing(a) || Missing.isNullOrMissing(b)) {
            return false;
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            byte[] bytesA = (byte[])a;
            byte[] bytesB = (byte[])b;
            return Arrays.equals(bytesA, bytesB);
        }
        Object normalizedA = Utils.normalizeValue(a);
        Object normalizedB = Utils.normalizeValue(b);
        return Objects.equals(normalizedA, normalizedB);
    }

    static int calculateSize(Document document) {
        ByteBuf buffer = Unpooled.buffer();
        try {
            new BsonEncoder().encodeDocument(document, buffer);
            int n = buffer.writerIndex();
            return n;
        }
        catch (IOException e) {
            throw new MongoServerException("Failed to calculate document size", e);
        }
        finally {
            buffer.release();
        }
    }

    static boolean containsQueryExpression(Object value) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof Document)) {
            return false;
        }
        Document doc = (Document)value;
        for (String key : doc.keySet()) {
            if (key.startsWith("$")) {
                return true;
            }
            if (!Utils.containsQueryExpression(doc.get(key))) continue;
            return true;
        }
        return false;
    }

    static Object getFieldValueListSafe(Object value, String field) throws IllegalArgumentException {
        if (Missing.isNullOrMissing(value)) {
            return Missing.getInstance();
        }
        if (field.equals("$") || field.contains(".")) {
            throw new IllegalArgumentException("illegal field: " + field);
        }
        if (value instanceof List) {
            if (field.matches("\\d+")) {
                int pos = Integer.parseInt(field);
                List list = (List)value;
                if (pos >= 0 && pos < list.size()) {
                    return list.get(pos);
                }
                return Missing.getInstance();
            }
            throw new IllegalArgumentException("illegal field: " + field);
        }
        if (value instanceof Document) {
            Document document = (Document)value;
            return document.getOrMissing(field);
        }
        return Missing.getInstance();
    }

    static boolean hasSubdocumentValue(Object document, String key) {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = Utils.getSubkey(key, dotPos, new AtomicReference<Integer>());
            Object subObject = Utils.getFieldValueListSafe(document, mainKey);
            if (subObject instanceof Document || subObject instanceof List) {
                return Utils.hasSubdocumentValue(subObject, subKey);
            }
            return false;
        }
        return Utils.hasFieldValueListSafe(document, key);
    }

    static String getSubkey(String key, int dotPos, AtomicReference<Integer> matchPos) {
        String subKey = key.substring(dotPos + 1);
        if (key.matches(".*\\$(\\.).+\\$(\\.).*")) {
            throw new BadValueException("Too many positional (i.e. '$') elements found in path '" + key + "'");
        }
        if (subKey.matches("\\$(\\..+)?")) {
            if (matchPos == null || matchPos.get() == null) {
                throw new BadValueException("The positional operator did not find the match needed from the query.");
            }
            Integer pos = matchPos.getAndSet(null);
            return subKey.replaceFirst("\\$", String.valueOf(pos));
        }
        return subKey;
    }

    static boolean hasFieldValueListSafe(Object document, String field) throws IllegalArgumentException {
        if (document == null) {
            return false;
        }
        if (field.equals("$") || field.contains(".")) {
            throw new IllegalArgumentException("illegal field: " + field);
        }
        if (document instanceof List) {
            if (field.matches("\\d+")) {
                int pos = Integer.parseInt(field);
                List list = (List)document;
                return pos >= 0 && pos < list.size();
            }
            throw new IllegalArgumentException("illegal field: " + field);
        }
        if (document instanceof Document) {
            return ((Document)document).containsKey(field);
        }
        throw new IllegalArgumentException("illegal document: " + document);
    }

    public static void markOkay(Document result) {
        result.put("ok", (Object)1.0);
    }

    static void setListSafe(Object document, String key, Object obj) {
        if (document instanceof List) {
            int pos = Integer.parseInt(key);
            List list = (List)document;
            while (list.size() <= pos) {
                list.add(null);
            }
            list.set(pos, obj);
        } else {
            ((Document)document).put(key, obj);
        }
    }

    static Object removeListSafe(Object document, String key) {
        if (document instanceof Document) {
            return ((Document)document).remove(key);
        }
        if (document instanceof List) {
            int pos = Integer.parseInt(key);
            List list = (List)document;
            if (list.size() > pos) {
                return list.set(pos, null);
            }
            return null;
        }
        throw new IllegalArgumentException();
    }

    public static String join(List<Integer> array, char c) {
        StringBuilder sb = new StringBuilder();
        for (int value : array) {
            if (sb.length() > 0) {
                sb.append(c);
            }
            sb.append(Integer.toString(value));
        }
        return sb.toString();
    }

    static void changeSubdocumentValue(Object document, String key, Object newValue, Integer matchPos) {
        Utils.changeSubdocumentValue(document, key, newValue, new AtomicReference<Integer>(matchPos));
    }

    public static void changeSubdocumentValue(Object document, String key, Object newValue) {
        Utils.changeSubdocumentValue(document, key, newValue, new AtomicReference<Integer>());
    }

    static void changeSubdocumentValue(Object document, String key, Object newValue, AtomicReference<Integer> matchPos) {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = Utils.getSubkey(key, dotPos, matchPos);
            Object subObject = Utils.getFieldValueListSafe(document, mainKey);
            if (subObject instanceof Document || subObject instanceof List) {
                Utils.changeSubdocumentValue(subObject, subKey, newValue, matchPos);
            } else {
                if (!Missing.isNullOrMissing(subObject)) {
                    String element = new Document(mainKey, subObject).toString(true);
                    throw new PathNotViableException("Cannot create field '" + subKey + "' in element " + element);
                }
                Document obj = new Document();
                Utils.changeSubdocumentValue((Object)obj, subKey, newValue, matchPos);
                Utils.setListSafe(document, mainKey, obj);
            }
        } else {
            Utils.setListSafe(document, key, newValue);
        }
    }

    static Object removeSubdocumentValue(Object document, String key, Integer matchPos) {
        return Utils.removeSubdocumentValue(document, key, new AtomicReference<Integer>(matchPos));
    }

    public static Object removeSubdocumentValue(Object document, String key) {
        return Utils.removeSubdocumentValue(document, key, new AtomicReference<Integer>());
    }

    private static Object removeSubdocumentValue(Object document, String key, AtomicReference<Integer> matchPos) {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = Utils.getSubkey(key, dotPos, matchPos);
            Object subObject = Utils.getFieldValueListSafe(document, mainKey);
            if (subObject instanceof Document || subObject instanceof List) {
                return Utils.removeSubdocumentValue(subObject, subKey, matchPos);
            }
            throw new MongoServerException("failed to remove subdocument");
        }
        return Utils.removeListSafe(document, key);
    }

    public static String describeType(Object value) {
        if (value == null) {
            return "null";
        }
        return Utils.describeType(value.getClass());
    }

    private static String describeType(Class<?> type) {
        if (Missing.class.isAssignableFrom(type)) {
            return "missing";
        }
        if (Document.class.isAssignableFrom(type)) {
            return "object";
        }
        if (String.class.isAssignableFrom(type)) {
            return "string";
        }
        if (Collection.class.isAssignableFrom(type)) {
            return "array";
        }
        if (Integer.class.isAssignableFrom(type)) {
            return "int";
        }
        if (Long.class.isAssignableFrom(type)) {
            return "long";
        }
        if (Double.class.isAssignableFrom(type)) {
            return "double";
        }
        return type.getName();
    }

    static Document cursorResponse(String ns, Document ... documents) {
        return Utils.cursorResponse(ns, Arrays.asList(documents));
    }

    static Document cursorResponse(String ns, Iterable<Document> documents) {
        ArrayList<Document> firstBatch = new ArrayList<Document>();
        for (Document document : documents) {
            firstBatch.add(document);
        }
        return Utils.cursorResponse(ns, firstBatch);
    }

    static Document cursorResponse(String ns, List<Document> firstBatch) {
        Document cursor = new Document();
        cursor.put("id", (Object)0L);
        cursor.put("ns", (Object)ns);
        cursor.put("firstBatch", (Object)firstBatch);
        Document response = new Document();
        response.put("cursor", (Object)cursor);
        Utils.markOkay(response);
        return response;
    }
}

