/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.annotationprocessing;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import de.bmiag.tapir.annotationprocessing.AnnotationProcessorProvider;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.xtend.lib.macro.CodeGenerationContext;
import org.eclipse.xtend.lib.macro.CodeGenerationParticipant;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.RegisterGlobalsParticipant;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.ValidationContext;
import org.eclipse.xtend.lib.macro.ValidationParticipant;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MutableNamedElement;
import org.eclipse.xtend.lib.macro.declaration.NamedElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;

public abstract class AbstractDynamicAnnotationProcessor
implements RegisterGlobalsParticipant<NamedElement>,
TransformationParticipant<MutableNamedElement>,
CodeGenerationParticipant<NamedElement>,
ValidationParticipant<NamedElement> {
    private static final LoadingCache<String, Optional<Object>> processorInstanceCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Optional<Object>>(){

        public Optional<Object> load(String it) throws Exception {
            Optional<Object> optional = null;
            Optional<String> processorClassName = AnnotationProcessorProvider.getInstance().getProcessorClassName(it);
            Function<String, Object> function = it_1 -> {
                try {
                    return Class.forName(it_1).newInstance();
                }
                catch (Throwable throwable) {
                    throw Exceptions.sneakyThrow((Throwable)throwable);
                }
            };
            optional = processorClassName.map(function);
            return optional;
        }
    });

    public void doRegisterGlobals(List<? extends NamedElement> annotatedSourceElements, @Extension RegisterGlobalsContext context) {
        Consumer<Object> consumer = it -> {
            boolean bl = false;
            if (it instanceof RegisterGlobalsParticipant) {
                bl = true;
                ((RegisterGlobalsParticipant)it).doRegisterGlobals(annotatedSourceElements, context);
            }
        };
        this.getProcessorOptional().ifPresent(consumer);
    }

    public void doTransform(List<? extends MutableNamedElement> annotatedTargetElements, @Extension TransformationContext context) {
        Consumer<Object> consumer = it -> {
            boolean bl = false;
            if (it instanceof TransformationParticipant) {
                bl = true;
                ((TransformationParticipant)it).doTransform(annotatedTargetElements, context);
            }
        };
        this.getProcessorOptional().ifPresent(consumer);
    }

    public void doGenerateCode(List<? extends NamedElement> annotatedSourceElements, @Extension CodeGenerationContext context) {
        Consumer<Object> consumer = it -> {
            boolean bl = false;
            if (it instanceof CodeGenerationParticipant) {
                bl = true;
                ((CodeGenerationParticipant)it).doGenerateCode(annotatedSourceElements, context);
            }
        };
        this.getProcessorOptional().ifPresent(consumer);
    }

    public void doValidate(List<? extends NamedElement> annotatedTargetElements, @Extension ValidationContext context) {
        Optional<Object> processorOptional = this.getProcessorOptional();
        boolean bl = processorOptional.isPresent();
        if (bl) {
            Object processor = processorOptional.get();
            boolean bl2 = false;
            if (processor instanceof ValidationParticipant) {
                bl2 = true;
                ((ValidationParticipant)processor).doValidate(annotatedTargetElements, context);
            }
        } else {
            boolean bl3 = this.isRequired();
            if (bl3) {
                Consumer<NamedElement> consumer = it -> {
                    StringConcatenation stringConcatenation = new StringConcatenation();
                    stringConcatenation.append("The dynamic annotation processor for ");
                    String string = this.getProcessorKey();
                    stringConcatenation.append(string);
                    stringConcatenation.append(" cannot be determined.");
                    context.addError((Element)it, stringConcatenation.toString());
                };
                annotatedTargetElements.forEach(consumer);
            }
        }
    }

    protected Optional<Object> getProcessorOptional() {
        try {
            return (Optional)processorInstanceCache.get((Object)this.getProcessorKey());
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow((Throwable)throwable);
        }
    }

    protected abstract String getProcessorKey();

    protected abstract boolean isRequired();
}

