/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.annotationprocessing;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import de.bmiag.tapir.annotationprocessing.AnnotationProcessorProvider;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.xtend.lib.macro.CodeGenerationContext;
import org.eclipse.xtend.lib.macro.CodeGenerationParticipant;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.RegisterGlobalsParticipant;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.ValidationContext;
import org.eclipse.xtend.lib.macro.ValidationParticipant;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MutableNamedElement;
import org.eclipse.xtend.lib.macro.declaration.NamedElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;

public abstract class AbstractDynamicAnnotationProcessor
implements RegisterGlobalsParticipant<NamedElement>,
TransformationParticipant<MutableNamedElement>,
CodeGenerationParticipant<NamedElement>,
ValidationParticipant<NamedElement> {
    private static final LoadingCache<String, Optional<Object>> processorInstanceCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Optional<Object>>(){

        public Optional<Object> load(String it) throws Exception {
            Optional<Object> _xblockexpression = null;
            Optional<String> processorClassName = AnnotationProcessorProvider.getInstance().getProcessorClassName(it);
            Function<String, Object> _function = it_1 -> {
                try {
                    return Class.forName(it_1).newInstance();
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            _xblockexpression = processorClassName.map(_function);
            return _xblockexpression;
        }
    });

    public void doRegisterGlobals(List<? extends NamedElement> annotatedSourceElements, @Extension RegisterGlobalsContext context) {
        Consumer<Object> _function = it -> {
            boolean _matched = false;
            if (it instanceof RegisterGlobalsParticipant) {
                _matched = true;
                ((RegisterGlobalsParticipant)it).doRegisterGlobals(annotatedSourceElements, context);
            }
        };
        this.getProcessorOptional().ifPresent(_function);
    }

    public void doTransform(List<? extends MutableNamedElement> annotatedTargetElements, @Extension TransformationContext context) {
        Consumer<Object> _function = it -> {
            boolean _matched = false;
            if (it instanceof TransformationParticipant) {
                _matched = true;
                ((TransformationParticipant)it).doTransform(annotatedTargetElements, context);
            }
        };
        this.getProcessorOptional().ifPresent(_function);
    }

    public void doGenerateCode(List<? extends NamedElement> annotatedSourceElements, @Extension CodeGenerationContext context) {
        Consumer<Object> _function = it -> {
            boolean _matched = false;
            if (it instanceof CodeGenerationParticipant) {
                _matched = true;
                ((CodeGenerationParticipant)it).doGenerateCode(annotatedSourceElements, context);
            }
        };
        this.getProcessorOptional().ifPresent(_function);
    }

    public void doValidate(List<? extends NamedElement> annotatedTargetElements, @Extension ValidationContext context) {
        Optional<Object> processorOptional = this.getProcessorOptional();
        boolean _isPresent = processorOptional.isPresent();
        if (_isPresent) {
            Object processor = processorOptional.get();
            boolean _matched = false;
            if (processor instanceof ValidationParticipant) {
                _matched = true;
                ((ValidationParticipant)processor).doValidate(annotatedTargetElements, context);
            }
        } else {
            boolean _isRequired = this.isRequired();
            if (_isRequired) {
                Consumer<NamedElement> _function = it -> {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("The dynamic annotation processor for ");
                    String _processorKey = this.getProcessorKey();
                    _builder.append(_processorKey);
                    _builder.append(" cannot be determined.");
                    context.addError((Element)it, _builder.toString());
                };
                annotatedTargetElements.forEach(_function);
            }
        }
    }

    protected Optional<Object> getProcessorOptional() {
        try {
            return (Optional)processorInstanceCache.get((Object)this.getProcessorKey());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected abstract String getProcessorKey();

    protected abstract boolean isRequired();
}

