/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.core.i18n;

import de.beyondjava.angularFaces.core.Configuration;
import de.beyondjava.angularFaces.core.tagTransformer.AFTagAttributes;
import de.beyondjava.angularFaces.core.tagTransformer.TagAttributeUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;

public class LanguageAwareIncludeHandler
extends TagHandler
implements FaceletHandler {
    private final TagAttribute src;
    private final ComponentConfig config;

    public LanguageAwareIncludeHandler(ComponentConfig config) {
        super((TagConfig)config);
        TagAttribute attr = null;
        attr = config.getTag().getAttributes().get("src");
        if (null == attr) {
            attr = config.getTag().getAttributes().get("file");
        }
        if (null == attr) {
            attr = config.getTag().getAttributes().get("page");
        }
        if (null == attr) {
            throw new TagException(config.getTag(), "Attribute 'src', 'file' or 'page' is required");
        }
        this.src = attr;
        this.config = config;
    }

    public static void includeCompositeComponent(UIComponent parent, String taglibURI, String tagName, String id) {
        FacesContext context = FacesContext.getCurrentInstance();
        UIComponent composite = context.getApplication().getViewHandler().getViewDeclarationLanguage(context, context.getViewRoot().getViewId()).createComponent(context, taglibURI, tagName, null);
        composite.setId(id);
        parent.getChildren().add(composite);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        Iterator locales = FacesContext.getCurrentInstance().getExternalContext().getRequestLocales();
        while (locales.hasNext()) {
            String language = ((Locale)locales.next()).getLanguage();
            try {
                this.tryLanguage(ctx, parent, language);
                return;
            }
            catch (ReflectiveOperationException ex) {
            }
            catch (FileNotFoundException ex) {
            }
        }
        try {
            this.tryLanguage(ctx, parent, null);
            return;
        }
        catch (ReflectiveOperationException ex) {
            throw new FacesException("Couldn't find the language file", (Throwable)ex);
        }
    }

    private void tryLanguage(FaceletContext ctx, UIComponent parent, String language) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        TagConfig cfg = this.getLanguageAwareTag(language);
        Class<?> includeClass = Configuration.myFaces ? Class.forName("org.apache.myfaces.view.facelets.tag.ui.IncludeHandler") : Class.forName("com.sun.faces.facelets.tag.ui.IncludeHandler");
        Constructor<?> constructor = includeClass.getConstructor(TagConfig.class);
        TagHandler worker = (TagHandler)constructor.newInstance(cfg);
        worker.apply(ctx, parent);
    }

    private TagConfig getLanguageAwareTag(final String language) {
        TagConfig cfg = new TagConfig(){

            public String getTagId() {
                return LanguageAwareIncludeHandler.this.config.getTagId();
            }

            public Tag getTag() {
                Tag tag = LanguageAwareIncludeHandler.this.config.getTag();
                TagAttribute[] newAttributes = new TagAttribute[1];
                String filename = LanguageAwareIncludeHandler.this.src.getValue();
                String modifiedFilename = language == null || language.length() == 0 ? filename : filename.replace(".xhtml", "_" + language + ".xhtml");
                newAttributes[0] = TagAttributeUtilities.createTagAttribute(tag.getLocation(), "", "src", "src", modifiedFilename);
                AFTagAttributes modified = new AFTagAttributes(newAttributes);
                Tag newTag = new Tag(tag.getLocation(), "http://xmlns.jcp.org/jsf/html", tag.getLocalName(), tag.getQName(), (TagAttributes)modified);
                return newTag;
            }

            public FaceletHandler getNextHandler() {
                return LanguageAwareIncludeHandler.this.config.getNextHandler();
            }
        };
        return cfg;
    }
}

