/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.impl;

import brainslug.flow.context.BrainslugContext;
import brainslug.flow.event.FlowEvent;
import brainslug.flow.event.TriggerEvent;
import brainslug.flow.execution.FlowExecutor;
import brainslug.flow.execution.FlowNodeExectuor;
import brainslug.flow.execution.Token;
import brainslug.flow.execution.TokenStore;
import brainslug.flow.execution.TokenStoreAware;
import brainslug.flow.execution.impl.ChoiceNodeExecutor;
import brainslug.flow.execution.impl.DefaultExecutionContext;
import brainslug.flow.execution.impl.DefaultNodeExecutor;
import brainslug.flow.execution.impl.JoinNodeExecutor;
import brainslug.flow.execution.impl.TaskNodeExecutor;
import brainslug.flow.model.ChoiceDefinition;
import brainslug.flow.model.EventDefinition;
import brainslug.flow.model.FlowNodeDefinition;
import brainslug.flow.model.Identifier;
import brainslug.flow.model.JoinDefinition;
import brainslug.flow.model.MergeDefinition;
import brainslug.flow.model.ParallelDefinition;
import brainslug.flow.model.TaskDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TokenFlowExecutor
implements FlowExecutor {
    protected BrainslugContext context;
    protected TokenStore tokenStore;
    Map<Class<? extends FlowNodeDefinition>, FlowNodeExectuor> nodeExecutors = new HashMap<Class<? extends FlowNodeDefinition>, FlowNodeExectuor>();
    Map<Class<? extends FlowEvent>, EventHandler> eventHandlers = new HashMap<Class<? extends FlowEvent>, EventHandler>();
    protected EventHandler<TriggerEvent> triggerNodeHandler = new EventHandler<TriggerEvent>(){

        @Override
        public void handle(TriggerEvent triggerEvent) {
            FlowNodeDefinition<?> node = TokenFlowExecutor.this.getNode(triggerEvent.getDefinitionId(), triggerEvent.getNodeId());
            FlowNodeExectuor<FlowNodeDefinition<?>> nodeExecutor = TokenFlowExecutor.this.getNodeExecutor(node);
            DefaultExecutionContext executionContext = new DefaultExecutionContext(triggerEvent, TokenFlowExecutor.this.context);
            nodeExecutor.preExecute(executionContext);
            List<FlowNodeDefinition> next = nodeExecutor.execute(node, executionContext);
            nodeExecutor.postExecute(executionContext);
            TokenFlowExecutor.this.triggerNext(triggerEvent, node, next);
        }
    };

    protected void triggerNext(TriggerEvent event, FlowNodeDefinition<?> node, List<FlowNodeDefinition> next) {
        for (FlowNodeDefinition nextNode : next) {
            if (event.getInstanceId() != null) {
                this.tokenStore.addToken(event.getInstanceId(), nextNode.getId(), new Token(node.getId()));
            }
            FlowEvent triggerEvent = new TriggerEvent().nodeId(nextNode.getId()).sourceNodeId(node.getId()).definitionId(event.getDefinitionId()).instanceId(event.getInstanceId());
            this.context.getEventDispatcher().push(triggerEvent);
        }
    }

    public TokenFlowExecutor(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
        this.addNodeExecutorMappings();
        this.addEventHandlers();
    }

    private void addEventHandlers() {
        this.eventHandlers.put(TriggerEvent.class, this.triggerNodeHandler);
    }

    void addNodeExecutorMappings() {
        this.nodeExecutors.put(EventDefinition.class, new DefaultNodeExecutor());
        this.nodeExecutors.put(ParallelDefinition.class, new DefaultNodeExecutor());
        this.nodeExecutors.put(MergeDefinition.class, new DefaultNodeExecutor());
        this.nodeExecutors.put(ChoiceDefinition.class, new ChoiceNodeExecutor());
        this.nodeExecutors.put(JoinDefinition.class, new JoinNodeExecutor(this.tokenStore));
        this.nodeExecutors.put(TaskDefinition.class, new TaskNodeExecutor());
    }

    @Override
    public void notify(FlowEvent event) {
        this.eventHandlers.get(event.getClass()).handle(event);
    }

    FlowNodeDefinition<?> getNode(Identifier definitionId, Identifier nodeId) {
        FlowNodeDefinition node = this.context.getFlowDefinitions().findById(definitionId).getNode(nodeId);
        if (node == null) {
            throw new IllegalArgumentException(String.format("node for does not exist %s", nodeId));
        }
        return node;
    }

    <T extends FlowNodeDefinition> FlowNodeExectuor<T> getNodeExecutor(T nodeDefinition) {
        FlowNodeExectuor nodeExecutor = this.nodeExecutors.get(nodeDefinition.getClass());
        if (nodeExecutor == null) {
            throw new IllegalArgumentException(String.format("no executor found for node definition %s", nodeDefinition));
        }
        if (nodeExecutor instanceof TokenStoreAware) {
            ((TokenStoreAware)((Object)nodeExecutor)).setTokenStore(this.tokenStore);
        }
        return nodeExecutor;
    }

    @Override
    public void setContext(BrainslugContext context) {
        this.context = context;
    }

    @Override
    public Identifier startFlow(Identifier definitionId, Identifier nodeId) {
        FlowNodeDefinition<?> node = this.getNode(definitionId, nodeId);
        Identifier instanceId = this.context.getIdGenerator().generateId();
        this.tokenStore.createInstance(instanceId);
        this.tokenStore.addToken(instanceId, nodeId, new Token(nodeId));
        this.context.getEventDispatcher().push(new TriggerEvent().sourceNodeId(node.getId()).nodeId(node.getId()).definitionId(definitionId).instanceId(instanceId));
        this.context.getEventDispatcher().dispatch();
        return instanceId;
    }

    static interface EventHandler<T extends FlowEvent> {
        public void handle(T var1);
    }
}

