/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.token;

import brainslug.flow.definition.Identifier;
import brainslug.flow.execution.token.Token;
import brainslug.flow.execution.token.TokenList;
import brainslug.flow.execution.token.TokenStore;
import brainslug.flow.instance.FlowInstanceTokenList;
import brainslug.util.IdGenerator;
import brainslug.util.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HashMapTokenStore
implements TokenStore {
    Map<Identifier, Map<Identifier, Token>> instanceToTokenMap = new ConcurrentHashMap<Identifier, Map<Identifier, Token>>();
    IdGenerator idGenerator;

    public HashMapTokenStore(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public List<Token> tokensForInstance(Identifier instanceId) {
        return new ArrayList<Token>(this.getOrCreateInstanceTokenMap(instanceId).values());
    }

    Map<Identifier, Token> getOrCreateInstanceTokenMap(Identifier instanceId) {
        if (this.instanceToTokenMap.get(instanceId) == null) {
            ConcurrentHashMap<Identifier, Token> instanceTokens = new ConcurrentHashMap<Identifier, Token>();
            this.instanceToTokenMap.put(instanceId, instanceTokens);
            return instanceTokens;
        }
        return this.instanceToTokenMap.get(instanceId);
    }

    @Override
    public FlowInstanceTokenList getInstanceTokens(Identifier instanceId) {
        return new TokenList(this.tokensForInstance(instanceId));
    }

    @Override
    public FlowInstanceTokenList getNodeTokens(Identifier nodeId, Identifier instanceId) {
        ArrayList<Token> nodeTokens = new ArrayList<Token>();
        for (Token instanceToken : this.tokensForInstance(instanceId)) {
            if (!instanceToken.getNodeId().equals(nodeId) || instanceToken.isDead()) continue;
            nodeTokens.add(instanceToken);
        }
        return new TokenList(nodeTokens);
    }

    @Override
    public Token addToken(Identifier instanceId, Identifier nodeId, Option<Identifier> sourceNodeId, boolean isFinal) {
        Token token = new Token(this.idGenerator.generateId(), nodeId, sourceNodeId, instanceId, false, isFinal);
        this.getOrCreateInstanceTokenMap(instanceId).put(token.getId(), token);
        return token;
    }

    @Override
    public boolean setDead(Identifier instanceId, Identifier tokenIdToDelete) {
        Option<Token> token = this.findToken(instanceId, tokenIdToDelete);
        if (token.isPresent()) {
            ((Token)token.get()).setDead(true);
            return true;
        }
        return false;
    }

    private Option<Token> findToken(Identifier instanceId, Identifier tokenIdToDelete) {
        for (Token nextToken : this.tokensForInstance(instanceId)) {
            if (!nextToken.getId().equals(tokenIdToDelete)) continue;
            return Option.of((Object)nextToken);
        }
        return Option.empty();
    }

    @Override
    public boolean setFinal(Identifier instanceId, Identifier tokenId) {
        Option<Token> token = this.findToken(instanceId, tokenId);
        if (token.isPresent()) {
            ((Token)token.get()).setFinal(true);
            return true;
        }
        return false;
    }
}

