/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.property;

import brainslug.flow.definition.Identifier;
import brainslug.flow.execution.property.BooleanProperty;
import brainslug.flow.execution.property.DateProperty;
import brainslug.flow.execution.property.DoubleProperty;
import brainslug.flow.execution.property.FloatProperty;
import brainslug.flow.execution.property.IntProperty;
import brainslug.flow.execution.property.LongProperty;
import brainslug.flow.execution.property.ObjectProperty;
import brainslug.flow.execution.property.StringProperty;
import brainslug.flow.expression.Property;
import brainslug.flow.instance.FlowInstanceProperties;
import brainslug.flow.instance.FlowInstanceProperty;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ExecutionProperties
implements FlowInstanceProperties<ExecutionProperties, FlowInstanceProperty<?>> {
    Map<String, FlowInstanceProperty<?>> properties = new HashMap();

    public <T extends FlowInstanceProperty> ExecutionProperties from(Collection<T> properties) {
        for (FlowInstanceProperty property : properties) {
            this.properties.put(property.getKey(), property);
        }
        return this;
    }

    public ExecutionProperties with(Identifier key, Object value) {
        return this.with(key.stringValue(), value);
    }

    public ExecutionProperties with(Property<?> key, Object value) {
        return this.with((Identifier)key.getValue(), value);
    }

    public ExecutionProperties with(String key, Object value) {
        this.properties.put(key, this.createPropertyFromValue(key, value));
        return this;
    }

    FlowInstanceProperty<?> createPropertyFromValue(String key, Object value) {
        if (value instanceof Long) {
            return new LongProperty(key, (Long)value);
        }
        if (value instanceof Integer) {
            return new IntProperty(key, (Integer)value);
        }
        if (value instanceof Double) {
            return new DoubleProperty(key, (Double)value);
        }
        if (value instanceof Float) {
            return new FloatProperty(key, (Float)value);
        }
        if (value instanceof Boolean) {
            return new BooleanProperty(key, (Boolean)value);
        }
        if (value instanceof String) {
            return new StringProperty(key, (String)value);
        }
        if (value instanceof Date) {
            return new DateProperty(key, (Date)value);
        }
        return new ObjectProperty(key, value);
    }

    public ExecutionProperties withAll(ExecutionProperties executionProperties) {
        for (FlowInstanceProperty<?> executionProperty : executionProperties.getValues()) {
            this.properties.put(executionProperty.getKey(), executionProperty);
        }
        return this;
    }

    public <T> T getValue(String key, Class<T> clazz) {
        return (T)this.properties.get(key).getValue();
    }

    public <T> FlowInstanceProperty<T> getProperty(String key, Class<T> clazz) {
        return this.properties.get(key);
    }

    public FlowInstanceProperty<?> get(String key) {
        return this.properties.get(key);
    }

    public Collection<FlowInstanceProperty<?>> getValues() {
        return this.properties.values();
    }

    public static ExecutionProperties newProperties() {
        return new ExecutionProperties();
    }

    public String toString() {
        return "ExecutionProperties{properties=" + this.properties + '}';
    }
}

