/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.node;

import brainslug.flow.context.ExecutionContext;
import brainslug.flow.execution.async.AsyncTrigger;
import brainslug.flow.execution.async.AsyncTriggerStore;
import brainslug.flow.execution.expression.ExpressionEvaluator;
import brainslug.flow.execution.node.DefaultNodeExecutor;
import brainslug.flow.execution.node.FlowNodeExecutionResult;
import brainslug.flow.expression.Expression;
import brainslug.flow.expression.PredicateExpression;
import brainslug.flow.node.EventDefinition;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.event.IntermediateEvent;
import brainslug.flow.node.event.timer.TimerDefinition;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class EventNodeExecutor
extends DefaultNodeExecutor<EventDefinition> {
    AsyncTriggerStore asyncTriggerStore;
    ExpressionEvaluator expressionEvaluator;

    public EventNodeExecutor(AsyncTriggerStore asyncTriggerStore, ExpressionEvaluator expressionEvaluator) {
        this.asyncTriggerStore = asyncTriggerStore;
        this.expressionEvaluator = expressionEvaluator;
    }

    @Override
    public FlowNodeExecutionResult execute(EventDefinition eventDefinition, ExecutionContext execution) {
        if (this.shouldContinueImmediately(eventDefinition, execution)) {
            return this.takeAllAndRemoveFirst((FlowNodeDefinition<?>)eventDefinition, execution.getInstance());
        }
        if (eventDefinition.getConditionPredicate().isPresent()) {
            return this.executeConditionalEvent(eventDefinition, execution);
        }
        if (this.waitingForSignal(eventDefinition, execution)) {
            this.addTimersIfDefined(eventDefinition, execution);
            return this.takeNone((FlowNodeDefinition<?>)eventDefinition, execution.getInstance());
        }
        return this.takeAllAndRemoveFirst((FlowNodeDefinition<?>)eventDefinition, execution.getInstance());
    }

    protected boolean shouldContinueImmediately(EventDefinition eventDefinition, ExecutionContext execution) {
        return eventDefinition.getContinuePredicate().isPresent() && this.predicateIsFulfilled((PredicateExpression)eventDefinition.getContinuePredicate().get(), execution);
    }

    protected FlowNodeExecutionResult executeConditionalEvent(EventDefinition eventDefinition, ExecutionContext execution) {
        if (execution.isSignaling()) {
            return this.takeAllAndRemoveFirst((FlowNodeDefinition<?>)eventDefinition, execution.getInstance());
        }
        if (execution.isAsync() && this.predicateIsFulfilled((PredicateExpression)eventDefinition.getConditionPredicate().get(), execution)) {
            return this.takeAllAndRemoveFirst((FlowNodeDefinition<?>)eventDefinition, execution.getInstance());
        }
        this.createAsyncTrigger(eventDefinition, execution, this.nextPollingDate(eventDefinition));
        return this.takeNone((FlowNodeDefinition<?>)eventDefinition, execution.getInstance());
    }

    private long nextPollingDate(EventDefinition eventDefinition) {
        if (eventDefinition.getConditionPollingTimeDefinition().isPresent()) {
            TimerDefinition pollingTimer = (TimerDefinition)eventDefinition.getConditionPollingTimeDefinition().get();
            return this.dateAfterDuration(pollingTimer.getDuration(), pollingTimer.getUnit());
        }
        return this.dateAfterDuration(3L, TimeUnit.SECONDS);
    }

    protected void addTimersIfDefined(EventDefinition eventDefinition, ExecutionContext execution) {
        if (eventDefinition.getElapsedTimeDefinition().isPresent()) {
            this.createAsyncTrigger(eventDefinition, execution, this.getElapsedTimeDueDate(eventDefinition));
        }
    }

    protected void createAsyncTrigger(EventDefinition eventDefinition, ExecutionContext execution, long dueDate) {
        this.asyncTriggerStore.storeTrigger(new AsyncTrigger().withNodeId(eventDefinition.getId()).withDefinitionId(execution.getInstance().getDefinitionId()).withInstanceId(execution.getInstance().getIdentifier()).withDueDate(dueDate));
    }

    long getElapsedTimeDueDate(EventDefinition eventDefinition) {
        TimerDefinition timerDefinition = (TimerDefinition)eventDefinition.getElapsedTimeDefinition().get();
        return this.dateAfterDuration(timerDefinition.getDuration(), timerDefinition.getUnit());
    }

    private long dateAfterDuration(long duration, TimeUnit unit) {
        return this.getCurrentTime() + unit.toMillis(duration);
    }

    protected long getCurrentTime() {
        return new Date().getTime();
    }

    protected boolean waitingForSignal(EventDefinition eventDefinition, ExecutionContext context) {
        return eventDefinition.is(IntermediateEvent.class) && !context.isSignaling();
    }

    protected boolean predicateIsFulfilled(PredicateExpression eventPredicate, ExecutionContext execution) {
        return this.expressionEvaluator.evaluate((Expression)eventPredicate, execution, Boolean.class);
    }
}

