/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.async;

import brainslug.flow.execution.async.AbstractAsyncTriggerScheduler;
import brainslug.flow.execution.async.AsyncTriggerExecutionResult;
import brainslug.flow.execution.async.AsyncTriggerExecutor;
import brainslug.flow.execution.async.ExecuteTasksCallable;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceAsyncTriggerScheduler
extends AbstractAsyncTriggerScheduler {
    private Logger log = LoggerFactory.getLogger(ExecutorServiceAsyncTriggerScheduler.class);
    ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    ExecutorService taskExecutorService = Executors.newCachedThreadPool();
    AsyncTriggerExecutor asyncTriggerExecutor = new AsyncTriggerExecutor();

    @Override
    protected void internalStart() {
        this.log.info("starting async job scheduling with options: " + this.options);
        Runnable executeTasksRunnable = new Runnable(){

            @Override
            public void run() {
                FutureTask<List<Future<AsyncTriggerExecutionResult>>> executeTasks = new FutureTask<List<Future<AsyncTriggerExecutionResult>>>(new ExecuteTasksCallable(ExecutorServiceAsyncTriggerScheduler.this.context, ExecutorServiceAsyncTriggerScheduler.this.asyncTriggerStore, ExecutorServiceAsyncTriggerScheduler.this.options, ExecutorServiceAsyncTriggerScheduler.this.taskExecutorService, ExecutorServiceAsyncTriggerScheduler.this.asyncTriggerExecutor));
                executeTasks.run();
            }
        };
        this.scheduledExecutorService.scheduleAtFixedRate(executeTasksRunnable, this.options.getScheduleDelay(), this.options.getSchedulePeriod(), this.options.getScheduleUnit());
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public ExecutorServiceAsyncTriggerScheduler withScheduledExecutorService(ScheduledExecutorService executorService) {
        this.scheduledExecutorService = executorService;
        return this;
    }

    public ExecutorService getTaskExecutorService() {
        return this.taskExecutorService;
    }

    public ExecutorServiceAsyncTriggerScheduler withTaskExecutorService(ExecutorService taskExecutor) {
        this.taskExecutorService = taskExecutor;
        return this;
    }

    public AsyncTriggerExecutor getAsyncTriggerExecutor() {
        return this.asyncTriggerExecutor;
    }

    public ExecutorServiceAsyncTriggerScheduler withAsyncTriggerExecutor(AsyncTriggerExecutor asyncTriggerExecutor) {
        this.asyncTriggerExecutor = asyncTriggerExecutor;
        return this;
    }
}

