/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.context;

import brainslug.flow.context.BrainslugExecutionContext;
import brainslug.flow.context.ExecutionContext;
import brainslug.flow.context.Registry;
import brainslug.flow.context.TriggerContext;
import brainslug.flow.execution.property.store.PropertyStore;
import brainslug.flow.instance.FlowInstance;
import brainslug.flow.instance.FlowInstanceProperties;
import brainslug.flow.instance.FlowInstanceProperty;

public class ExecutionContextFactory {
    private final PropertyStore propertyStore;
    private final Registry registry;

    public ExecutionContextFactory(PropertyStore propertyStore, Registry registry) {
        this.propertyStore = propertyStore;
        this.registry = registry;
    }

    public ExecutionContext createExecutionContext(FlowInstance flowInstance, TriggerContext trigger) {
        BrainslugExecutionContext executionContext = new BrainslugExecutionContext(flowInstance, trigger, this.registry);
        executionContext.setProperties(this.mergeProperties(trigger, executionContext));
        return executionContext;
    }

    protected FlowInstanceProperties mergeProperties(TriggerContext trigger, ExecutionContext executionContext) {
        FlowInstanceProperties<?, FlowInstanceProperty<?>> properties = this.propertyStore.getProperties(executionContext.getInstance().getIdentifier());
        properties.withAll(trigger.getProperties());
        return properties;
    }
}

