/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.context;

import brainslug.flow.context.BrainslugContext;
import brainslug.flow.context.Registry;
import brainslug.flow.context.Trigger;
import brainslug.flow.context.TriggerContext;
import brainslug.flow.definition.DefinitionStore;
import brainslug.flow.definition.FlowDefinition;
import brainslug.flow.definition.Identifier;
import brainslug.flow.execution.FlowExecutor;
import brainslug.flow.execution.async.AsyncFlowStartScheduler;
import brainslug.flow.execution.async.AsyncTriggerScheduler;
import brainslug.flow.execution.async.AsyncTriggerSchedulerOptions;
import brainslug.flow.execution.async.AsyncTriggerStore;
import brainslug.flow.execution.async.SchedulerOptions;
import brainslug.flow.execution.expression.ExpressionEvaluator;
import brainslug.flow.execution.instance.InstanceStore;
import brainslug.flow.execution.node.task.CallDefinitionExecutor;
import brainslug.flow.execution.token.TokenStore;
import brainslug.flow.instance.FlowInstance;
import brainslug.flow.instance.FlowInstanceProperties;
import brainslug.flow.instance.FlowInstanceSelector;
import brainslug.flow.listener.ListenerManager;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.util.Preconditions;
import java.util.Collection;

public class DefaultBrainslugContext
implements BrainslugContext {
    AsyncTriggerScheduler asyncTriggerScheduler;
    AsyncTriggerStore asyncTriggerStore;
    AsyncTriggerSchedulerOptions asyncTriggerSchedulerOptions;
    AsyncFlowStartScheduler asyncFlowStartScheduler;
    SchedulerOptions asyncFlowStartSchedulerOptions;
    DefinitionStore definitionStore;
    ListenerManager listenerManager;
    CallDefinitionExecutor callDefinitionExecutor;
    ExpressionEvaluator expressionEvaluator;
    Registry registry;
    FlowExecutor flowExecutor;
    TokenStore tokenStore;
    private final InstanceStore instanceStore;

    protected DefaultBrainslugContext(AsyncTriggerScheduler asyncTriggerScheduler, AsyncTriggerStore asyncTriggerStore, AsyncTriggerSchedulerOptions asyncTriggerSchedulerOptions, AsyncFlowStartScheduler asyncFlowStartScheduler, SchedulerOptions asyncFlowStartSchedulerOptions, DefinitionStore definitionStore, ListenerManager listenerManager, CallDefinitionExecutor callDefinitionExecutor, ExpressionEvaluator expressionEvaluator, Registry registry, FlowExecutor flowExecutor, TokenStore tokenStore, InstanceStore instanceStore) {
        this.asyncTriggerScheduler = asyncTriggerScheduler;
        this.asyncTriggerStore = asyncTriggerStore;
        this.asyncTriggerSchedulerOptions = asyncTriggerSchedulerOptions;
        this.asyncFlowStartScheduler = asyncFlowStartScheduler;
        this.asyncFlowStartSchedulerOptions = asyncFlowStartSchedulerOptions;
        this.definitionStore = definitionStore;
        this.listenerManager = listenerManager;
        this.callDefinitionExecutor = callDefinitionExecutor;
        this.expressionEvaluator = expressionEvaluator;
        this.registry = registry;
        this.flowExecutor = flowExecutor;
        this.tokenStore = tokenStore;
        this.instanceStore = instanceStore;
    }

    public DefaultBrainslugContext addFlowDefinition(FlowDefinition flowDefinition) {
        this.definitionStore.addDefinition(flowDefinition);
        return this;
    }

    public Collection<FlowDefinition> getDefinitions() {
        return this.definitionStore.getDefinitions();
    }

    public FlowDefinition getDefinitionById(Identifier flowId) {
        return this.definitionStore.findById(flowId);
    }

    public DefinitionStore getDefinitionStore() {
        return this.definitionStore;
    }

    public void trigger(TriggerContext context) {
        this.flowExecutor.trigger(context);
    }

    public void signalEvent(Identifier eventId, Identifier instanceId, Identifier definitionId) {
        this.trigger((TriggerContext)((Trigger)((Trigger)((Trigger)new Trigger().nodeId(eventId)).instanceId(instanceId)).definitionId(definitionId)).signaling(true));
    }

    public FlowInstance startFlow(FlowDefinition flowDefinition) {
        return this.startFlow(flowDefinition.getId());
    }

    public FlowInstance startFlow(FlowDefinition flowDefinition, FlowInstanceProperties properties) {
        return this.startFlow(flowDefinition, flowDefinition.requireSingleStartNode(), properties);
    }

    public FlowInstance startFlow(FlowDefinition flowDefinition, FlowNodeDefinition startNode, FlowInstanceProperties properties) {
        return this.startFlow(flowDefinition.getId(), startNode.getId(), properties);
    }

    public FlowInstance startFlow(Identifier definitionId) {
        return this.startFlow(definitionId, this.getDefinitionById(definitionId).requireSingleStartNode().getId());
    }

    public FlowInstance startFlow(Identifier definitionId, Identifier startNodeId) {
        return this.flowExecutor.startFlow((TriggerContext)((Trigger)new Trigger().definitionId(definitionId)).nodeId(startNodeId));
    }

    public FlowInstance startFlow(Identifier definitionId, FlowInstanceProperties properties) {
        return this.startFlow(definitionId, this.getDefinitionById(definitionId).requireSingleStartNode().getId(), properties);
    }

    public FlowInstance startFlow(Identifier definitionId, Identifier startNodeId, FlowInstanceProperties properties) {
        Object trigger = ((Trigger)((Trigger)new Trigger().definitionId(definitionId)).nodeId(startNodeId)).properties(properties);
        return this.flowExecutor.startFlow((TriggerContext)trigger);
    }

    public Collection<? extends FlowInstance> findInstances(FlowInstanceSelector instanceSelector) {
        return this.instanceStore.findInstances(instanceSelector);
    }

    public BrainslugContext init() {
        ((AsyncTriggerScheduler)Preconditions.notNull((Object)this.asyncTriggerScheduler)).start(this, this.asyncTriggerStore, this.asyncTriggerSchedulerOptions);
        ((AsyncFlowStartScheduler)Preconditions.notNull((Object)this.asyncFlowStartScheduler)).start(this.asyncFlowStartSchedulerOptions, this, this.getDefinitionStore().getDefinitions());
        return this;
    }

    public BrainslugContext destroy() {
        ((AsyncTriggerScheduler)Preconditions.notNull((Object)this.asyncTriggerScheduler)).stop();
        ((AsyncFlowStartScheduler)Preconditions.notNull((Object)this.asyncFlowStartScheduler)).stop();
        return this;
    }

    public <T> BrainslugContext registerService(Class<T> serviceClass, T serviceInstance) {
        this.registry.registerService(serviceClass, serviceInstance);
        return this;
    }

    public <T> T getService(Class<T> serviceClass) {
        return (T)this.registry.getService(serviceClass);
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return this.expressionEvaluator;
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public AsyncTriggerScheduler getAsyncTriggerScheduler() {
        return this.asyncTriggerScheduler;
    }

    public AsyncTriggerStore getAsyncTriggerStore() {
        return this.asyncTriggerStore;
    }

    public CallDefinitionExecutor getCallDefinitionExecutor() {
        return this.callDefinitionExecutor;
    }
}

