/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.node;

import brainslug.flow.context.ExecutionContext;
import brainslug.flow.definition.DefinitionStore;
import brainslug.flow.execution.async.AsyncTrigger;
import brainslug.flow.execution.async.AsyncTriggerErrorDetails;
import brainslug.flow.execution.async.AsyncTriggerScheduler;
import brainslug.flow.execution.expression.ExpressionEvaluator;
import brainslug.flow.execution.node.DefaultNodeExecutor;
import brainslug.flow.execution.node.FlowNodeExecutionResult;
import brainslug.flow.execution.node.task.CallDefinitionExecutor;
import brainslug.flow.expression.Expression;
import brainslug.flow.expression.PredicateExpression;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.task.AbstractTaskDefinition;
import brainslug.flow.node.task.CallDefinition;
import brainslug.flow.node.task.GoalDefinition;
import brainslug.flow.node.task.HandlerCallDefinition;
import brainslug.util.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskNodeExecutor
extends DefaultNodeExecutor<AbstractTaskDefinition<?>> {
    private Logger log = LoggerFactory.getLogger(TaskNodeExecutor.class);
    DefinitionStore definitionStore;
    ExpressionEvaluator expressionEvaluator;
    CallDefinitionExecutor callDefinitionExecutor;
    AsyncTriggerScheduler asyncTriggerScheduler;

    public TaskNodeExecutor(DefinitionStore definitionStore, ExpressionEvaluator expressionEvaluator, CallDefinitionExecutor callDefinitionExecutor, AsyncTriggerScheduler asyncTriggerScheduler) {
        this.definitionStore = definitionStore;
        this.expressionEvaluator = expressionEvaluator;
        this.callDefinitionExecutor = callDefinitionExecutor;
        this.asyncTriggerScheduler = asyncTriggerScheduler;
    }

    @Override
    public FlowNodeExecutionResult execute(AbstractTaskDefinition<?> taskDefinition, ExecutionContext execution) {
        if (taskDefinition.getGoal().isPresent() && this.goalIsFulfilled((GoalDefinition)taskDefinition.getGoal().get(), execution)) {
            return this.takeAllAndRemoveFirst((FlowNodeDefinition<?>)taskDefinition, execution.getInstance());
        }
        if (taskDefinition.isAsync() && !execution.isAsync()) {
            this.scheduleAsyncTask(taskDefinition, execution);
            return this.takeNone((FlowNodeDefinition<?>)taskDefinition, execution.getInstance());
        }
        if (this.isExecutable(taskDefinition)) {
            return this.executeWithOptionalAsyncRetry(taskDefinition, execution);
        }
        this.log.warn("executing task node without execution definition, please specify the task node execution by using a delegate class or call definition to actually do something in this task");
        return this.takeAllAndRemoveFirst((FlowNodeDefinition<?>)taskDefinition, execution.getInstance());
    }

    protected FlowNodeExecutionResult executeWithOptionalAsyncRetry(AbstractTaskDefinition taskDefinition, ExecutionContext execution) {
        try {
            if (Option.of((Object)taskDefinition.getDelegateClass()).isPresent()) {
                HandlerCallDefinition callDefinition = new HandlerCallDefinition(execution.service(taskDefinition.getDelegateClass()));
                this.callDefinitionExecutor.execute((CallDefinition)callDefinition, execution);
                return this.takeAllAndRemoveFirst((FlowNodeDefinition<?>)taskDefinition, execution.getInstance());
            }
            if (Option.of((Object)taskDefinition.getMethodCall()).isPresent()) {
                this.callDefinitionExecutor.execute(taskDefinition.getMethodCall(), execution);
                return this.takeAllAndRemoveFirst((FlowNodeDefinition<?>)taskDefinition, execution.getInstance());
            }
            throw new IllegalStateException("this method should only be called with executable " + taskDefinition);
        }
        catch (Exception e) {
            this.log.error(String.format("error during task (%s) execution: ", taskDefinition), (Throwable)e);
            if (taskDefinition.isRetryAsync()) {
                return this.scheduleRetry(e, taskDefinition, execution);
            }
            return this.takeNone((FlowNodeDefinition<?>)taskDefinition, execution.getInstance());
        }
    }

    private FlowNodeExecutionResult scheduleRetry(Exception e, AbstractTaskDefinition taskDefinition, ExecutionContext execution) {
        this.asyncTriggerScheduler.schedule(new AsyncTrigger().incrementRetries().withErrorDetails(new AsyncTriggerErrorDetails(e)).withNodeId(taskDefinition.getId()).withInstanceId(execution.getInstance().getIdentifier()).withDefinitionId(execution.getInstance().getDefinitionId()));
        return new FlowNodeExecutionResult((FlowNodeDefinition<?>)taskDefinition).failed(true);
    }

    protected boolean isExecutable(AbstractTaskDefinition taskDefinition) {
        return taskDefinition.getDelegateClass() != null || taskDefinition.getMethodCall() != null;
    }

    protected boolean goalIsFulfilled(GoalDefinition goal, ExecutionContext execution) {
        PredicateExpression goalPredicate = goal.getPredicate();
        return goalPredicate != null && this.expressionEvaluator.evaluate((Expression)goalPredicate, execution, Boolean.class) != false;
    }

    protected void scheduleAsyncTask(AbstractTaskDefinition taskDefinition, ExecutionContext execution) {
        this.asyncTriggerScheduler.schedule(new AsyncTrigger().withNodeId(taskDefinition.getId()).withInstanceId(execution.getInstance().getIdentifier()).withDefinitionId(execution.getInstance().getDefinitionId()));
    }
}

