/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.context;

import brainslug.flow.context.BrainslugContext;
import brainslug.flow.context.HashMapRegistry;
import brainslug.flow.context.Registry;
import brainslug.flow.definition.DefinitionStore;
import brainslug.flow.definition.HashMapDefinitionStore;
import brainslug.flow.execution.FlowExecutor;
import brainslug.flow.execution.async.ArrayListTriggerStore;
import brainslug.flow.execution.async.AsyncFlowStartScheduler;
import brainslug.flow.execution.async.AsyncTriggerExecutor;
import brainslug.flow.execution.async.AsyncTriggerScheduler;
import brainslug.flow.execution.async.AsyncTriggerSchedulerOptions;
import brainslug.flow.execution.async.AsyncTriggerStore;
import brainslug.flow.execution.async.ExecutorServiceAsyncTriggerScheduler;
import brainslug.flow.execution.async.ExecutorServiceFlowStartScheduler;
import brainslug.flow.execution.async.SchedulerOptions;
import brainslug.flow.execution.expression.DefaultExpressionEvaluator;
import brainslug.flow.execution.expression.ExpressionEvaluator;
import brainslug.flow.execution.instance.HashMapInstanceStore;
import brainslug.flow.execution.instance.InstanceStore;
import brainslug.flow.execution.node.task.CallDefinitionExecutor;
import brainslug.flow.execution.property.store.HashMapPropertyStore;
import brainslug.flow.execution.property.store.PropertyStore;
import brainslug.flow.execution.token.HashMapTokenStore;
import brainslug.flow.execution.token.TokenFlowExecutor;
import brainslug.flow.execution.token.TokenStore;
import brainslug.flow.listener.DefaultListenerManager;
import brainslug.flow.listener.ListenerManager;
import brainslug.util.IdGenerator;
import brainslug.util.UuidGenerator;

public abstract class AbstractBrainslugContextBuilder<SelfType extends AbstractBrainslugContextBuilder, T extends BrainslugContext> {
    protected AsyncTriggerExecutor asyncTriggerExecutor = new AsyncTriggerExecutor();
    protected AsyncTriggerSchedulerOptions asyncTriggerSchedulerOptions = new AsyncTriggerSchedulerOptions();
    protected AsyncFlowStartScheduler asyncFlowStartScheduler = new ExecutorServiceFlowStartScheduler();
    protected SchedulerOptions asyncFlowStartSchedulerOptions = new SchedulerOptions();
    protected DefinitionStore definitionStore = new HashMapDefinitionStore();
    protected ListenerManager listenerManager = new DefaultListenerManager();
    protected CallDefinitionExecutor callDefinitionExecutor = new CallDefinitionExecutor();
    protected ExpressionEvaluator expressionEvaluator = new DefaultExpressionEvaluator();
    protected Registry registry = new HashMapRegistry();
    protected IdGenerator idGenerator;
    protected FlowExecutor flowExecutor;
    protected TokenStore tokenStore;
    protected InstanceStore instanceStore;
    protected AsyncTriggerStore asyncTriggerStore;
    protected PropertyStore propertyStore;
    protected AsyncTriggerScheduler asyncTriggerScheduler;

    public T build() {
        if (this.idGenerator == null) {
            this.withIdGenerator(new UuidGenerator());
        }
        if (this.asyncTriggerStore == null) {
            this.withAsyncTriggerStore(new ArrayListTriggerStore());
        }
        if (this.propertyStore == null) {
            this.withPropertyStore(new HashMapPropertyStore());
        }
        if (this.tokenStore == null) {
            this.withTokenStore(new HashMapTokenStore(this.idGenerator));
        }
        if (this.instanceStore == null) {
            this.withInstanceStore(new HashMapInstanceStore(this.idGenerator, this.propertyStore, this.tokenStore));
        }
        if (this.asyncTriggerScheduler == null) {
            this.withAsyncTriggerScheduler(new ExecutorServiceAsyncTriggerScheduler().withAsyncTriggerExecutor(this.asyncTriggerExecutor));
        }
        if (this.flowExecutor == null) {
            this.withFlowExecutor(new TokenFlowExecutor(this.tokenStore, this.instanceStore, this.definitionStore, this.propertyStore, this.listenerManager, this.registry, this.expressionEvaluator, this.asyncTriggerStore, this.asyncTriggerScheduler, this.callDefinitionExecutor));
        }
        return this.internalBuild();
    }

    protected abstract T internalBuild();

    public SelfType self() {
        return (SelfType)this;
    }

    public SelfType withAsyncTriggerScheduler(AsyncTriggerScheduler asyncTriggerScheduler) {
        this.asyncTriggerScheduler = asyncTriggerScheduler;
        return this.self();
    }

    public SelfType withAsyncTriggerSchedulerOptions(AsyncTriggerSchedulerOptions asyncTriggerSchedulerOptions) {
        this.asyncTriggerSchedulerOptions = asyncTriggerSchedulerOptions;
        return this.self();
    }

    public SelfType withAsyncTriggerStore(AsyncTriggerStore asyncTriggerStore) {
        this.asyncTriggerStore = asyncTriggerStore;
        return this.self();
    }

    public SelfType withAsyncFlowStartScheduler(AsyncFlowStartScheduler asyncFlowStartScheduler) {
        this.asyncFlowStartScheduler = asyncFlowStartScheduler;
        return this.self();
    }

    public SelfType withAsyncFlowStartSchedulerOptions(SchedulerOptions asyncFlowStartSchedulerOptions) {
        this.asyncFlowStartSchedulerOptions = asyncFlowStartSchedulerOptions;
        return this.self();
    }

    public SelfType withPropertyStore(PropertyStore propertyStore) {
        this.propertyStore = propertyStore;
        return this.self();
    }

    public SelfType withDefinitionStore(DefinitionStore definitionStore) {
        this.definitionStore = definitionStore;
        return this.self();
    }

    public SelfType withTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
        return this.self();
    }

    public SelfType withFlowExecutor(FlowExecutor newFlowExecutor) {
        this.flowExecutor = newFlowExecutor;
        return this.self();
    }

    public SelfType withAsyncTriggerExecutor(AsyncTriggerExecutor asyncTriggerExecutor) {
        this.asyncTriggerExecutor = asyncTriggerExecutor;
        return this.self();
    }

    public SelfType withInstanceStore(InstanceStore instanceStore) {
        this.instanceStore = instanceStore;
        return this.self();
    }

    public SelfType withListenerManager(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
        return this.self();
    }

    public SelfType withRegistry(Registry registry) {
        this.registry = registry;
        return this.self();
    }

    public SelfType withPredicateEvaluator(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
        return this.self();
    }

    public SelfType withIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        return this.self();
    }

    public SelfType withCallDefinitionExecutor(CallDefinitionExecutor callDefinitionExecutor) {
        this.callDefinitionExecutor = callDefinitionExecutor;
        return this.self();
    }
}

