/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.token;

import brainslug.flow.Identifier;
import brainslug.flow.execution.token.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TokenList {
    List<Token> tokenList;

    public TokenList(List<Token> tokenList) {
        this.tokenList = tokenList;
    }

    public List<Token> getTokens() {
        return this.tokenList;
    }

    public Map<Identifier, List<Token>> groupedBySourceNode() {
        return this.sourceNodeMap(this.tokenList);
    }

    protected Map<Identifier, List<Token>> sourceNodeMap(List<Token> instanceTokens) {
        HashMap<Identifier, List<Token>> sourceNodeMap = new HashMap<Identifier, List<Token>>();
        for (Token token : instanceTokens) {
            if (!token.getSourceNode().isPresent()) continue;
            this.getOrCreateTokenList(sourceNodeMap, (Identifier)token.getSourceNode().get()).add(token);
        }
        return Collections.unmodifiableMap(sourceNodeMap);
    }

    protected List<Token> getOrCreateTokenList(Map<Identifier, List<Token>> sourceNodeMap, Identifier sourceNodeId) {
        if (sourceNodeMap.get(sourceNodeId) == null) {
            sourceNodeMap.put(sourceNodeId, new ArrayList());
        }
        return sourceNodeMap.get(sourceNodeId);
    }

    public Iterator<Token> getIterator() {
        return this.tokenList.iterator();
    }

    public void add(Token token) {
        this.tokenList.add(token);
    }
}

