/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.token;

import brainslug.flow.Identifier;
import brainslug.util.IdUtil;
import brainslug.util.Option;

public class Token {
    Identifier id;
    Identifier nodeId;
    Option<Identifier> sourceNode;
    Option<Identifier> instanceId;
    boolean isDead;

    public Token(String id, String nodeId, String sourceNodeId, String instanceId, int isDead) {
        this(IdUtil.id((String)id), IdUtil.id((String)nodeId), (Option<Identifier>)Option.of((Object)IdUtil.id((String)sourceNodeId)), (Option<Identifier>)Option.of((Object)IdUtil.id((String)instanceId)), isDead == 1);
    }

    public Token(Identifier id, Identifier nodeId, Option<Identifier> sourceNode, Option<Identifier> instanceId, boolean isDead) {
        this.id = id;
        this.nodeId = nodeId;
        this.sourceNode = sourceNode;
        this.instanceId = instanceId;
        this.isDead = isDead;
    }

    public Identifier getId() {
        return this.id;
    }

    public Identifier getNodeId() {
        return this.nodeId;
    }

    public Option<Identifier> getSourceNode() {
        return this.sourceNode;
    }

    public Option<Identifier> getInstanceId() {
        return this.instanceId;
    }

    public boolean isRootToken() {
        return !this.sourceNode.isPresent();
    }

    public boolean isDead() {
        return this.isDead;
    }

    public Token setDead(boolean isDead) {
        this.isDead = isDead;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        if (this.isDead != token.isDead) {
            return false;
        }
        if (this.id != null ? !this.id.equals(token.id) : token.id != null) {
            return false;
        }
        if (this.instanceId != null ? !this.instanceId.equals(token.instanceId) : token.instanceId != null) {
            return false;
        }
        if (this.nodeId != null ? !this.nodeId.equals(token.nodeId) : token.nodeId != null) {
            return false;
        }
        return !(this.sourceNode != null ? !this.sourceNode.equals(token.sourceNode) : token.sourceNode != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
        result = 31 * result + (this.sourceNode != null ? this.sourceNode.hashCode() : 0);
        result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        result = 31 * result + (this.isDead ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Token{id=" + this.id + ", nodeId=" + this.nodeId + ", sourceNode=" + this.sourceNode + ", instanceId=" + this.instanceId + ", isDead=" + this.isDead + '}';
    }
}

