/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.async;

import brainslug.flow.execution.async.AbstractAsyncTaskScheduler;
import brainslug.flow.execution.async.AsyncTaskExecutionResult;
import brainslug.flow.execution.async.AsyncTaskExecutor;
import brainslug.flow.execution.async.ExecuteTasksCallable;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceScheduler
extends AbstractAsyncTaskScheduler {
    private Logger log = LoggerFactory.getLogger(ExecutorServiceScheduler.class);
    ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    ExecutorService taskExecutorService = Executors.newCachedThreadPool();
    AsyncTaskExecutor asyncTaskExecutor = new AsyncTaskExecutor();

    @Override
    protected void internalStart() {
        this.log.info("starting async job scheduling with options: " + this.options);
        FutureTask<List<Future<AsyncTaskExecutionResult>>> executeTasks = new FutureTask<List<Future<AsyncTaskExecutionResult>>>(new ExecuteTasksCallable(this.context, this.options, this.taskExecutorService, this.asyncTaskExecutor));
        this.scheduledExecutorService.scheduleAtFixedRate(executeTasks, this.options.getScheduleDelay(), this.options.getSchedulePeriod(), this.options.getScheduleUnit());
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public ExecutorServiceScheduler withScheduledExecutorService(ScheduledExecutorService executorService) {
        this.scheduledExecutorService = executorService;
        return this;
    }

    public ExecutorService getTaskExecutorService() {
        return this.taskExecutorService;
    }

    public ExecutorServiceScheduler withTaskExecutorService(ExecutorService taskExecutor) {
        this.taskExecutorService = taskExecutor;
        return this;
    }

    public AsyncTaskExecutor getAsyncTaskExecutor() {
        return this.asyncTaskExecutor;
    }

    public ExecutorServiceScheduler withAsyncTaskExecutor(AsyncTaskExecutor asyncTaskExecutor) {
        this.asyncTaskExecutor = asyncTaskExecutor;
        return this;
    }
}

