/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution;

import java.util.Arrays;

public class ExecutionProperty {
    protected String key;
    protected String valueType;
    protected Object objectValue;
    protected String stringValue;
    protected Long longValue;
    protected Double doubleValue;
    protected byte[] byteArrayValue;

    public ExecutionProperty() {
    }

    public ExecutionProperty(String key, String valueType, String stringValue, Long longValue, Double doubleValue, byte[] byteArrayValue) {
        this.key = key;
        this.valueType = valueType;
        this.stringValue = stringValue;
        this.longValue = longValue;
        this.doubleValue = doubleValue;
        this.byteArrayValue = byteArrayValue;
    }

    public Object getObjectValue() {
        return this.objectValue;
    }

    public ExecutionProperty withObjectValue(Object propertyValue) {
        this.objectValue = propertyValue;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public ExecutionProperty withKey(String key) {
        this.key = key;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionProperty property = (ExecutionProperty)o;
        if (!Arrays.equals(this.byteArrayValue, property.byteArrayValue)) {
            return false;
        }
        if (this.doubleValue != null ? !this.doubleValue.equals(property.doubleValue) : property.doubleValue != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(property.key) : property.key != null) {
            return false;
        }
        if (this.longValue != null ? !this.longValue.equals(property.longValue) : property.longValue != null) {
            return false;
        }
        if (this.objectValue != null ? !this.objectValue.equals(property.objectValue) : property.objectValue != null) {
            return false;
        }
        if (this.stringValue != null ? !this.stringValue.equals(property.stringValue) : property.stringValue != null) {
            return false;
        }
        return !(this.valueType != null ? !this.valueType.equals(property.valueType) : property.valueType != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.valueType != null ? this.valueType.hashCode() : 0);
        result = 31 * result + (this.objectValue != null ? this.objectValue.hashCode() : 0);
        result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
        result = 31 * result + (this.longValue != null ? this.longValue.hashCode() : 0);
        result = 31 * result + (this.doubleValue != null ? this.doubleValue.hashCode() : 0);
        result = 31 * result + (this.byteArrayValue != null ? Arrays.hashCode(this.byteArrayValue) : 0);
        return result;
    }

    public String toString() {
        return "ExecutionProperty{key='" + this.key + '\'' + ", valueType='" + this.valueType + '\'' + ", objectValue=" + this.objectValue + ", stringValue='" + this.stringValue + '\'' + ", longValue=" + this.longValue + ", doubleValue=" + this.doubleValue + ", byteArrayValue=" + Arrays.toString(this.byteArrayValue) + '}';
    }

    public <T> T as(Class<T> clazz) {
        if (this.objectValue != null) {
            return (T)this.objectValue;
        }
        if (clazz.equals(String.class)) {
            return (T)this.stringValue;
        }
        if (clazz.equals(Long.class)) {
            return (T)this.longValue;
        }
        if (clazz.equals(Double.class)) {
            return (T)this.doubleValue;
        }
        if (clazz.equals(byte[].class)) {
            return (T)this.byteArrayValue;
        }
        return null;
    }
}

