/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution;

import brainslug.flow.execution.ExecutionProperty;
import brainslug.util.Option;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExecutionProperties {
    Map<String, ExecutionProperty> properties = new HashMap<String, ExecutionProperty>();

    public ExecutionProperties fromList(List<ExecutionProperty> properties) {
        for (ExecutionProperty property : properties) {
            this.properties.put(property.getKey(), property);
        }
        return this;
    }

    public ExecutionProperties put(String key, Object value) {
        this.properties.put(key, new ExecutionProperty().withKey(key).withObjectValue(value));
        return this;
    }

    public ExecutionProperties putAll(ExecutionProperties executionProperties) {
        this.properties.putAll(executionProperties.properties);
        return this;
    }

    public <T> T get(String key, Class<T> clazz) {
        return ((ExecutionProperty)Option.of((Object)this.properties.get(key)).get()).as(clazz);
    }

    public ExecutionProperty get(String key) {
        return (ExecutionProperty)Option.of((Object)this.properties.get(key)).get();
    }

    public <P> P getProperty(Class<P> type) {
        Object result = null;
        int typeCount = 0;
        for (ExecutionProperty object : this.getValues()) {
            if (object.getObjectValue() == null || !object.getObjectValue().getClass().isAssignableFrom(type)) continue;
            result = object.getObjectValue();
            ++typeCount;
        }
        if (typeCount == 0) {
            throw new IllegalArgumentException(String.format("no property of type %s exists", type));
        }
        if (typeCount > 1) {
            throw new IllegalArgumentException(String.format("multiple properties of type %s exist", type));
        }
        return (P)result;
    }

    public Collection<ExecutionProperty> getValues() {
        return this.properties.values();
    }

    public static ExecutionProperties with(String key, Object value) {
        return new ExecutionProperties().put(key, value);
    }

    public String toString() {
        return "ExecutionProperties{properties=" + this.properties + '}';
    }
}

