/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.context;

import brainslug.flow.FlowDefinition;
import brainslug.flow.Identifier;
import brainslug.flow.context.HashMapRegistry;
import brainslug.flow.context.Registry;
import brainslug.flow.execution.DefinitionStore;
import brainslug.flow.execution.ExecutionProperties;
import brainslug.flow.execution.FlowExecutor;
import brainslug.flow.execution.HashMapDefinitionStore;
import brainslug.flow.execution.HashMapPropertyStore;
import brainslug.flow.execution.PropertyStore;
import brainslug.flow.execution.TriggerContext;
import brainslug.flow.execution.async.ArrayListTaskStore;
import brainslug.flow.execution.async.AsyncTaskScheduler;
import brainslug.flow.execution.async.AsyncTaskSchedulerOptions;
import brainslug.flow.execution.async.AsyncTaskStore;
import brainslug.flow.execution.async.ExecutorServiceScheduler;
import brainslug.flow.execution.expression.DefaultPredicateEvaluator;
import brainslug.flow.execution.expression.PredicateEvaluator;
import brainslug.flow.execution.token.HashMapTokenStore;
import brainslug.flow.execution.token.TokenFlowExecutor;
import brainslug.flow.execution.token.TokenStore;
import brainslug.flow.listener.DefaultListenerManager;
import brainslug.flow.listener.ListenerManager;
import brainslug.util.IdGenerator;
import brainslug.util.Preconditions;
import brainslug.util.UuidGenerator;

public class BrainslugContext {
    AsyncTaskScheduler asyncTaskScheduler;
    AsyncTaskStore asyncTaskStore;
    AsyncTaskSchedulerOptions asyncTaskSchedulerOptions;
    DefinitionStore definitionStore;
    ListenerManager listenerManager;
    FlowExecutor flowExecutor;
    TokenStore tokenStore;
    PropertyStore propertyStore;
    PredicateEvaluator predicateEvaluator;
    IdGenerator idGenerator;
    Registry registry;

    public BrainslugContext() {
        this.initialize();
    }

    protected void initialize() {
        this.withIdGenerator(new UuidGenerator()).withTokenStore(new HashMapTokenStore(this.idGenerator));
        this.withPropertyStore(new HashMapPropertyStore());
        this.withDefinitionStore(new HashMapDefinitionStore());
        this.withAsyncTaskStore(new ArrayListTaskStore()).withAsyncTaskScheduler(new ExecutorServiceScheduler());
        this.withListenerManager(new DefaultListenerManager());
        this.withExecutor(new TokenFlowExecutor(this));
        this.withRegistry(new HashMapRegistry());
        this.withPredicateEvaluator(new DefaultPredicateEvaluator());
    }

    public BrainslugContext withAsyncTaskScheduler(AsyncTaskScheduler asyncTaskScheduler) {
        this.asyncTaskScheduler = asyncTaskScheduler;
        asyncTaskScheduler.setContext(this);
        return this;
    }

    public BrainslugContext withAsyncTaskStore(AsyncTaskStore asyncTaskStore) {
        this.asyncTaskStore = asyncTaskStore;
        return this;
    }

    public BrainslugContext withPropertyStore(PropertyStore propertyStore) {
        this.propertyStore = propertyStore;
        return this;
    }

    public BrainslugContext withDefinitionStore(DefinitionStore definitionStore) {
        this.definitionStore = definitionStore;
        return this;
    }

    public BrainslugContext withTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
        return this;
    }

    public BrainslugContext withExecutor(FlowExecutor newFlowExecutor) {
        this.setupFlowExecutor(newFlowExecutor);
        return this;
    }

    private void setupFlowExecutor(FlowExecutor newFlowExecutor) {
        this.flowExecutor = newFlowExecutor;
    }

    public BrainslugContext withListenerManager(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
        return this;
    }

    public BrainslugContext withRegistry(Registry registry) {
        this.registry = registry;
        return this;
    }

    public BrainslugContext withPredicateEvaluator(PredicateEvaluator predicateEvaluator) {
        this.predicateEvaluator = predicateEvaluator;
        return this;
    }

    public BrainslugContext withIdGenerator(UuidGenerator uuidGenerator) {
        this.idGenerator = uuidGenerator;
        return this;
    }

    public BrainslugContext addFlowDefinition(FlowDefinition flowDefinition) {
        this.definitionStore.addDefinition(flowDefinition);
        return this;
    }

    public DefinitionStore getDefinitionStore() {
        return this.definitionStore;
    }

    public void trigger(TriggerContext context) {
        this.flowExecutor.trigger(context);
    }

    public Identifier startFlow(Identifier definitionId, Identifier startNodeId) {
        return this.flowExecutor.startFlow((TriggerContext<?>)((TriggerContext)new TriggerContext().definitionId(definitionId)).nodeId(startNodeId));
    }

    public Identifier startFlow(Identifier definitionId, Identifier startNodeId, ExecutionProperties properties) {
        Object triggerContext = ((TriggerContext)((TriggerContext)new TriggerContext().definitionId(definitionId)).nodeId(startNodeId)).properties(properties);
        return this.flowExecutor.startFlow((TriggerContext<?>)triggerContext);
    }

    public BrainslugContext start() {
        ((AsyncTaskScheduler)Preconditions.notNull((Object)this.asyncTaskScheduler)).start(this.asyncTaskSchedulerOptions);
        return this;
    }

    public BrainslugContext stop() {
        ((AsyncTaskScheduler)Preconditions.notNull((Object)this.asyncTaskScheduler)).stop();
        return this;
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public PredicateEvaluator getPredicateEvaluator() {
        return this.predicateEvaluator;
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public PropertyStore getPropertyStore() {
        return this.propertyStore;
    }

    public AsyncTaskScheduler getAsyncTaskScheduler() {
        return this.asyncTaskScheduler;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public AsyncTaskStore getAsyncTaskStore() {
        return this.asyncTaskStore;
    }
}

