/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.impl;

import brainslug.flow.execution.Token;
import brainslug.flow.execution.TokenStore;
import brainslug.flow.model.Identifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HashMapTokenStore
implements TokenStore {
    Map<Identifier, TokenMap> instanceTokenMaps = Collections.synchronizedMap(new HashMap());

    @Override
    public Map<Identifier, List<Token>> getTokens(Identifier nodeId, Identifier instanceId) {
        List<Token> instanceTokens = this.requireTokenMap(instanceId).get(nodeId);
        return instanceTokens == null ? Collections.emptyMap() : this.sourceNodeMap(instanceTokens);
    }

    private Map<Identifier, List<Token>> sourceNodeMap(List<Token> instanceTokens) {
        HashMap sourceNodeMap = new HashMap();
        for (Token token : instanceTokens) {
            if (sourceNodeMap.get(token.getSourceNode()) == null) {
                sourceNodeMap.put(token.getSourceNode(), new ArrayList());
            }
            ((List)sourceNodeMap.get(token.getSourceNode())).add(token);
        }
        return Collections.unmodifiableMap(sourceNodeMap);
    }

    @Override
    public void addToken(Identifier instanceId, Identifier nodeId, Token token) {
        this.requireTokenMap(instanceId).get(nodeId).add(token);
    }

    @Override
    public void removeToken(Identifier instanceId, Identifier nodeId, Token token) {
        Map<Identifier, List<Token>> sourceNodeMap = this.sourceNodeMap(this.requireTokenMap(instanceId).get(nodeId));
        List<Token> nodeTokens = sourceNodeMap.get(token.getSourceNode());
        if (nodeTokens != null && nodeTokens.size() > 0) {
            Token firstTokenFromSource = sourceNodeMap.get(token.getSourceNode()).get(0);
            this.requireTokenMap(instanceId).get(nodeId).remove(firstTokenFromSource);
        }
    }

    @Override
    public void createInstance(Identifier instanceId) {
        if (this.instanceTokenMaps.get(instanceId) == null) {
            this.instanceTokenMaps.put(instanceId, new TokenMap());
        }
    }

    private TokenMap requireTokenMap(Identifier instanceId) {
        if (this.instanceTokenMaps.get(instanceId) == null) {
            throw new IllegalArgumentException("instanceId " + instanceId + " does not exist");
        }
        return this.instanceTokenMaps.get(instanceId);
    }

    public class TokenMap {
        Map<Identifier, List<Token>> nodeTokens = Collections.synchronizedMap(new HashMap());

        public List<Token> get(Identifier nodeId) {
            return Collections.synchronizedList(this.getOrCreateTokenList(nodeId));
        }

        public void put(Identifier nodeId, Token token) {
            this.getOrCreateTokenList(nodeId).add(token);
        }

        private List<Token> getOrCreateTokenList(Identifier nodeId) {
            if (this.nodeTokens.get(nodeId) == null) {
                this.nodeTokens.put(nodeId, Collections.synchronizedList(new ArrayList()));
            }
            return this.nodeTokens.get(nodeId);
        }
    }
}

