/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.impl;

import brainslug.flow.execution.ExecutionContext;
import brainslug.flow.execution.FlowNodeExectuor;
import brainslug.flow.execution.Token;
import brainslug.flow.execution.TokenStore;
import brainslug.flow.execution.TokenStoreAware;
import brainslug.flow.model.FlowEdgeDefinition;
import brainslug.flow.model.FlowNodeDefinition;
import java.util.ArrayList;
import java.util.List;

public class DefaultNodeExecutor<T extends FlowNodeDefinition>
implements FlowNodeExectuor<T>,
TokenStoreAware {
    protected TokenStore tokenStore;

    @Override
    public List<FlowNodeDefinition> execute(T node, ExecutionContext execution) {
        this.removeTriggerToken(execution);
        return this.takeAll((FlowNodeDefinition<?>)node);
    }

    protected void removeTriggerToken(ExecutionContext execution) {
        if (execution.getTrigger().getInstanceId() != null) {
            this.tokenStore.removeToken(execution.getTrigger().getInstanceId(), execution.getTrigger().getNodeId(), new Token(execution.getTrigger().getSourceNodeId()));
        }
    }

    protected void removeTokens(ExecutionContext execution, List<Token> tokens) {
        for (Token token : tokens) {
            this.tokenStore.removeToken(execution.getTrigger().getInstanceId(), execution.getTrigger().getNodeId(), token);
        }
    }

    protected List<FlowNodeDefinition> takeAll(FlowNodeDefinition<?> node) {
        ArrayList<FlowNodeDefinition> next = new ArrayList<FlowNodeDefinition>();
        for (FlowEdgeDefinition edge : node.getOutgoing()) {
            next.add(edge.getTarget());
        }
        return next;
    }

    protected List<FlowNodeDefinition> takeNone() {
        return new ArrayList<FlowNodeDefinition>();
    }

    @Override
    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }
}

