/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution;

import brainslug.flow.execution.ExecutionProperties;
import brainslug.flow.model.EnumIdentifier;
import brainslug.flow.model.Identifier;
import brainslug.flow.model.StringIdentifier;

public class TriggerContext<T extends TriggerContext> {
    protected Identifier id;
    protected Identifier definitionId;
    protected Identifier instanceId;
    protected Identifier nodeId;
    protected Identifier<?> sourceNodeId;
    protected ExecutionProperties properties;

    public Identifier getSourceNodeId() {
        return this.sourceNodeId;
    }

    public Identifier getId() {
        return this.id;
    }

    public Identifier getDefinitionId() {
        return this.definitionId;
    }

    public Identifier getInstanceId() {
        return this.instanceId;
    }

    public Identifier getNodeId() {
        return this.nodeId;
    }

    T self() {
        return (T)this;
    }

    public T id(Identifier id) {
        this.id = id;
        return this.self();
    }

    public T definitionId(Enum id) {
        return this.definitionId((Identifier)new EnumIdentifier(id));
    }

    public T definitionId(String id) {
        return this.definitionId((Identifier)new StringIdentifier(id));
    }

    public T definitionId(Identifier definitionId) {
        this.definitionId = definitionId;
        return this.self();
    }

    public T instanceId(Identifier definitionId) {
        this.instanceId = definitionId;
        return this.self();
    }

    public T nodeId(Identifier nodeId) {
        this.nodeId = nodeId;
        return this.self();
    }

    public T sourceNodeId(Identifier sourceNodeId) {
        this.sourceNodeId = sourceNodeId;
        return this.self();
    }

    public T properties(ExecutionProperties properties) {
        this.properties = properties;
        return this.self();
    }

    public T property(Object value) {
        this.setProperty(value.getClass().getName(), value);
        return this.self();
    }

    public T property(Object key, Object value) {
        this.setProperty(key, value);
        return this.self();
    }

    public void setProperty(Object key, Object value) {
        this.getProperties().put(key, value);
    }

    public <P> P getProperty(Object key, Class<P> type) {
        return (P)this.getProperties().get(key);
    }

    public <P> P getProperty(Class<P> type) {
        Object result = null;
        int typeCount = 0;
        for (Object object : this.getProperties().values()) {
            if (!object.getClass().isAssignableFrom(type)) continue;
            result = object;
            ++typeCount;
        }
        if (typeCount == 0) {
            throw new IllegalArgumentException(String.format("no property of type %s exists", type));
        }
        if (typeCount > 1) {
            throw new IllegalArgumentException(String.format("multiple properties of type %s exist", type));
        }
        return (P)result;
    }

    public ExecutionProperties getProperties() {
        if (this.properties == null) {
            this.properties = new ExecutionProperties();
        }
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerContext triggerContext = (TriggerContext)o;
        if (this.definitionId != null ? !this.definitionId.equals(triggerContext.definitionId) : triggerContext.definitionId != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(triggerContext.id) : triggerContext.id != null) {
            return false;
        }
        if (this.instanceId != null ? !this.instanceId.equals(triggerContext.instanceId) : triggerContext.instanceId != null) {
            return false;
        }
        if (this.nodeId != null ? !this.nodeId.equals(triggerContext.nodeId) : triggerContext.nodeId != null) {
            return false;
        }
        return !(this.sourceNodeId != null ? !this.sourceNodeId.equals(triggerContext.sourceNodeId) : triggerContext.sourceNodeId != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.definitionId != null ? this.definitionId.hashCode() : 0);
        result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
        result = 31 * result + (this.sourceNodeId != null ? this.sourceNodeId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TriggerContext{id=" + this.id + ", definitionId=" + this.definitionId + ", instanceId=" + this.instanceId + ", nodeId=" + this.nodeId + ", sourceNodeId=" + this.sourceNodeId + ", properties=" + this.properties + '}';
    }
}

