/*
 * Decompiled with CFR 0.152.
 */
package brainslug;

import brainslug.flow.builder.FlowBuilder;
import brainslug.flow.builder.FlowBuilderSupport;
import brainslug.flow.context.BrainslugContextBuilder;
import brainslug.flow.context.DefaultBrainslugContext;
import brainslug.flow.context.ExecutionContext;
import brainslug.flow.definition.Identifier;
import brainslug.flow.execution.node.task.SimpleTask;
import brainslug.flow.node.task.AbstractTaskDefinition;
import brainslug.flow.node.task.Task;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class BenchmarkExample {
    public static void main(String[] args) {
        final DefaultBrainslugContext brainslugContext = (DefaultBrainslugContext)new BrainslugContextBuilder().build();
        final Identifier testFlow = FlowBuilderSupport.id((String)"testFlow");
        brainslugContext.addFlowDefinition(new FlowBuilder(){

            public void define() {
                this.flowId(testFlow);
                this.start((AbstractTaskDefinition)1.task((Identifier)1.id((String)"task"), (Task)new SimpleTask(){

                    public void execute(ExecutionContext context) {
                        System.out.println(context.getInstance().getIdentifier());
                    }
                }));
            }
        }.getDefinition());
        ExecutorService executor = Executors.newFixedThreadPool(10);
        long startTime = System.currentTimeMillis();
        for (int count = 0; count < 10000; ++count) {
            executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return brainslugContext.startFlow(testFlow);
                }
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(100L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Execution time: " + (endTime - startTime));
    }
}

