/*
 * Decompiled with CFR 0.152.
 */
package de.andreasgerhard.mapstruct;

import de.andreasgerhard.mapstruct.IsSetterWithoutPrefix;
import java.beans.Introspector;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.mapstruct.ap.spi.DefaultAccessorNamingStrategy;

public class BuilderAccessorNamingStrategy
extends DefaultAccessorNamingStrategy {
    private static final List<String> SETTERS = Arrays.asList("set", "is", "with");
    private static final List<String> GETTERS = Arrays.asList("get");
    private static final List<String> STOPLIST = Arrays.asList("hashCode", "toString", "equals");
    private static final Pattern PATTERN_PREFIX = Pattern.compile("^(?<prefix>[a-z]+)\\w+");

    private String getPrefix(String name) {
        String result = null;
        Matcher matcher = PATTERN_PREFIX.matcher(name);
        if (matcher.matches()) {
            result = matcher.group("prefix");
        }
        return result == null ? "" : result;
    }

    private boolean classIsEnlistedAsBuilder(ExecutableElement method) {
        Element enclosingElement = method.getEnclosingElement();
        IsSetterWithoutPrefix annotation = enclosingElement.getAnnotation(IsSetterWithoutPrefix.class);
        boolean builder = enclosingElement.getSimpleName().toString().endsWith("Builder");
        return builder || annotation != null;
    }

    public boolean isGetterMethod(ExecutableElement method) {
        boolean result = false;
        String methodName = method.getSimpleName().toString();
        String prefix = this.getPrefix(methodName);
        if (GETTERS.contains(prefix) && method.getReturnType().getKind() != TypeKind.VOID) {
            result = true;
        }
        return result;
    }

    public boolean isSetterMethod(ExecutableElement method) {
        boolean result = false;
        String methodName = method.getSimpleName().toString();
        String prefix = this.getPrefix(methodName);
        TypeKind kind = method.getReturnType().getKind();
        if (this.classIsEnlistedAsBuilder(method) && !STOPLIST.contains(methodName) && kind == TypeKind.DECLARED && method.getReturnType().toString().equals(method.getEnclosingElement().toString()) && method.getParameters().size() == 1) {
            result = true;
        } else if (SETTERS.contains(prefix) && kind == TypeKind.VOID && method.getParameters().size() == 1) {
            result = true;
        }
        return result;
    }

    public String getPropertyName(ExecutableElement getterOrSetterMethod) {
        String methodName = getterOrSetterMethod.getSimpleName().toString();
        String prefix = this.getPrefix(methodName);
        boolean builder = this.classIsEnlistedAsBuilder(getterOrSetterMethod);
        if (this.isGetterMethod(getterOrSetterMethod) || this.isSetterMethod(getterOrSetterMethod)) {
            return Introspector.decapitalize(builder ? methodName : methodName.substring(prefix.length()));
        }
        return null;
    }
}

