/*
 * Decompiled with CFR 0.152.
 */
package de.ameto.client;

import de.ameto.client.AmetoApi;
import de.ameto.client.AmetoException;
import de.ameto.client.AssetMetadata;
import de.ameto.client.ProcessedAsset;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import retrofit2.Response;

public class Asset {
    private final String id;
    private final AmetoApi api;
    private Set<ProcessedAsset> variants;

    public Set<ProcessedAsset> getVariants() {
        if (this.variants == null) {
            Response metadata;
            try {
                metadata = this.api.getAsset(this.id).execute();
            }
            catch (IOException e) {
                throw new AmetoException("Unable to retrieve metadata for asset " + this.id, e);
            }
            this.variants = ((AssetMetadata)Optional.ofNullable(metadata.body()).orElseThrow(() -> new AmetoException("Received empty response when fetching metadata for asset " + this.id))).getVariants().stream().map(processedAssetId -> new ProcessedAsset((String)processedAssetId, this.api)).collect(Collectors.toSet());
        }
        return this.variants;
    }

    @ConstructorProperties(value={"id", "api"})
    public Asset(String id, AmetoApi api) {
        this.id = id;
        this.api = api;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Asset)) {
            return false;
        }
        Asset other = (Asset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Asset;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String getId() {
        return this.id;
    }
}

