/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resourcebundle.locale;

import de.alpharogroup.file.FilenameExtensions;
import de.alpharogroup.resourcebundle.file.namefilter.PropertiesResourceBundleFilenameFilter;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class LocaleResolver {
    public static boolean isISOCountryCode(String code) {
        if (code.length() == 2) {
            code = code.toUpperCase();
            List<String> lc = Arrays.asList(Locale.getISOCountries());
            return lc.contains(code);
        }
        return false;
    }

    public static Set<String> resolveAvailableLanguages(String bundlepackage, String bundlename) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        File root = new File(loader.getResource(bundlepackage.replace('.', '/')).getFile());
        File[] files = root.listFiles(new PropertiesResourceBundleFilenameFilter(bundlename));
        TreeSet<String> languages = new TreeSet<String>();
        for (File file : files) {
            String language = file.getName().replaceAll("^" + bundlename + "(_)?|\\.properties$", "");
            if (language != null && !language.isEmpty()) {
                languages.add(language);
                continue;
            }
            languages.add("default");
        }
        return languages;
    }

    public static String resolveBundlename(File propertiesFile) {
        String filename = propertiesFile.getName();
        int indexOfUnderscore = filename.indexOf("_");
        String bundlename = filename;
        if (0 < indexOfUnderscore) {
            bundlename = propertiesFile.getName().substring(0, filename.indexOf("_"));
        }
        return bundlename;
    }

    public static Locale resolveLocale(File propertiesFile) {
        String localeCode = propertiesFile.getName().replaceAll("^" + LocaleResolver.resolveBundlename(propertiesFile) + "(_)?|\\.properties$", "");
        return LocaleResolver.resolveLocale(localeCode);
    }

    public static Locale resolveLocale(String localeCode) {
        Locale current = LocaleResolver.resolveLocaleCode(localeCode);
        if (current == null) {
            current = Locale.getDefault();
        }
        return current;
    }

    public static String resolveLocaleCode(File propertiesFile) {
        String filename = FilenameExtensions.getFilenameWithoutExtension((File)propertiesFile);
        int underscoreIndex = filename.indexOf("_");
        String stringCode = "default";
        if (0 < underscoreIndex) {
            stringCode = filename.substring(underscoreIndex + 1, filename.length());
        }
        return stringCode;
    }

    public static Locale resolveLocaleCode(String code) {
        if (code == null || code.isEmpty()) {
            return null;
        }
        String[] splitted = code.split("_");
        if (splitted.length == 1) {
            return new Locale(code);
        }
        if (splitted.length == 2) {
            return new Locale(splitted[0], splitted[1]);
        }
        if (splitted.length == 3) {
            return new Locale(splitted[0], splitted[1], splitted[2]);
        }
        return null;
    }

    public static Map<File, Locale> resolveLocales(String bundlepackage, String bundlename) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        File root = new File(loader.getResource(bundlepackage.replace('.', '/')).getFile());
        File[] files = root.listFiles(new PropertiesResourceBundleFilenameFilter(bundlename));
        HashMap<File, Locale> locales = new HashMap<File, Locale>();
        for (File file : files) {
            Locale current = LocaleResolver.resolveLocale(file);
            locales.put(file, current);
        }
        return locales;
    }

    private LocaleResolver() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

