/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resourcebundle.inspector.validator;

import de.alpharogroup.file.exceptions.FileIsADirectoryException;
import de.alpharogroup.resourcebundle.inspector.search.PropertiesDirectoryWalker;
import de.alpharogroup.resourcebundle.properties.PropertiesFileExtensions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class PropertiesNormalizer {
    public static Map<Character, String> INVALID_CHARACTERS = new HashMap<Character, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Character.valueOf('\u00e4'), "\\u00E4");
            this.put(Character.valueOf('\u00c4'), "\\u00C4");
            this.put(Character.valueOf('\u00f6'), "\\u00F6");
            this.put(Character.valueOf('\u00d6'), "\\u00D6");
            this.put(Character.valueOf('\u00fc'), "\\u00FC");
            this.put(Character.valueOf('\u00dc'), "\\u00DC");
            this.put(Character.valueOf('\u00df'), "\\u00DF");
            this.put(Character.valueOf('@'), "\\u0040");
            this.put(Character.valueOf('\u0391'), "\\u0391");
            this.put(Character.valueOf('\u0386'), "\\u0386");
            this.put(Character.valueOf('\u0392'), "\\u0392");
            this.put(Character.valueOf('\u0393'), "\\u0393");
            this.put(Character.valueOf('\u0394'), "\\u0394");
            this.put(Character.valueOf('\u0395'), "\\u0395");
            this.put(Character.valueOf('\u0388'), "\\u0388");
            this.put(Character.valueOf('\u0396'), "\\u0396");
            this.put(Character.valueOf('\u0397'), "\\u0397");
            this.put(Character.valueOf('\u0389'), "\\u0389");
            this.put(Character.valueOf('\u0398'), "\\u0398");
            this.put(Character.valueOf('\u0399'), "\\u0399");
            this.put(Character.valueOf('\u038a'), "\\u038a");
            this.put(Character.valueOf('\u03aa'), "\\u03aa");
            this.put(Character.valueOf('\u039a'), "\\u039a");
            this.put(Character.valueOf('\u039b'), "\\u039b");
            this.put(Character.valueOf('\u039c'), "\\u039c");
            this.put(Character.valueOf('\u039d'), "\\u039d");
            this.put(Character.valueOf('\u039e'), "\\u039e");
            this.put(Character.valueOf('\u039f'), "\\u039f");
            this.put(Character.valueOf('\u038c'), "\\u038c");
            this.put(Character.valueOf('\u03a0'), "\\u03a0");
            this.put(Character.valueOf('\u03a1'), "\\u03a1");
            this.put(Character.valueOf('\u03a3'), "\\u03a3");
            this.put(Character.valueOf('\u03a4'), "\\u03a4");
            this.put(Character.valueOf('\u03a5'), "\\u03a5");
            this.put(Character.valueOf('\u038e'), "\\u038e");
            this.put(Character.valueOf('\u03ab'), "\\u03ab");
            this.put(Character.valueOf('\u03a6'), "\\u03a6");
            this.put(Character.valueOf('\u03a7'), "\\u03a7");
            this.put(Character.valueOf('\u03a8'), "\\u03a8");
            this.put(Character.valueOf('\u03a9'), "\\u03a9");
            this.put(Character.valueOf('\u038f'), "\\u038f");
            this.put(Character.valueOf('\u03b1'), "\\u03b1");
            this.put(Character.valueOf('\u03ac'), "\\u03ac");
            this.put(Character.valueOf('\u03b2'), "\\u03b2");
            this.put(Character.valueOf('\u03b3'), "\\u03b3");
            this.put(Character.valueOf('\u03b4'), "\\u03b4");
            this.put(Character.valueOf('\u03b5'), "\\u03b5");
            this.put(Character.valueOf('\u03ad'), "\\u03ad");
            this.put(Character.valueOf('\u03b6'), "\\u03b6");
            this.put(Character.valueOf('\u03b7'), "\\u03b7");
            this.put(Character.valueOf('\u03ae'), "\\u03ae");
            this.put(Character.valueOf('\u03b8'), "\\u03b8");
            this.put(Character.valueOf('\u03b9'), "\\u03b9");
            this.put(Character.valueOf('\u03af'), "\\u03af");
            this.put(Character.valueOf('\u03ca'), "\\u03ca");
            this.put(Character.valueOf('\u0390'), "\\u0390");
            this.put(Character.valueOf('\u03ba'), "\\u03ba");
            this.put(Character.valueOf('\u03bb'), "\\u03bb");
            this.put(Character.valueOf('\u03bc'), "\\u03bc");
            this.put(Character.valueOf('\u03bd'), "\\u03bd");
            this.put(Character.valueOf('\u03be'), "\\u03be");
            this.put(Character.valueOf('\u03bf'), "\\u03bf");
            this.put(Character.valueOf('\u03cc'), "\\u03cc");
            this.put(Character.valueOf('\u03c0'), "\\u03c0");
            this.put(Character.valueOf('\u03c1'), "\\u03c1");
            this.put(Character.valueOf('\u03c3'), "\\u03c3");
            this.put(Character.valueOf('\u03c2'), "\\u03c2");
            this.put(Character.valueOf('\u03c4'), "\\u03c4");
            this.put(Character.valueOf('\u03c5'), "\\u03c5");
            this.put(Character.valueOf('\u03cd'), "\\u03cd");
            this.put(Character.valueOf('\u03cb'), "\\u03cb");
            this.put(Character.valueOf('\u03b0'), "\\u03b0");
            this.put(Character.valueOf('\u03c6'), "\\u03c6");
            this.put(Character.valueOf('\u03c7'), "\\u03c7");
            this.put(Character.valueOf('\u03c8'), "\\u03c8");
            this.put(Character.valueOf('\u03c9'), "\\u03c9");
            this.put(Character.valueOf('\u03ce'), "\\u03ce");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean containsInvalidCharacters(File input) throws IOException {
        boolean bl;
        BufferedReader bufferIn = null;
        try {
            int r;
            FileInputStream in = new FileInputStream(input);
            bufferIn = new BufferedReader(new InputStreamReader(in));
            while ((r = ((Reader)bufferIn).read()) != -1) {
                char ch = (char)r;
                String invalidCharacter = PropertiesNormalizer.getUtf8Character(ch);
                if (invalidCharacter == null) break block4;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferIn);
            throw throwable;
        }
        {
            block4: {
                IOUtils.closeQuietly((Reader)bufferIn);
                return bl;
            }
            continue;
        }
        IOUtils.closeQuietly((Reader)bufferIn);
        return false;
    }

    public static Collection<File> findPropertiesFilesWithInvalidCharacters(File rootDir) throws IOException {
        final ArrayList<File> found = new ArrayList<File>();
        PropertiesDirectoryWalker walker = new PropertiesDirectoryWalker(){

            protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
                if (PropertiesNormalizer.containsInvalidCharacters(file)) {
                    found.add(file);
                }
            }
        };
        walker.start(rootDir);
        return found;
    }

    private static String getUtf8Character(char c) {
        if (INVALID_CHARACTERS.containsKey(Character.valueOf(c))) {
            return INVALID_CHARACTERS.get(Character.valueOf(c));
        }
        return null;
    }

    public static void normalizeProperties(String path) throws IOException, FileIsADirectoryException {
        File originalFile = new File(path);
        File backupFile = PropertiesFileExtensions.newBackupOf(originalFile);
        PropertiesNormalizer.replaceCharacters(backupFile, originalFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceCharacters(File input, File output) throws IOException {
        BufferedReader bufferIn = null;
        BufferedWriter bufferOut = null;
        try {
            int r;
            FileInputStream in = new FileInputStream(input);
            bufferIn = new BufferedReader(new InputStreamReader(in));
            FileOutputStream out = new FileOutputStream(output);
            bufferOut = new BufferedWriter(new OutputStreamWriter(out));
            while ((r = ((Reader)bufferIn).read()) != -1) {
                char ch = (char)r;
                String invalidCharacters = PropertiesNormalizer.getUtf8Character(ch);
                if (invalidCharacters != null) {
                    bufferOut.write(invalidCharacters.toCharArray());
                    continue;
                }
                ((Writer)bufferOut).write(ch);
            }
            ((Writer)bufferOut).flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferIn);
            IOUtils.closeQuietly(bufferOut);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)bufferIn);
        IOUtils.closeQuietly((Writer)bufferOut);
    }
}

