/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.obfuscation.rule;

public enum Operation {
    LOWERCASE,
    NEGATECASE,
    TITLECASE,
    UPPERCASE;


    public static Character operate(char character, Operation operation) {
        return Operation.operate(character, operation, false);
    }

    public static Character operate(char character, Operation operation, boolean reverse) {
        if (operation != null) {
            switch (operation) {
                case LOWERCASE: {
                    if (reverse) {
                        return Character.valueOf(Character.toUpperCase(character));
                    }
                    return Character.valueOf(Character.toLowerCase(character));
                }
                case UPPERCASE: {
                    if (reverse) {
                        return Character.valueOf(Character.toLowerCase(character));
                    }
                    return Character.valueOf(Character.toUpperCase(character));
                }
                case NEGATECASE: {
                    if (reverse) {
                        return Character.valueOf(character);
                    }
                    if (Character.isUpperCase(character)) {
                        return Character.valueOf(Character.toLowerCase(character));
                    }
                    return Character.valueOf(Character.toUpperCase(character));
                }
                case TITLECASE: {
                    if (reverse) {
                        if (Character.isUpperCase(character)) {
                            return Character.valueOf(Character.toLowerCase(character));
                        }
                        return Character.valueOf(Character.toUpperCase(character));
                    }
                    return Character.valueOf(Character.toTitleCase(character));
                }
            }
        }
        return Character.valueOf(character);
    }
}

