/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.slider;

import de.agilecoders.wicket.extensions.slider.BootstrapSlider;
import de.agilecoders.wicket.extensions.slider.ISliderValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;

public class AjaxBootstrapSlider<T extends ISliderValue, N extends Number>
extends BootstrapSlider<T, N> {
    private AbstractDefaultAjaxBehavior behavior;
    private final Map<SliderEvent, EventHandler> handlers = new HashMap<SliderEvent, EventHandler>();

    public AjaxBootstrapSlider(String id, IModel<T> model, Class<T> typeClass) {
        super(id, model, typeClass);
        this.behavior = new AbstractDefaultAjaxBehavior(){

            protected void respond(AjaxRequestTarget target) {
                String _event = RequestCycle.get().getRequest().getRequestParameters().getParameterValue("event").toString();
                SliderEvent event = SliderEvent.valueOf(_event);
                EventHandler handler = (EventHandler)AjaxBootstrapSlider.this.handlers.get((Object)event);
                String _value = RequestCycle.get().getRequest().getRequestParameters().getParameterValue("value").toString();
                ISliderValue value = AjaxBootstrapSlider.this.newInstance().fromString(_value);
                AjaxBootstrapSlider.this.getModel().setObject((Object)value);
                if (handler != null) {
                    handler.onAjaxEvent(target, value);
                }
            }
        };
        this.add(new Behavior[]{this.behavior});
    }

    public AjaxBootstrapSlider addHandler(SliderEvent event, EventHandler<T> handler) {
        this.handlers.put(event, handler);
        return this;
    }

    @Override
    protected void configEvents(StringBuilder builder) {
        CharSequence url = this.behavior.getCallbackUrl();
        for (SliderEvent event : this.handlers.keySet()) {
            builder.append(".on('").append(event.name()).append("',").append("function(value) {\n");
            builder.append("var ep={};\n").append("ep['event']='").append(event.name()).append("';\n");
            builder.append("ep['value']=value['value'];\n");
            builder.append("Wicket.Ajax.get({'u': '").append(url).append("', 'ep': ep").append("});");
            builder.append("\n})");
        }
    }

    public static interface EventHandler<T extends ISliderValue>
    extends Serializable {
        public void onAjaxEvent(AjaxRequestTarget var1, T var2);
    }

    public static enum SliderEvent {
        slide,
        slideStart,
        slideStop,
        change;

    }
}

