/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.template.provided;

import de.adorsys.keymanagement.api.types.entity.KeyPairEntry;
import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import de.adorsys.keymanagement.api.types.template.DefaultNamingStrategy;
import de.adorsys.keymanagement.api.types.template.GeneratedKeyTemplate;
import de.adorsys.keymanagement.api.types.template.KeyTemplate;
import de.adorsys.keymanagement.api.types.template.NameAndPassword;
import de.adorsys.keymanagement.api.types.template.ProvidedKeyTemplate;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import lombok.NonNull;

public class ProvidedKeyPair
implements ProvidedKeyTemplate {
    @NonNull
    private final KeyTemplate keyTemplate;
    @NonNull
    private final KeyPair pair;
    private final KeyMetadata metadata;
    @NonNull
    private final List<Certificate> certificates;

    ProvidedKeyPair(@NonNull KeyTemplate keyTemplate, @NonNull KeyPair pair, @NonNull List<Certificate> certificates, KeyMetadata metadata) {
        if (keyTemplate == null) {
            throw new NullPointerException("keyTemplate is marked non-null but is null");
        }
        if (pair == null) {
            throw new NullPointerException("pair is marked non-null but is null");
        }
        if (certificates == null) {
            throw new NullPointerException("certificates is marked non-null but is null");
        }
        this.keyTemplate = keyTemplate;
        this.metadata = metadata;
        this.certificates = certificates;
        this.pair = pair;
    }

    ProvidedKeyPair(String alias, String prefix, Supplier<char[]> password, @NonNull KeyPair pair, @NonNull List<Certificate> certificates, KeyMetadata metadata) {
        if (pair == null) {
            throw new NullPointerException("pair is marked non-null but is null");
        }
        if (certificates == null) {
            throw new NullPointerException("certificates is marked non-null but is null");
        }
        this.keyTemplate = new NameAndPassword(new DefaultNamingStrategy(alias, prefix), password);
        this.metadata = metadata;
        this.certificates = certificates;
        this.pair = pair;
    }

    public static ProvidedKeyPair from(KeyPairEntry entry, GeneratedKeyTemplate template) {
        return ProvidedKeyPair.builder().keyTemplate(template).pair(entry.getPair()).metadata(template.getMetadata()).certificates(entry.getCertificates()).build();
    }

    public static Templated builder() {
        return new Templated();
    }

    public Templated toBuilder() {
        Templated builder = new Templated().keyTemplate(this.keyTemplate).pair(this.pair).metadata(this.metadata);
        if (this.certificates != null) {
            builder.certificates(this.certificates);
        }
        return builder;
    }

    public static ProvidedKeyPairBuilder with() {
        return new ProvidedKeyPairBuilder();
    }

    @NonNull
    public KeyTemplate getKeyTemplate() {
        return this.keyTemplate;
    }

    @NonNull
    public KeyPair getPair() {
        return this.pair;
    }

    @NonNull
    public List<Certificate> getCertificates() {
        return this.certificates;
    }

    @Override
    public KeyMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String generateName() {
        return this.getKeyTemplate().generateName();
    }

    @Override
    public Supplier<char[]> getPassword() {
        return this.getKeyTemplate().getPassword();
    }

    public PublicKey getPublic() {
        return this.getPair().getPublic();
    }

    public PrivateKey getPrivate() {
        return this.getPair().getPrivate();
    }

    public static class ProvidedKeyPairBuilder {
        private String alias;
        private String prefix;
        private Supplier<char[]> password;
        private KeyPair pair;
        private ArrayList<Certificate> certificates;
        private KeyMetadata metadata;

        ProvidedKeyPairBuilder() {
        }

        public ProvidedKeyPairBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public ProvidedKeyPairBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public ProvidedKeyPairBuilder password(Supplier<char[]> password) {
            this.password = password;
            return this;
        }

        public ProvidedKeyPairBuilder pair(@NonNull KeyPair pair) {
            if (pair == null) {
                throw new NullPointerException("pair is marked non-null but is null");
            }
            this.pair = pair;
            return this;
        }

        public ProvidedKeyPairBuilder certificate(Certificate certificate) {
            if (this.certificates == null) {
                this.certificates = new ArrayList();
            }
            this.certificates.add(certificate);
            return this;
        }

        public ProvidedKeyPairBuilder certificates(Collection<? extends Certificate> certificates) {
            if (this.certificates == null) {
                this.certificates = new ArrayList();
            }
            this.certificates.addAll(certificates);
            return this;
        }

        public ProvidedKeyPairBuilder clearCertificates() {
            if (this.certificates != null) {
                this.certificates.clear();
            }
            return this;
        }

        public ProvidedKeyPairBuilder metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public ProvidedKeyPair build() {
            List<Certificate> certificates;
            switch (this.certificates == null ? 0 : this.certificates.size()) {
                case 0: {
                    certificates = Collections.emptyList();
                    break;
                }
                case 1: {
                    certificates = Collections.singletonList(this.certificates.get(0));
                    break;
                }
                default: {
                    certificates = Collections.unmodifiableList(new ArrayList<Certificate>(this.certificates));
                }
            }
            return new ProvidedKeyPair(this.alias, this.prefix, this.password, this.pair, certificates, this.metadata);
        }

        public String toString() {
            return "ProvidedKeyPair.ProvidedKeyPairBuilder(alias=" + this.alias + ", prefix=" + this.prefix + ", password=" + this.password + ", pair=" + this.pair + ", certificates=" + this.certificates + ", metadata=" + this.metadata + ")";
        }
    }

    public static class Templated {
        private KeyTemplate keyTemplate;
        private KeyPair pair;
        private ArrayList<Certificate> certificates;
        private KeyMetadata metadata;

        Templated() {
        }

        public Templated keyTemplate(@NonNull KeyTemplate keyTemplate) {
            if (keyTemplate == null) {
                throw new NullPointerException("keyTemplate is marked non-null but is null");
            }
            this.keyTemplate = keyTemplate;
            return this;
        }

        public Templated pair(@NonNull KeyPair pair) {
            if (pair == null) {
                throw new NullPointerException("pair is marked non-null but is null");
            }
            this.pair = pair;
            return this;
        }

        public Templated certificate(Certificate certificate) {
            if (this.certificates == null) {
                this.certificates = new ArrayList();
            }
            this.certificates.add(certificate);
            return this;
        }

        public Templated certificates(Collection<? extends Certificate> certificates) {
            if (this.certificates == null) {
                this.certificates = new ArrayList();
            }
            this.certificates.addAll(certificates);
            return this;
        }

        public Templated clearCertificates() {
            if (this.certificates != null) {
                this.certificates.clear();
            }
            return this;
        }

        public Templated metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public ProvidedKeyPair build() {
            List<Certificate> certificates;
            switch (this.certificates == null ? 0 : this.certificates.size()) {
                case 0: {
                    certificates = Collections.emptyList();
                    break;
                }
                case 1: {
                    certificates = Collections.singletonList(this.certificates.get(0));
                    break;
                }
                default: {
                    certificates = Collections.unmodifiableList(new ArrayList<Certificate>(this.certificates));
                }
            }
            return new ProvidedKeyPair(this.keyTemplate, this.pair, certificates, this.metadata);
        }

        public String toString() {
            return "ProvidedKeyPair.Templated(keyTemplate=" + this.keyTemplate + ", pair=" + this.pair + ", certificates=" + this.certificates + ", metadata=" + this.metadata + ")";
        }
    }
}

