/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.template.generated;

import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import de.adorsys.keymanagement.api.types.template.DefaultNamingStrategy;
import de.adorsys.keymanagement.api.types.template.GeneratedKeyTemplate;
import de.adorsys.keymanagement.api.types.template.KeyTemplate;
import de.adorsys.keymanagement.api.types.template.NameAndPassword;
import de.adorsys.keymanagement.api.types.template.generated.SecretKeyEncryptionTemplate;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;

public class Secret
implements GeneratedKeyTemplate {
    @NonNull
    private final KeyTemplate keyTemplate;
    @NonNull
    private final SecretKeyEncryptionTemplate encryptionTemplate;
    private final KeyMetadata metadata;

    public Collection<Secret> repeat(int times) {
        return IntStream.range(0, times).boxed().map(it -> this.toBuilder().build()).collect(Collectors.toList());
    }

    Secret(@NonNull KeyTemplate keyTemplate, @NonNull SecretKeyEncryptionTemplate encryptionTemplate, KeyMetadata metadata) {
        if (keyTemplate == null) {
            throw new NullPointerException("keyTemplate is marked non-null but is null");
        }
        if (encryptionTemplate == null) {
            throw new NullPointerException("encryptionTemplate is marked non-null but is null");
        }
        this.keyTemplate = keyTemplate;
        this.metadata = metadata;
        this.encryptionTemplate = encryptionTemplate;
    }

    Secret(String alias, String prefix, Supplier<char[]> password, String algo, Integer keySize, KeyMetadata metadata) {
        this.keyTemplate = new NameAndPassword(new DefaultNamingStrategy(alias, prefix), password);
        this.metadata = metadata;
        this.encryptionTemplate = SecretKeyEncryptionTemplate.of(algo, keySize);
    }

    public static Templated builder() {
        return new Templated();
    }

    public Templated toBuilder() {
        return new Templated().keyTemplate(this.keyTemplate).encryptionTemplate(this.encryptionTemplate).metadata(this.metadata);
    }

    public static SecretBuilder with() {
        return new SecretBuilder();
    }

    @NonNull
    public KeyTemplate getKeyTemplate() {
        return this.keyTemplate;
    }

    @NonNull
    public SecretKeyEncryptionTemplate getEncryptionTemplate() {
        return this.encryptionTemplate;
    }

    @Override
    public KeyMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String generateName() {
        return this.getKeyTemplate().generateName();
    }

    @Override
    public Supplier<char[]> getPassword() {
        return this.getKeyTemplate().getPassword();
    }

    public String getAlgo() {
        return this.getEncryptionTemplate().getAlgo();
    }

    public int getSize() {
        return this.getEncryptionTemplate().getSize();
    }

    public static class SecretBuilder {
        private String alias;
        private String prefix;
        private Supplier<char[]> password;
        private String algo;
        private Integer keySize;
        private KeyMetadata metadata;

        SecretBuilder() {
        }

        public SecretBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public SecretBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public SecretBuilder password(Supplier<char[]> password) {
            this.password = password;
            return this;
        }

        public SecretBuilder algo(String algo) {
            this.algo = algo;
            return this;
        }

        public SecretBuilder keySize(Integer keySize) {
            this.keySize = keySize;
            return this;
        }

        public SecretBuilder metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Secret build() {
            return new Secret(this.alias, this.prefix, this.password, this.algo, this.keySize, this.metadata);
        }

        public String toString() {
            return "Secret.SecretBuilder(alias=" + this.alias + ", prefix=" + this.prefix + ", password=" + this.password + ", algo=" + this.algo + ", keySize=" + this.keySize + ", metadata=" + this.metadata + ")";
        }
    }

    public static class Templated {
        private KeyTemplate keyTemplate;
        private SecretKeyEncryptionTemplate encryptionTemplate;
        private KeyMetadata metadata;

        Templated() {
        }

        public Templated keyTemplate(@NonNull KeyTemplate keyTemplate) {
            if (keyTemplate == null) {
                throw new NullPointerException("keyTemplate is marked non-null but is null");
            }
            this.keyTemplate = keyTemplate;
            return this;
        }

        public Templated encryptionTemplate(@NonNull SecretKeyEncryptionTemplate encryptionTemplate) {
            if (encryptionTemplate == null) {
                throw new NullPointerException("encryptionTemplate is marked non-null but is null");
            }
            this.encryptionTemplate = encryptionTemplate;
            return this;
        }

        public Templated metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Secret build() {
            return new Secret(this.keyTemplate, this.encryptionTemplate, this.metadata);
        }

        public String toString() {
            return "Secret.Templated(keyTemplate=" + this.keyTemplate + ", encryptionTemplate=" + this.encryptionTemplate + ", metadata=" + this.metadata + ")";
        }
    }
}

