/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.template.generated;

public class PbeKeyEncryptionTemplate {
    private final String algo;
    private final int saltLen;
    private final int iterCount;

    static PbeKeyEncryptionTemplate of(String algo, Integer saltLen, Integer iterCount) {
        PbeKeyEncryptionTemplate result = PbeKeyEncryptionTemplate.builder().build();
        if (null != algo) {
            result = result.toBuilder().algo(algo).build();
        }
        if (null != saltLen) {
            result = result.toBuilder().saltLen(saltLen).build();
        }
        if (null != iterCount) {
            result = result.toBuilder().iterCount(iterCount).build();
        }
        return result;
    }

    private static String $default$algo() {
        return "PBEWithSHA256And256BitAES-CBC-BC";
    }

    private static int $default$saltLen() {
        return 8;
    }

    private static int $default$iterCount() {
        return 1024;
    }

    PbeKeyEncryptionTemplate(String algo, int saltLen, int iterCount) {
        this.algo = algo;
        this.saltLen = saltLen;
        this.iterCount = iterCount;
    }

    public static PbeKeyEncryptionTemplateBuilder builder() {
        return new PbeKeyEncryptionTemplateBuilder();
    }

    public PbeKeyEncryptionTemplateBuilder toBuilder() {
        return new PbeKeyEncryptionTemplateBuilder().algo(this.algo).saltLen(this.saltLen).iterCount(this.iterCount);
    }

    public String getAlgo() {
        return this.algo;
    }

    public int getSaltLen() {
        return this.saltLen;
    }

    public int getIterCount() {
        return this.iterCount;
    }

    public static class PbeKeyEncryptionTemplateBuilder {
        private boolean algo$set;
        private String algo$value;
        private boolean saltLen$set;
        private int saltLen$value;
        private boolean iterCount$set;
        private int iterCount$value;

        PbeKeyEncryptionTemplateBuilder() {
        }

        public PbeKeyEncryptionTemplateBuilder algo(String algo) {
            this.algo$value = algo;
            this.algo$set = true;
            return this;
        }

        public PbeKeyEncryptionTemplateBuilder saltLen(int saltLen) {
            this.saltLen$value = saltLen;
            this.saltLen$set = true;
            return this;
        }

        public PbeKeyEncryptionTemplateBuilder iterCount(int iterCount) {
            this.iterCount$value = iterCount;
            this.iterCount$set = true;
            return this;
        }

        public PbeKeyEncryptionTemplate build() {
            String algo$value = this.algo$value;
            if (!this.algo$set) {
                algo$value = PbeKeyEncryptionTemplate.$default$algo();
            }
            int saltLen$value = this.saltLen$value;
            if (!this.saltLen$set) {
                saltLen$value = PbeKeyEncryptionTemplate.$default$saltLen();
            }
            int iterCount$value = this.iterCount$value;
            if (!this.iterCount$set) {
                iterCount$value = PbeKeyEncryptionTemplate.$default$iterCount();
            }
            return new PbeKeyEncryptionTemplate(algo$value, saltLen$value, iterCount$value);
        }

        public String toString() {
            return "PbeKeyEncryptionTemplate.PbeKeyEncryptionTemplateBuilder(algo$value=" + this.algo$value + ", saltLen$value=" + this.saltLen$value + ", iterCount$value=" + this.iterCount$value + ")";
        }
    }

    public static interface ExcludeToBuilder {
        public PbeKeyEncryptionTemplate toBuilder();
    }
}

