/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.template.generated;

import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import de.adorsys.keymanagement.api.types.template.DefaultNamingStrategy;
import de.adorsys.keymanagement.api.types.template.GeneratedKeyTemplate;
import de.adorsys.keymanagement.api.types.template.KeyTemplate;
import de.adorsys.keymanagement.api.types.template.NameAndPassword;
import de.adorsys.keymanagement.api.types.template.generated.PbeKeyEncryptionTemplate;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;

public class Pbe
implements GeneratedKeyTemplate {
    @NonNull
    private final KeyTemplate keyTemplate;
    @NonNull
    private final PbeKeyEncryptionTemplate encryptionTemplate;
    private final char[] data;
    private final KeyMetadata metadata;

    public Collection<Pbe> repeat(int times) {
        return IntStream.range(0, times).boxed().map(it -> this.toBuilder().build()).collect(Collectors.toList());
    }

    Pbe(@NonNull char[] data, @NonNull KeyTemplate keyTemplate, @NonNull PbeKeyEncryptionTemplate encryptionTemplate, KeyMetadata metadata) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (keyTemplate == null) {
            throw new NullPointerException("keyTemplate is marked non-null but is null");
        }
        if (encryptionTemplate == null) {
            throw new NullPointerException("encryptionTemplate is marked non-null but is null");
        }
        this.data = data;
        this.keyTemplate = keyTemplate;
        this.metadata = metadata;
        this.encryptionTemplate = encryptionTemplate;
    }

    Pbe(@NonNull char[] data, String alias, String prefix, Supplier<char[]> password, String algo, Integer saltLen, Integer iterCount, KeyMetadata metadata) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = data;
        this.keyTemplate = new NameAndPassword(new DefaultNamingStrategy(alias, prefix), password);
        this.metadata = metadata;
        this.encryptionTemplate = PbeKeyEncryptionTemplate.of(algo, saltLen, iterCount);
    }

    public static Templated builder() {
        return new Templated();
    }

    public Templated toBuilder() {
        return new Templated().data(this.data).keyTemplate(this.keyTemplate).encryptionTemplate(this.encryptionTemplate).metadata(this.metadata);
    }

    public static PbeBuilder with() {
        return new PbeBuilder();
    }

    @NonNull
    public KeyTemplate getKeyTemplate() {
        return this.keyTemplate;
    }

    @NonNull
    public PbeKeyEncryptionTemplate getEncryptionTemplate() {
        return this.encryptionTemplate;
    }

    public char[] getData() {
        return this.data;
    }

    @Override
    public KeyMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String generateName() {
        return this.getKeyTemplate().generateName();
    }

    @Override
    public Supplier<char[]> getPassword() {
        return this.getKeyTemplate().getPassword();
    }

    public String getAlgo() {
        return this.getEncryptionTemplate().getAlgo();
    }

    public int getSaltLen() {
        return this.getEncryptionTemplate().getSaltLen();
    }

    public int getIterCount() {
        return this.getEncryptionTemplate().getIterCount();
    }

    public static class PbeBuilder {
        private char[] data;
        private String alias;
        private String prefix;
        private Supplier<char[]> password;
        private String algo;
        private Integer saltLen;
        private Integer iterCount;
        private KeyMetadata metadata;

        PbeBuilder() {
        }

        public PbeBuilder data(@NonNull char[] data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
            return this;
        }

        public PbeBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public PbeBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public PbeBuilder password(Supplier<char[]> password) {
            this.password = password;
            return this;
        }

        public PbeBuilder algo(String algo) {
            this.algo = algo;
            return this;
        }

        public PbeBuilder saltLen(Integer saltLen) {
            this.saltLen = saltLen;
            return this;
        }

        public PbeBuilder iterCount(Integer iterCount) {
            this.iterCount = iterCount;
            return this;
        }

        public PbeBuilder metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Pbe build() {
            return new Pbe(this.data, this.alias, this.prefix, this.password, this.algo, this.saltLen, this.iterCount, this.metadata);
        }

        public String toString() {
            return "Pbe.PbeBuilder(data=" + Arrays.toString(this.data) + ", alias=" + this.alias + ", prefix=" + this.prefix + ", password=" + this.password + ", algo=" + this.algo + ", saltLen=" + this.saltLen + ", iterCount=" + this.iterCount + ", metadata=" + this.metadata + ")";
        }
    }

    public static class Templated {
        private char[] data;
        private KeyTemplate keyTemplate;
        private PbeKeyEncryptionTemplate encryptionTemplate;
        private KeyMetadata metadata;

        Templated() {
        }

        public Templated data(@NonNull char[] data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
            return this;
        }

        public Templated keyTemplate(@NonNull KeyTemplate keyTemplate) {
            if (keyTemplate == null) {
                throw new NullPointerException("keyTemplate is marked non-null but is null");
            }
            this.keyTemplate = keyTemplate;
            return this;
        }

        public Templated encryptionTemplate(@NonNull PbeKeyEncryptionTemplate encryptionTemplate) {
            if (encryptionTemplate == null) {
                throw new NullPointerException("encryptionTemplate is marked non-null but is null");
            }
            this.encryptionTemplate = encryptionTemplate;
            return this;
        }

        public Templated metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Pbe build() {
            return new Pbe(this.data, this.keyTemplate, this.encryptionTemplate, this.metadata);
        }

        public String toString() {
            return "Pbe.Templated(data=" + Arrays.toString(this.data) + ", keyTemplate=" + this.keyTemplate + ", encryptionTemplate=" + this.encryptionTemplate + ", metadata=" + this.metadata + ")";
        }
    }
}

