/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.source;

import de.adorsys.keymanagement.api.types.template.provided.ProvidedKey;
import de.adorsys.keymanagement.api.types.template.provided.ProvidedKeyEntry;
import de.adorsys.keymanagement.api.types.template.provided.ProvidedKeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class KeySet {
    private final List<ProvidedKeyEntry> keyEntries;
    private final List<ProvidedKey> keys;
    private final List<ProvidedKeyPair> keyPairs;

    public static KeySetBuilder builder() {
        return new KeySetBuilder();
    }

    public List<ProvidedKeyEntry> getKeyEntries() {
        return this.keyEntries;
    }

    public List<ProvidedKey> getKeys() {
        return this.keys;
    }

    public List<ProvidedKeyPair> getKeyPairs() {
        return this.keyPairs;
    }

    public KeySet(List<ProvidedKeyEntry> keyEntries, List<ProvidedKey> keys, List<ProvidedKeyPair> keyPairs) {
        this.keyEntries = keyEntries;
        this.keys = keys;
        this.keyPairs = keyPairs;
    }

    public static class KeySetBuilder {
        private ArrayList<ProvidedKeyEntry> keyEntries;
        private ArrayList<ProvidedKey> keys;
        private ArrayList<ProvidedKeyPair> keyPairs;

        KeySetBuilder() {
        }

        public KeySetBuilder keyEntry(ProvidedKeyEntry keyEntry) {
            if (this.keyEntries == null) {
                this.keyEntries = new ArrayList();
            }
            this.keyEntries.add(keyEntry);
            return this;
        }

        public KeySetBuilder keyEntries(Collection<? extends ProvidedKeyEntry> keyEntries) {
            if (this.keyEntries == null) {
                this.keyEntries = new ArrayList();
            }
            this.keyEntries.addAll(keyEntries);
            return this;
        }

        public KeySetBuilder clearKeyEntries() {
            if (this.keyEntries != null) {
                this.keyEntries.clear();
            }
            return this;
        }

        public KeySetBuilder key(ProvidedKey key) {
            if (this.keys == null) {
                this.keys = new ArrayList();
            }
            this.keys.add(key);
            return this;
        }

        public KeySetBuilder keys(Collection<? extends ProvidedKey> keys) {
            if (this.keys == null) {
                this.keys = new ArrayList();
            }
            this.keys.addAll(keys);
            return this;
        }

        public KeySetBuilder clearKeys() {
            if (this.keys != null) {
                this.keys.clear();
            }
            return this;
        }

        public KeySetBuilder keyPair(ProvidedKeyPair keyPair) {
            if (this.keyPairs == null) {
                this.keyPairs = new ArrayList();
            }
            this.keyPairs.add(keyPair);
            return this;
        }

        public KeySetBuilder keyPairs(Collection<? extends ProvidedKeyPair> keyPairs) {
            if (this.keyPairs == null) {
                this.keyPairs = new ArrayList();
            }
            this.keyPairs.addAll(keyPairs);
            return this;
        }

        public KeySetBuilder clearKeyPairs() {
            if (this.keyPairs != null) {
                this.keyPairs.clear();
            }
            return this;
        }

        public KeySet build() {
            List<ProvidedKeyPair> keyPairs;
            List<ProvidedKey> keys;
            List<ProvidedKeyEntry> keyEntries;
            switch (this.keyEntries == null ? 0 : this.keyEntries.size()) {
                case 0: {
                    keyEntries = Collections.emptyList();
                    break;
                }
                case 1: {
                    keyEntries = Collections.singletonList(this.keyEntries.get(0));
                    break;
                }
                default: {
                    keyEntries = Collections.unmodifiableList(new ArrayList<ProvidedKeyEntry>(this.keyEntries));
                }
            }
            switch (this.keys == null ? 0 : this.keys.size()) {
                case 0: {
                    keys = Collections.emptyList();
                    break;
                }
                case 1: {
                    keys = Collections.singletonList(this.keys.get(0));
                    break;
                }
                default: {
                    keys = Collections.unmodifiableList(new ArrayList<ProvidedKey>(this.keys));
                }
            }
            switch (this.keyPairs == null ? 0 : this.keyPairs.size()) {
                case 0: {
                    keyPairs = Collections.emptyList();
                    break;
                }
                case 1: {
                    keyPairs = Collections.singletonList(this.keyPairs.get(0));
                    break;
                }
                default: {
                    keyPairs = Collections.unmodifiableList(new ArrayList<ProvidedKeyPair>(this.keyPairs));
                }
            }
            return new KeySet(keyEntries, keys, keyPairs);
        }

        public String toString() {
            return "KeySet.KeySetBuilder(keyEntries=" + this.keyEntries + ", keys=" + this.keys + ", keyPairs=" + this.keyPairs + ")";
        }
    }
}

