/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.entity;

import java.security.KeyPair;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class KeyPairEntry {
    @NonNull
    private final KeyPair pair;
    @NonNull
    private final List<Certificate> certificates;

    KeyPairEntry(@NonNull KeyPair pair, @NonNull List<Certificate> certificates) {
        if (pair == null) {
            throw new NullPointerException("pair is marked non-null but is null");
        }
        if (certificates == null) {
            throw new NullPointerException("certificates is marked non-null but is null");
        }
        this.pair = pair;
        this.certificates = certificates;
    }

    public static KeyPairEntryBuilder builder() {
        return new KeyPairEntryBuilder();
    }

    @NonNull
    public KeyPair getPair() {
        return this.pair;
    }

    @NonNull
    public List<Certificate> getCertificates() {
        return this.certificates;
    }

    public static class KeyPairEntryBuilder {
        private KeyPair pair;
        private ArrayList<Certificate> certificates;

        KeyPairEntryBuilder() {
        }

        public KeyPairEntryBuilder pair(@NonNull KeyPair pair) {
            if (pair == null) {
                throw new NullPointerException("pair is marked non-null but is null");
            }
            this.pair = pair;
            return this;
        }

        public KeyPairEntryBuilder certificate(Certificate certificate) {
            if (this.certificates == null) {
                this.certificates = new ArrayList();
            }
            this.certificates.add(certificate);
            return this;
        }

        public KeyPairEntryBuilder certificates(Collection<? extends Certificate> certificates) {
            if (this.certificates == null) {
                this.certificates = new ArrayList();
            }
            this.certificates.addAll(certificates);
            return this;
        }

        public KeyPairEntryBuilder clearCertificates() {
            if (this.certificates != null) {
                this.certificates.clear();
            }
            return this;
        }

        public KeyPairEntry build() {
            List<Certificate> certificates;
            switch (this.certificates == null ? 0 : this.certificates.size()) {
                case 0: {
                    certificates = Collections.emptyList();
                    break;
                }
                case 1: {
                    certificates = Collections.singletonList(this.certificates.get(0));
                    break;
                }
                default: {
                    certificates = Collections.unmodifiableList(new ArrayList<Certificate>(this.certificates));
                }
            }
            return new KeyPairEntry(this.pair, certificates);
        }

        public String toString() {
            return "KeyPairEntry.KeyPairEntryBuilder(pair=" + this.pair + ", certificates=" + this.certificates + ")";
        }
    }
}

