/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.entity;

import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import lombok.NonNull;

public class AliasWithMeta<T extends KeyMetadata> {
    @NonNull
    private final String alias;
    private final T metadata;

    AliasWithMeta(@NonNull String alias, T metadata) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        this.alias = alias;
        this.metadata = metadata;
    }

    public static <T extends KeyMetadata> AliasWithMetaBuilder<T> builder() {
        return new AliasWithMetaBuilder();
    }

    public AliasWithMetaBuilder<T> toBuilder() {
        return new AliasWithMetaBuilder().alias(this.alias).metadata(this.metadata);
    }

    @NonNull
    public String getAlias() {
        return this.alias;
    }

    public T getMetadata() {
        return this.metadata;
    }

    public static class AliasWithMetaBuilder<T extends KeyMetadata> {
        private String alias;
        private T metadata;

        AliasWithMetaBuilder() {
        }

        public AliasWithMetaBuilder<T> alias(@NonNull String alias) {
            if (alias == null) {
                throw new NullPointerException("alias is marked non-null but is null");
            }
            this.alias = alias;
            return this;
        }

        public AliasWithMetaBuilder<T> metadata(T metadata) {
            this.metadata = metadata;
            return this;
        }

        public AliasWithMeta<T> build() {
            return new AliasWithMeta<T>(this.alias, this.metadata);
        }

        public String toString() {
            return "AliasWithMeta.AliasWithMetaBuilder(alias=" + this.alias + ", metadata=" + this.metadata + ")";
        }
    }
}

