/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types;

import com.google.common.collect.ImmutableList;
import de.adorsys.keymanagement.api.types.template.generated.Encrypting;
import de.adorsys.keymanagement.api.types.template.generated.Secret;
import de.adorsys.keymanagement.api.types.template.generated.Signing;
import de.adorsys.keymanagement.api.types.template.provided.ProvidedKey;
import de.adorsys.keymanagement.api.types.template.provided.ProvidedKeyEntry;
import de.adorsys.keymanagement.api.types.template.provided.ProvidedKeyPair;
import lombok.NonNull;

public class KeySetTemplate {
    private final ImmutableList<@NonNull ProvidedKey> providedKeys;
    private final ImmutableList<@NonNull ProvidedKeyPair> providedPairs;
    private final ImmutableList<@NonNull ProvidedKeyEntry> providedKeyEntries;
    private final ImmutableList<@NonNull Secret> generatedSecretKeys;
    private final ImmutableList<@NonNull Encrypting> generatedEncryptionKeys;
    private final ImmutableList<@NonNull Signing> generatedSigningKeys;

    KeySetTemplate(ImmutableList<@NonNull ProvidedKey> providedKeys, ImmutableList<@NonNull ProvidedKeyPair> providedPairs, ImmutableList<@NonNull ProvidedKeyEntry> providedKeyEntries, ImmutableList<@NonNull Secret> generatedSecretKeys, ImmutableList<@NonNull Encrypting> generatedEncryptionKeys, ImmutableList<@NonNull Signing> generatedSigningKeys) {
        this.providedKeys = providedKeys;
        this.providedPairs = providedPairs;
        this.providedKeyEntries = providedKeyEntries;
        this.generatedSecretKeys = generatedSecretKeys;
        this.generatedEncryptionKeys = generatedEncryptionKeys;
        this.generatedSigningKeys = generatedSigningKeys;
    }

    public static KeySetTemplateBuilder builder() {
        return new KeySetTemplateBuilder();
    }

    public ImmutableList<@NonNull ProvidedKey> providedKeys() {
        return this.providedKeys;
    }

    public ImmutableList<@NonNull ProvidedKeyPair> providedPairs() {
        return this.providedPairs;
    }

    public ImmutableList<@NonNull ProvidedKeyEntry> providedKeyEntries() {
        return this.providedKeyEntries;
    }

    public ImmutableList<@NonNull Secret> generatedSecretKeys() {
        return this.generatedSecretKeys;
    }

    public ImmutableList<@NonNull Encrypting> generatedEncryptionKeys() {
        return this.generatedEncryptionKeys;
    }

    public ImmutableList<@NonNull Signing> generatedSigningKeys() {
        return this.generatedSigningKeys;
    }

    public static class KeySetTemplateBuilder {
        private // Could not load outer class - annotation placement on inner may be incorrect
        ImmutableList.Builder<@NonNull ProvidedKey> providedKeys;
        private // Could not load outer class - annotation placement on inner may be incorrect
        ImmutableList.Builder<@NonNull ProvidedKeyPair> providedPairs;
        private // Could not load outer class - annotation placement on inner may be incorrect
        ImmutableList.Builder<@NonNull ProvidedKeyEntry> providedKeyEntries;
        private // Could not load outer class - annotation placement on inner may be incorrect
        ImmutableList.Builder<@NonNull Secret> generatedSecretKeys;
        private // Could not load outer class - annotation placement on inner may be incorrect
        ImmutableList.Builder<@NonNull Encrypting> generatedEncryptionKeys;
        private // Could not load outer class - annotation placement on inner may be incorrect
        ImmutableList.Builder<@NonNull Signing> generatedSigningKeys;

        KeySetTemplateBuilder() {
        }

        public KeySetTemplateBuilder providedKey(@NonNull ProvidedKey providedKey) {
            if (providedKey == null) {
                throw new NullPointerException("providedKey is marked non-null but is null");
            }
            if (this.providedKeys == null) {
                this.providedKeys = ImmutableList.builder();
            }
            this.providedKeys.add((Object)providedKey);
            return this;
        }

        public KeySetTemplateBuilder providedKeys(Iterable<? extends @NonNull ProvidedKey> providedKeys) {
            if (this.providedKeys == null) {
                this.providedKeys = ImmutableList.builder();
            }
            this.providedKeys.addAll(providedKeys);
            return this;
        }

        public KeySetTemplateBuilder clearProvidedKeys() {
            this.providedKeys = null;
            return this;
        }

        public KeySetTemplateBuilder providedPair(@NonNull ProvidedKeyPair providedPair) {
            if (providedPair == null) {
                throw new NullPointerException("providedPair is marked non-null but is null");
            }
            if (this.providedPairs == null) {
                this.providedPairs = ImmutableList.builder();
            }
            this.providedPairs.add((Object)providedPair);
            return this;
        }

        public KeySetTemplateBuilder providedPairs(Iterable<? extends @NonNull ProvidedKeyPair> providedPairs) {
            if (this.providedPairs == null) {
                this.providedPairs = ImmutableList.builder();
            }
            this.providedPairs.addAll(providedPairs);
            return this;
        }

        public KeySetTemplateBuilder clearProvidedPairs() {
            this.providedPairs = null;
            return this;
        }

        public KeySetTemplateBuilder providedKeyEntry(@NonNull ProvidedKeyEntry providedKeyEntry) {
            if (providedKeyEntry == null) {
                throw new NullPointerException("providedKeyEntry is marked non-null but is null");
            }
            if (this.providedKeyEntries == null) {
                this.providedKeyEntries = ImmutableList.builder();
            }
            this.providedKeyEntries.add((Object)providedKeyEntry);
            return this;
        }

        public KeySetTemplateBuilder providedKeyEntries(Iterable<? extends @NonNull ProvidedKeyEntry> providedKeyEntries) {
            if (this.providedKeyEntries == null) {
                this.providedKeyEntries = ImmutableList.builder();
            }
            this.providedKeyEntries.addAll(providedKeyEntries);
            return this;
        }

        public KeySetTemplateBuilder clearProvidedKeyEntries() {
            this.providedKeyEntries = null;
            return this;
        }

        public KeySetTemplateBuilder generatedSecretKey(@NonNull Secret generatedSecretKey) {
            if (generatedSecretKey == null) {
                throw new NullPointerException("generatedSecretKey is marked non-null but is null");
            }
            if (this.generatedSecretKeys == null) {
                this.generatedSecretKeys = ImmutableList.builder();
            }
            this.generatedSecretKeys.add((Object)generatedSecretKey);
            return this;
        }

        public KeySetTemplateBuilder generatedSecretKeys(Iterable<? extends @NonNull Secret> generatedSecretKeys) {
            if (this.generatedSecretKeys == null) {
                this.generatedSecretKeys = ImmutableList.builder();
            }
            this.generatedSecretKeys.addAll(generatedSecretKeys);
            return this;
        }

        public KeySetTemplateBuilder clearGeneratedSecretKeys() {
            this.generatedSecretKeys = null;
            return this;
        }

        public KeySetTemplateBuilder generatedEncryptionKey(@NonNull Encrypting generatedEncryptionKey) {
            if (generatedEncryptionKey == null) {
                throw new NullPointerException("generatedEncryptionKey is marked non-null but is null");
            }
            if (this.generatedEncryptionKeys == null) {
                this.generatedEncryptionKeys = ImmutableList.builder();
            }
            this.generatedEncryptionKeys.add((Object)generatedEncryptionKey);
            return this;
        }

        public KeySetTemplateBuilder generatedEncryptionKeys(Iterable<? extends @NonNull Encrypting> generatedEncryptionKeys) {
            if (this.generatedEncryptionKeys == null) {
                this.generatedEncryptionKeys = ImmutableList.builder();
            }
            this.generatedEncryptionKeys.addAll(generatedEncryptionKeys);
            return this;
        }

        public KeySetTemplateBuilder clearGeneratedEncryptionKeys() {
            this.generatedEncryptionKeys = null;
            return this;
        }

        public KeySetTemplateBuilder generatedSigningKey(@NonNull Signing generatedSigningKey) {
            if (generatedSigningKey == null) {
                throw new NullPointerException("generatedSigningKey is marked non-null but is null");
            }
            if (this.generatedSigningKeys == null) {
                this.generatedSigningKeys = ImmutableList.builder();
            }
            this.generatedSigningKeys.add((Object)generatedSigningKey);
            return this;
        }

        public KeySetTemplateBuilder generatedSigningKeys(Iterable<? extends @NonNull Signing> generatedSigningKeys) {
            if (this.generatedSigningKeys == null) {
                this.generatedSigningKeys = ImmutableList.builder();
            }
            this.generatedSigningKeys.addAll(generatedSigningKeys);
            return this;
        }

        public KeySetTemplateBuilder clearGeneratedSigningKeys() {
            this.generatedSigningKeys = null;
            return this;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public KeySetTemplate build() {
            @NonNull ImmutableList providedKeys = this.providedKeys == null ? ImmutableList.of() : this.providedKeys.build();
            @NonNull ImmutableList providedPairs = this.providedPairs == null ? ImmutableList.of() : this.providedPairs.build();
            @NonNull ImmutableList providedKeyEntries = this.providedKeyEntries == null ? ImmutableList.of() : this.providedKeyEntries.build();
            @NonNull ImmutableList generatedSecretKeys = this.generatedSecretKeys == null ? ImmutableList.of() : this.generatedSecretKeys.build();
            @NonNull ImmutableList generatedEncryptionKeys = this.generatedEncryptionKeys == null ? ImmutableList.of() : this.generatedEncryptionKeys.build();
            @NonNull ImmutableList generatedSigningKeys = this.generatedSigningKeys == null ? ImmutableList.of() : this.generatedSigningKeys.build();
            return new KeySetTemplate((ImmutableList<ProvidedKey>)providedKeys, (ImmutableList<ProvidedKeyPair>)providedPairs, (ImmutableList<ProvidedKeyEntry>)providedKeyEntries, (ImmutableList<Secret>)generatedSecretKeys, (ImmutableList<Encrypting>)generatedEncryptionKeys, (ImmutableList<Signing>)generatedSigningKeys);
        }

        public String toString() {
            return "KeySetTemplate.KeySetTemplateBuilder(providedKeys=" + this.providedKeys + ", providedPairs=" + this.providedPairs + ", providedKeyEntries=" + this.providedKeyEntries + ", generatedSecretKeys=" + this.generatedSecretKeys + ", generatedEncryptionKeys=" + this.generatedEncryptionKeys + ", generatedSigningKeys=" + this.generatedSigningKeys + ")";
        }
    }
}

