/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.config.keystore.pbkdf;

public class PBKDF2 {
    private final String algo;
    private final int saltLength;
    private final int iterCount;

    private static String $default$algo() {
        return "PRF_SHA512";
    }

    private static int $default$saltLength() {
        return 32;
    }

    private static int $default$iterCount() {
        return 20480;
    }

    PBKDF2(String algo, int saltLength, int iterCount) {
        this.algo = algo;
        this.saltLength = saltLength;
        this.iterCount = iterCount;
    }

    public static PBKDF2Builder builder() {
        return new PBKDF2Builder();
    }

    public String getAlgo() {
        return this.algo;
    }

    public int getSaltLength() {
        return this.saltLength;
    }

    public int getIterCount() {
        return this.iterCount;
    }

    public static class PBKDF2Builder {
        private boolean algo$set;
        private String algo$value;
        private boolean saltLength$set;
        private int saltLength$value;
        private boolean iterCount$set;
        private int iterCount$value;

        PBKDF2Builder() {
        }

        public PBKDF2Builder algo(String algo) {
            this.algo$value = algo;
            this.algo$set = true;
            return this;
        }

        public PBKDF2Builder saltLength(int saltLength) {
            this.saltLength$value = saltLength;
            this.saltLength$set = true;
            return this;
        }

        public PBKDF2Builder iterCount(int iterCount) {
            this.iterCount$value = iterCount;
            this.iterCount$set = true;
            return this;
        }

        public PBKDF2 build() {
            String algo$value = this.algo$value;
            if (!this.algo$set) {
                algo$value = PBKDF2.$default$algo();
            }
            int saltLength$value = this.saltLength$value;
            if (!this.saltLength$set) {
                saltLength$value = PBKDF2.$default$saltLength();
            }
            int iterCount$value = this.iterCount$value;
            if (!this.iterCount$set) {
                iterCount$value = PBKDF2.$default$iterCount();
            }
            return new PBKDF2(algo$value, saltLength$value, iterCount$value);
        }

        public String toString() {
            return "PBKDF2.PBKDF2Builder(algo$value=" + this.algo$value + ", saltLength$value=" + this.saltLength$value + ", iterCount$value=" + this.iterCount$value + ")";
        }
    }
}

