/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags.html;

import java.io.Serializable;
import java.util.ArrayList;

public class TreeNode
implements Serializable {
    public static final String SELECTED_NODE = "netui_treeselected";
    public static final String EXPAND_NODE = "netui_treenode";
    protected ArrayList children = new ArrayList();
    protected String action = null;
    protected boolean expanded = false;
    protected String href = null;
    protected String icon = null;
    protected String label = null;
    protected boolean last = false;
    protected String name = null;
    protected TreeNode parent = null;
    protected boolean selected = false;
    protected String target = null;
    protected int width = 0;

    public TreeNode(String icon, String label, String action, String href, String target, boolean expanded) {
        this.icon = icon;
        this.label = label;
        this.action = action;
        this.href = href;
        this.target = target;
        this.expanded = expanded;
    }

    public String getAction() {
        return this.action;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public String getHref() {
        return this.href;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLeaf() {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            return this.children.size() < 1;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
        this.width = parent == null ? 1 : parent.getWidth() + 1;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getTarget() {
        return this.target;
    }

    public int getWidth() {
        int maxWidth = this.width;
        if (!this.isExpanded()) {
            return this.width;
        }
        TreeNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            int current = children[i].getWidth();
            if (current > maxWidth) {
                maxWidth = current;
            }
            ++i;
        }
        return maxWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(TreeNode child) throws IllegalArgumentException {
        TreeNode theChild = child;
        theChild.setParent(this);
        if (this.getName() == null) {
            this.setName("0");
        }
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            int n = this.children.size();
            if (n > 0) {
                TreeNode node = (TreeNode)this.children.get(n - 1);
                node.setLast(false);
            }
            theChild.setLast(true);
            this.children.add(child);
            n = this.children.size();
            theChild.updateName(this, n - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(int offset, TreeNode child) throws IllegalArgumentException {
        child.setParent(this);
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            this.children.add(offset, child);
            int size = this.children.size();
            int i = offset;
            while (i < size) {
                TreeNode thisChild = (TreeNode)this.children.get(i);
                thisChild.updateName(this, i);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeNode[] getChildren() {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            TreeNode[] results = new TreeNode[this.children.size()];
            return this.children.toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeNode getChild(int index) {
        TreeNode childNode = null;
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            Object child = this.children.get(index);
            if (child != null) {
                childNode = (TreeNode)child;
            }
        }
        return childNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(int offset) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            TreeNode child = (TreeNode)this.children.get(offset);
            child.setParent(null);
            child.setName(null);
            int size = this.children.size();
            int i = offset;
            while (i < size) {
                TreeNode thisChild = (TreeNode)this.children.get(i);
                thisChild.updateName(this, i);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(TreeNode child) {
        if (child == null) {
            return;
        }
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            int size = this.children.size();
            int removeIndex = -1;
            int i = 0;
            while (i < size) {
                if (child == (TreeNode)this.children.get(i)) {
                    this.children.remove(i);
                    child.setParent(null);
                    removeIndex = i;
                    break;
                }
                ++i;
            }
            if (removeIndex >= 0) {
                size = this.children.size();
                int i2 = removeIndex;
                while (i2 < size) {
                    TreeNode thisChild = (TreeNode)this.children.get(i2);
                    thisChild.updateName(this, i2);
                    ++i2;
                }
            }
        }
    }

    public void updateName(TreeNode parentNode, int index) {
        this.setName(this.getNodeName(parentNode, index));
        TreeNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].updateName(this, i);
            ++i;
        }
    }

    public void collapse() {
    }

    public void expand() {
    }

    private String getNodeName(TreeNode parentNode, int index) {
        String nodeName = "" + index;
        if (parentNode != null) {
            nodeName = parentNode.getName() + "." + nodeName;
        }
        return nodeName;
    }

    public TreeNode getRoot(TreeNode node) {
        TreeNode parentNode = node.getParent();
        while (parentNode != null) {
            node = parentNode;
            parentNode = node.getParent();
        }
        return node;
    }

    public TreeNode findNode(String nodeName) {
        TreeNode root = this.getRoot(this);
        TreeNode node = root.findNodeRecurse(nodeName, nodeName);
        return node;
    }

    private TreeNode findNodeRecurse(String fullName, String currentName) {
        String currentIndex = this.name;
        String remainingName = null;
        if (currentName == null || fullName == null) {
            return null;
        }
        if (this.getName().equals(fullName)) {
            return this;
        }
        if (currentName.indexOf(46) > 0) {
            currentIndex = currentName.substring(0, currentName.indexOf(46));
            remainingName = currentName.substring(currentName.indexOf(46) + 1);
            int nextIndex = -1;
            nextIndex = remainingName.indexOf(".") > -1 ? new Integer(remainingName.substring(0, remainingName.indexOf(46))).intValue() : new Integer(remainingName).intValue();
            TreeNode child = this.getChild(nextIndex);
            if (child != null) {
                return child.findNodeRecurse(fullName, remainingName);
            }
            return null;
        }
        return null;
    }
}

