/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags.databinding;

import com.bea.control.DatabaseFilter;
import com.bea.wlw.netui.script.ExpressionEvaluatorFactory;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.iterator.IteratorFactory;
import com.bea.wlw.netui.util.iterator.IteratorFactoryException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import weblogic.utils.UnsyncStringBuffer;

public final class SortFilterService {
    private static final Debug debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$tags$databinding$SortFilterService == null ? (class$com$bea$wlw$netui$tags$databinding$SortFilterService = SortFilterService.class$("com.bea.wlw.netui.tags.databinding.SortFilterService")) : class$com$bea$wlw$netui$tags$databinding$SortFilterService));
    public static final String REQUEST_KEY = "netui_grid_sortFiliter";
    public static final int SORT_NONE = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;
    public static final String ROW_IDENTIFIER = "_autoscope__rowId";
    public static final String PRIMARY_KEY = "_autoscope__rowId";
    private static final String BASE_SORT_KEY = "_sort";
    private static final String SORT_KEY = "_autoscope__sort";
    private static final String FILTER_KEY = "_autoscope__filter";
    private static final String CURRENTPAGE_KEY = "_autoscope__currPage";
    private static final String PAGESIZE_KEY = "_autoscope__pageSize";
    private static final List EMPTY_LIST = new ArrayList();
    private static final int DEFAULT_PAGE_SIZE = 10;
    private static final String DELIM = "~";
    private static final String AMP = "&";
    private static final String EMPTY_STRING = "";
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static Map knownKeyHash = null;
    private List filterTerms = null;
    private List sortTerms = null;
    private List rowIds = null;
    private Map currentPages = null;
    private Map unknownParams = null;
    private int pageSize = 10;
    static /* synthetic */ Class class$com$bea$wlw$netui$tags$databinding$SortFilterService;

    public static SortFilterService getInstance(Object object) {
        if (object instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)object;
            if (SortFilterService.debug.ON) {
                debug.out("SortFilterService identityHashCode: " + System.identityHashCode(object) + " present in request: " + (request.getAttribute(REQUEST_KEY) != null ? "true" : "false"));
            }
            if (request.getAttribute(REQUEST_KEY) != null) {
                return (SortFilterService)request.getAttribute(REQUEST_KEY);
            }
            SortFilterService service = new SortFilterService(request);
            request.setAttribute(REQUEST_KEY, (Object)service);
            return service;
        }
        String msg = null;
        msg = object == null ? Bundle.getErrorString((String)"SortFilterService_illegalInitType_null") : Bundle.getErrorString((String)"SortFilterService_illegalInitType", (Object[])new Object[]{object.getClass().getName()});
        throw new IllegalArgumentException(msg);
    }

    public DatabaseFilter getDatabaseFilter(String gridName) {
        if (gridName == null) {
            return null;
        }
        UnsyncStringBuffer buf = new UnsyncStringBuffer(512);
        String pattern = "^" + gridName + ".*";
        buf.append(this.getDatabaseFilter_SortString(gridName, pattern));
        buf.append(AMP);
        buf.append(this.getDatabaseFilter_FilterString(gridName, pattern));
        if (SortFilterService.debug.ON) {
            debug.out("\nDatabaseFilter clause: " + buf.toString());
        }
        DatabaseFilter dbFilter = new DatabaseFilter();
        try {
            dbFilter.parseQueryString(buf.toString(), gridName, null);
        }
        catch (UnsupportedEncodingException uee) {
            System.err.println(Bundle.getErrorString((String)"SortFilterService_filterEncodingException", (Object[])new Object[]{buf.toString()}));
        }
        return dbFilter;
    }

    public Map getQueryParamsMap() {
        Map map = this.getQueryParamsMapInternal(this.getRowIds(), null, this.getCurrentPage(null), this.getPageSize(), null, null, null, null);
        map = this.normalizeMap(map);
        return map;
    }

    public Map getQueryParamsMapWithPage(String gridName, int page) {
        if (SortFilterService.debug.ON) {
            debug.out("queryParamsMapWithPage.  Grid: " + gridName + " page: " + page);
        }
        Map map = this.getQueryParamsMapInternal(this.getRowIds(), gridName, page, this.getPageSize(), null, null, null, null);
        map = this.normalizeMap(map);
        return map;
    }

    public Map getQueryParamsMapWithSort(String gridName, String columnName) {
        Map map = this.getQueryParamsMapInternal(this.getRowIds(), gridName, 0, this.getPageSize(), gridName, columnName, null, null);
        map = this.normalizeMap(map);
        if (SortFilterService.debug.ON) {
            debug.out("queryParamsMapWithSort.  Grid: " + gridName + " reset page to zero \nmap:\n" + this.mapToString(map));
        }
        return map;
    }

    public Map getRowIdQueryParamsMap() {
        if (SortFilterService.debug.ON) {
            debug.out("rowIds: " + this.rowIds);
        }
        LinkedHashMap map = new LinkedHashMap();
        this.writeRowIdQueryString(map, this.rowIds);
        if (map.keySet().size() == 0) {
            System.err.println(Bundle.getString((String)"SortFilterService_missingPrimaryKey", (Object[])new Object[]{"_autoscope__rowId"}));
        }
        if (SortFilterService.debug.ON) {
            debug.out(this.mapToString(map));
        }
        return this.normalizeMap(map);
    }

    public static String getQueryParamsStringOmitFilter(String prefix, String queryStr, String gridName, String columnName, String encoding) {
        if (queryStr == null) {
            return EMPTY_STRING;
        }
        if (SortFilterService.debug.ON) {
            debug.out("queryStr: " + queryStr);
        }
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        if (queryStr.startsWith("?")) {
            queryStr = queryStr.substring(1);
        }
        String filterKey = prefix + FILTER_KEY;
        String[] query = queryStr.split(AMP);
        if (query == null) {
            query = new String[]{queryStr};
        }
        String omitRegex = columnName == null ? filterKey + "=" + gridName + "\\w*\\~.*" : filterKey + "=" + gridName + DELIM + columnName + "\\~.*";
        UnsyncStringBuffer buf = new UnsyncStringBuffer(128);
        int i = 0;
        while (i < query.length) {
            String q = null;
            try {
                q = URLDecoder.decode(query[i], encoding);
                if (!q.startsWith("_autoscope__currPage=" + gridName) && !Regex.match(q, omitRegex)) {
                    buf.append(q);
                    buf.append(AMP);
                }
            }
            catch (UnsupportedEncodingException uee) {
                System.err.println(Bundle.getString((String)"SortFilterService_encodingException", (Object[])new Object[]{q, encoding}));
                uee.printStackTrace();
            }
            ++i;
        }
        if (SortFilterService.debug.ON) {
            debug.out("queryString: " + buf.toString() + " omitRegex: " + omitRegex);
        }
        return buf.toString();
    }

    public void updateRowId(ServletRequest request) {
        if (request == null) {
            throw new IllegalStateException(Bundle.getErrorString((String)"SortFilterService_nullRequest"));
        }
        if (!(request instanceof HttpServletRequest)) {
            throw new IllegalStateException(Bundle.getErrorString((String)"SortFilterService_illegalRequestType", (Object[])new Object[]{request.getClass().getName()}));
        }
        this.rowIds = this.populateRowIds(request.getParameterValues("_autoscope__rowId"));
    }

    public void reset() {
        this.resetCurrentPage(null);
        this.resetSortTerms(null);
        this.resetFilterTerms(null);
    }

    public void reset(String gridName) {
        this.resetCurrentPage(gridName);
        this.resetSortTerms(gridName);
        this.resetFilterTerms(gridName);
    }

    private void resetSortTerms(String gridName) {
        if (SortFilterService.debug.ON) {
            debug.out("old sort terms: " + (this.sortTerms != null ? EMPTY_STRING + this.sortTerms.size() : "null"));
        }
        this.sortTerms = this.resetAbstractTerms(this.sortTerms, gridName);
        if (SortFilterService.debug.ON) {
            debug.out("new sort terms: " + (this.sortTerms != null ? EMPTY_STRING + this.sortTerms.size() : "null"));
        }
    }

    private void resetFilterTerms(String gridName) {
        this.filterTerms = this.resetAbstractTerms(this.filterTerms, gridName);
    }

    private final List resetAbstractTerms(List list, String gridName) {
        if (list == null || gridName == null) {
            return null;
        }
        ArrayList<AbstractTerm> newList = null;
        if (SortFilterService.debug.ON) {
            debug.out("list.size(): " + list.size());
        }
        int i = 0;
        while (i < list.size()) {
            if (SortFilterService.debug.ON) {
                debug.out("pre list.size(): " + list.size());
            }
            AbstractTerm t = (AbstractTerm)list.get(i);
            if (SortFilterService.debug.ON) {
                debug.out("item: " + i);
                debug.out("compare t.getGridName() : " + t.getGridName() + " gridName: " + gridName);
            }
            if (!t.getGridName().equals(gridName)) {
                if (newList == null) {
                    newList = new ArrayList<AbstractTerm>();
                }
                newList.add(t);
            }
            if (SortFilterService.debug.ON) {
                debug.out("post list.size(): " + list.size());
            }
            ++i;
        }
        return newList;
    }

    public void resetCurrentPage(String gridName) {
        if (this.currentPages != null) {
            if (gridName == null) {
                this.currentPages.clear();
            } else {
                this.currentPages.remove(gridName);
            }
        }
    }

    public int getCurrentPage(String gridName) {
        if (SortFilterService.debug.ON) {
            debug.out("gridName: " + gridName + " contains key: " + (this.currentPages == null ? "empty" : EMPTY_STRING + this.currentPages.containsKey(gridName)));
        }
        if (this.currentPages != null && this.currentPages.containsKey(gridName)) {
            return (Integer)this.currentPages.get(gridName);
        }
        return 0;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isSorted(String gridName, String columnName) {
        SortTerm term;
        if (SortFilterService.debug.ON) {
            debug.out("sort count: " + (this.sortTerms != null ? EMPTY_STRING + this.sortTerms.size() : "null"));
            debug.out("gridName: " + gridName + " columnName: " + columnName);
        }
        return (term = this.getSortTerm(gridName)) != null ? term.isSorted(columnName) : false;
    }

    public int getSortDirection(String gridName, String columnName) {
        SortTerm term = this.getSortTerm(gridName);
        return term != null ? term.getSortDirection(columnName) : 0;
    }

    public boolean isFiltered(String gridName, String columnName) {
        FilterTerm term;
        if (SortFilterService.debug.ON) {
            debug.out("filter count: " + (this.filterTerms != null ? EMPTY_STRING + this.filterTerms.size() : "null"));
            debug.out("gridName: " + gridName + " columnName: " + columnName);
        }
        return (term = this.getFilterTerm(gridName, columnName)) != null;
    }

    public static String encodeUniqueIdentifier(String gridName, String columnName, Object columnValue) {
        UnsyncStringBuffer buf = new UnsyncStringBuffer(64);
        buf.append(gridName);
        buf.append(DELIM);
        buf.append(columnName);
        buf.append(DELIM);
        buf.append(columnValue);
        return buf.toString();
    }

    public static String decodeUniqueIdentifier(HttpServletRequest request, String gridName, String columnName) {
        String[] values = request.getParameterValues("_autoscope__rowId");
        String key = (gridName + DELIM + columnName + DELIM).toLowerCase();
        if (values == null) {
            return null;
        }
        int i = 0;
        while (i < values.length) {
            if (values[i].toLowerCase().startsWith(key)) {
                return values[i].substring(key.length());
            }
            ++i;
        }
        return null;
    }

    public void addRowIdentifier(String gridName, String columnName, Object value) {
        String encoded = SortFilterService.encodeUniqueIdentifier(gridName, columnName, value);
        if (this.rowIds == null) {
            this.rowIds = new ArrayList();
        }
        this.rowIds.add(encoded);
    }

    public String toString() {
        UnsyncStringBuffer buf = new UnsyncStringBuffer(512);
        buf.append("\n");
        buf.append("currPage: " + this.getCurrentPage(null) + "\n");
        if (this.currentPages != null) {
            Iterator iterator = this.currentPages.keySet().iterator();
            while (iterator.hasNext()) {
                String gridName = (String)iterator.next();
                buf.append("page info grid: \"" + gridName + " current page: \"" + this.currentPages.get(gridName));
            }
        } else {
            buf.append("no current pages\n");
        }
        if (this.rowIds != null) {
            int i = 0;
            while (i < this.rowIds.size()) {
                buf.append("rowIds[" + i + "]: " + this.rowIds.get(i).toString() + "\n");
                ++i;
            }
        } else {
            buf.append("no rowIds\n");
        }
        if (this.sortTerms != null) {
            int i = 0;
            while (i < this.sortTerms.size()) {
                buf.append("sort[" + i + "]: " + this.sortTerms.get(i).toString() + "\n");
                ++i;
            }
        } else {
            buf.append("no sorts\n");
        }
        if (this.filterTerms != null) {
            int i = 0;
            while (i < this.filterTerms.size()) {
                buf.append("filter[" + i + "]: " + this.filterTerms.get(i).toString() + "\n");
                ++i;
            }
        } else {
            buf.append("no filters\n");
        }
        return buf.toString();
    }

    private SortFilterService(HttpServletRequest request) {
        String currentQuery = request.getQueryString();
        if (currentQuery != null) {
            if (SortFilterService.debug.ON) {
                debug.out("queryParamMap: " + this.paramsToString(request));
            }
            this.populate(request);
        }
    }

    private List getRowIds() {
        return this.rowIds;
    }

    private void setCurrentPage(String gridName, int currentPage) {
        if (this.currentPages == null) {
            this.currentPages = new HashMap();
        }
        Integer page = currentPage >= 0 ? new Integer(currentPage) : new Integer(0);
        this.currentPages.put(gridName, page);
    }

    private void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    private Map getUnknownParams() {
        return this.unknownParams;
    }

    private void setUnknownParams(Map unknownParams) {
        this.unknownParams = unknownParams;
    }

    private Map getQueryParamsMapInternal(List rowIds, String pageGridName, int currentPage, int pageSize, String newSortGridName, String newSortColumnName, String omitFilterGridName, String omitFilterColumnName) {
        LinkedHashMap map = new LinkedHashMap();
        this.getDefaultQueryString(map);
        this.getCurrentPageQueryString(map, pageGridName, currentPage);
        this.getCurrentPageSizeQueryString(map, pageSize);
        this.getFilterQuery(map, omitFilterGridName, omitFilterColumnName);
        this.getSortQuery(map, newSortGridName, newSortColumnName);
        if (SortFilterService.debug.ON) {
            debug.out(this.mapToString(map));
        }
        return map;
    }

    private SortTerm getSortTerm(String gridName) {
        if (this.sortTerms == null || this.sortTerms.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < this.sortTerms.size()) {
            SortTerm sort = (SortTerm)this.sortTerms.get(i);
            if (sort.getGridName().equals(gridName)) {
                return sort;
            }
            ++i;
        }
        return null;
    }

    private FilterTerm getFilterTerm(String gridName, String columnName) {
        if (this.filterTerms == null || this.filterTerms.size() == 0) {
            return null;
        }
        if (SortFilterService.debug.ON) {
            debug.here();
        }
        int i = 0;
        while (i < this.filterTerms.size()) {
            FilterTerm term = (FilterTerm)this.filterTerms.get(i);
            if (SortFilterService.debug.ON) {
                debug.out("gridName: " + gridName + " columnName: " + columnName + " term.getGridName(): " + term.getGridName() + " term.getColumnName(): " + term.getColumnName());
            }
            if (term.getGridName().equals(gridName) && term.getColumnName().equalsIgnoreCase(columnName)) {
                return term;
            }
            ++i;
        }
        return null;
    }

    private List createSortTerms(String[] sortAry) {
        if (sortAry == null || sortAry.length == 0) {
            return EMPTY_LIST;
        }
        ArrayList<SortTerm> list = new ArrayList<SortTerm>();
        String[] terms = null;
        int i = 0;
        while (i < sortAry.length) {
            terms = sortAry[i].split(DELIM);
            if (terms.length == 2) {
                String[] cols = terms[1].split(",");
                if (cols.length == 1 || cols.length == 2) {
                    list.add(new SortTerm(terms[0], cols));
                } else if (cols.length != 0) {
                    throw new IllegalArgumentException(Bundle.getErrorString((String)"SortFilterService_tooManySortedColumns", (Object[])new Object[]{sortAry[i]}));
                }
            } else {
                throw new IllegalArgumentException(Bundle.getErrorString((String)"SortFilterService_invalidSortSyntax", (Object[])new Object[]{sortAry[i]}));
            }
            ++i;
        }
        return list;
    }

    private List createFilterTerms(String[] filterAry) {
        if (filterAry == null || filterAry.length == 0) {
            return EMPTY_LIST;
        }
        ArrayList<FilterTerm> list = new ArrayList<FilterTerm>();
        String[] terms = null;
        int i = 0;
        while (i < filterAry.length) {
            terms = filterAry[i].split(DELIM);
            if (terms.length != 3 || !terms[2].equals("*")) {
                if (terms.length == 4) {
                    list.add(new FilterTerm(terms[0], terms[1], terms[2], terms[3]));
                } else {
                    throw new IllegalArgumentException(Bundle.getErrorString((String)"SortFilterService_invalidFilterSyntax", (Object[])new Object[]{filterAry[i]}));
                }
            }
            ++i;
        }
        return list;
    }

    private List populateRowIds(String[] pkValues) {
        if (pkValues != null) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < pkValues.length) {
                list.add(pkValues[i]);
                ++i;
            }
            return list;
        }
        return null;
    }

    private Map createCurrentPages(String[] pageValues) {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        int i = 0;
        while (i < pageValues.length) {
            if (SortFilterService.debug.ON) {
                debug.out("page value: " + pageValues[i]);
            }
            int tilde = 0;
            tilde = pageValues[i].indexOf(DELIM);
            if (tilde > 0) {
                if (SortFilterService.debug.ON) {
                    debug.out("correct format");
                }
                String gridName = pageValues[i].substring(0, tilde);
                int pageInt = 0;
                try {
                    if (SortFilterService.debug.ON) {
                        debug.out("gridName: " + gridName + " pageInt: " + pageValues[i].substring(tilde + 1));
                    }
                    if (pageValues[i].length() > tilde + 1) {
                        pageInt = Integer.parseInt(pageValues[i].substring(tilde + 1));
                    }
                }
                catch (NumberFormatException nfe) {
                    System.err.println(Bundle.getErrorString((String)"SortFilterService_invalidCurrentPageNumber", (Object[])new Object[]{pageValues[i]}));
                }
                m.put(gridName, new Integer(pageInt));
            }
            ++i;
        }
        return m;
    }

    private void populate(HttpServletRequest request) {
        String[] sortAry = request.getParameterValues(SORT_KEY);
        this.sortTerms = this.createSortTerms(sortAry);
        String[] filterAry = request.getParameterValues(FILTER_KEY);
        this.filterTerms = this.createFilterTerms(filterAry);
        this.rowIds = this.populateRowIds(request.getParameterValues("_autoscope__rowId"));
        if (request.getParameterValues(CURRENTPAGE_KEY) != null) {
            this.currentPages = this.createCurrentPages(request.getParameterValues(CURRENTPAGE_KEY));
        }
        this.unknownParams = this.processUnknownQueryParams(request);
    }

    private Map processUnknownQueryParams(HttpServletRequest request) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (SortFilterService.debug.ON) {
                debug.out("check key: " + key);
            }
            if (knownKeyHash.containsKey(key) || key.endsWith("actionOverride") || ExpressionEvaluatorFactory.getInstance().isExpression(key)) continue;
            if (SortFilterService.debug.ON) {
                debug.out("new unknown param key=" + key + " value=" + request.getParameter(key));
            }
            map.put(key, request.getParameterValues(key));
        }
        return map;
    }

    private void getFilterQuery(Map params, String omitGridName, String omitColumnName) {
        if (this.filterTerms == null) {
            return;
        }
        ArrayList<String> fList = new ArrayList<String>();
        int i = 0;
        while (i < this.filterTerms.size()) {
            FilterTerm term = (FilterTerm)this.filterTerms.get(i);
            if (!(omitGridName != null && term.getGridName().equals(omitGridName) || omitColumnName != null && term.getColumnName().equals(omitColumnName))) {
                fList.add(term.writeURLParam());
            }
            ++i;
        }
        params.put(FILTER_KEY, fList);
    }

    private void getSortQuery(Map params, String gridName, String columnName) {
        if (SortFilterService.debug.ON) {
            debug.out("gridName: " + gridName + " columnName: " + columnName);
        }
        if (gridName == null && columnName != null) {
            throw new IllegalArgumentException(Bundle.getErrorString((String)"SortFilterService_illegalGridName", (Object[])new Object[]{gridName, columnName}));
        }
        ArrayList<String> sList = new ArrayList<String>();
        SortTerm term = null;
        if (this.sortTerms != null) {
            int i = 0;
            while (i < this.sortTerms.size()) {
                SortTerm tmp = (SortTerm)this.sortTerms.get(i);
                if (gridName != null && tmp.getGridName().equals(gridName)) {
                    term = tmp;
                } else {
                    sList.add(tmp.writeURLParam());
                }
                ++i;
            }
        }
        if (gridName != null && columnName != null) {
            term = this.sortTerms == null || term == null ? new SortTerm(gridName, new String[]{columnName}) : term.alterSort(columnName);
            sList.add(term.writeURLParam());
        }
        if (sList != null && sList.size() > 0) {
            params.put(SORT_KEY, sList);
        }
        if (SortFilterService.debug.ON) {
            debug.out(this.mapToString(params));
        }
    }

    private String getDatabaseFilter_SortString(String gridName, String pattern) {
        if (this.sortTerms == null || this.sortTerms.size() == 0) {
            return EMPTY_STRING;
        }
        UnsyncStringBuffer buf = new UnsyncStringBuffer(32);
        List list = this.sortTerms;
        int i = 0;
        while (i < list.size()) {
            SortTerm term = (SortTerm)list.get(i);
            if (term.getGridName().equals(gridName)) {
                buf.append(term.writeDatabaseFilterParam());
            }
            ++i;
        }
        if (SortFilterService.debug.ON) {
            debug.out("sort clause: " + buf.toString());
        }
        return buf.toString();
    }

    private String getDatabaseFilter_FilterString(String gridName, String pattern) {
        if (this.filterTerms == null || this.filterTerms.size() == 0) {
            return EMPTY_STRING;
        }
        UnsyncStringBuffer buf = new UnsyncStringBuffer(32);
        List list = this.filterTerms;
        int i = 0;
        while (i < list.size()) {
            FilterTerm term = (FilterTerm)list.get(i);
            if (term.getGridName().equals(gridName)) {
                buf.append(term.writeDatabaseFilterParam());
                buf.append(AMP);
            }
            ++i;
        }
        if (SortFilterService.debug.ON) {
            debug.out("filter clause: " + buf.toString());
        }
        return buf.toString();
    }

    private void getDefaultQueryString(Map map) {
        if (this.getUnknownParams() != null) {
            Iterator iterator = this.getUnknownParams().keySet().iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                map.put(o, this.getUnknownParams().get(o));
            }
        }
    }

    private void getCurrentPageSizeQueryString(Map map, int pageSize) {
        if (pageSize != 10) {
            map.put(PAGESIZE_KEY, new Integer(pageSize));
        }
    }

    private void getCurrentPageQueryString(Map map, String gridName, int page) {
        ArrayList<String> pages = new ArrayList<String>();
        boolean handledCurrent = false;
        if (SortFilterService.debug.ON) {
            debug.out("currentPageQueryString.  gridName: " + gridName + " page: " + page);
        }
        if (page > 0) {
            pages.add(gridName + DELIM + page);
        }
        if (this.currentPages != null) {
            Iterator iterator = this.currentPages.keySet().iterator();
            while (iterator.hasNext()) {
                Integer p;
                String key = (String)iterator.next();
                if (key.equals(gridName) || (p = (Integer)this.currentPages.get(key)) <= 0) continue;
                pages.add(key + DELIM + p);
            }
        }
        map.put(CURRENTPAGE_KEY, pages);
    }

    private void writeRowIdQueryString(Map map, List rowIds) {
        if (rowIds != null) {
            map.put("_autoscope__rowId", rowIds);
        }
    }

    private final Map normalizeMap(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = map.get(key);
            if (value instanceof String) continue;
            if (value instanceof List) {
                List list = (List)value;
                String[] ary = new String[list.size()];
                int i = 0;
                while (i < ary.length) {
                    ary[i] = list.get(i).toString();
                    ++i;
                }
                map.put(key, ary);
                continue;
            }
            if (value != null && value instanceof String[]) {
                map.put(key, value);
                continue;
            }
            if (value == null) continue;
            map.put(key, value.toString());
        }
        if (SortFilterService.debug.ON) {
            debug.out(this.mapToString(map));
        }
        return map;
    }

    private String mapToString(Map map) {
        UnsyncStringBuffer buf = new UnsyncStringBuffer(256);
        if (map == null) {
            buf.append("Map is null");
            return buf.toString();
        }
        buf.append("\nMap identity: " + System.identityHashCode(map) + "\n");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object val = map.get(key);
            if (val instanceof Collection || val instanceof Object[]) {
                buf.append("start aggregate type: " + val.getClass().getName() + "\n");
                Iterator col = null;
                try {
                    col = IteratorFactory.makeIterator(val);
                    if (col == null) {
                        col = IteratorFactory.EMPTY_ITERATOR;
                    }
                }
                catch (IteratorFactoryException ife) {
                    System.err.println(ife.getMessage());
                }
                while (col.hasNext()) {
                    Object iVal = col.next();
                    buf.append("key: " + key + " val: " + iVal + " type: " + iVal.getClass().getName() + "\n");
                }
                buf.append("end collection\n");
                continue;
            }
            buf.append("key: " + key + " val: " + val + " type: " + val.getClass().getName() + "\n");
        }
        return buf.toString();
    }

    private String paramsToString(HttpServletRequest request) {
        UnsyncStringBuffer buf = new UnsyncStringBuffer(256);
        if (request == null) {
            buf.append("Map is null");
            return buf.toString();
        }
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String[] val = request.getParameterValues(key);
            buf.append("start aggregate type: " + val.getClass().getName() + "\n");
            Iterator col = null;
            try {
                col = IteratorFactory.makeIterator((Object)val);
                if (col == null) {
                    col = IteratorFactory.EMPTY_ITERATOR;
                }
            }
            catch (IteratorFactoryException ife) {
                System.err.println(ife.getMessage());
            }
            while (col.hasNext()) {
                Object iVal = col.next();
                buf.append("key: " + key + " val: " + iVal + " type: " + iVal.getClass().getName() + "\n");
            }
            buf.append("end collection\n");
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        knownKeyHash = new HashMap();
        knownKeyHash.put(SORT_KEY, EMPTY_STRING);
        knownKeyHash.put(FILTER_KEY, EMPTY_STRING);
        knownKeyHash.put("_autoscope__rowId", EMPTY_STRING);
        knownKeyHash.put(CURRENTPAGE_KEY, EMPTY_STRING);
        knownKeyHash.put(PAGESIZE_KEY, EMPTY_STRING);
        knownKeyHash.put("_autoscope__rowId", EMPTY_STRING);
    }

    private static final class Regex {
        private static final Map map = new Hashtable();

        private Regex() {
        }

        private static final Pattern getPattern(String regex) {
            Pattern pattern = (Pattern)map.get(regex);
            if (pattern == null) {
                try {
                    pattern = Pattern.compile(regex);
                }
                catch (PatternSyntaxException pse) {
                    throw new IllegalArgumentException(Bundle.getErrorString((String)"SortFilterService_Regex_patternSyntaxException", (Object[])new Object[]{pse.getMessage()}));
                }
                map.put(regex, pattern);
            }
            return pattern;
        }

        public static final boolean match(String text, String regex) {
            boolean result = Regex.getPattern(regex).matcher(text).matches();
            return result;
        }

        public static final boolean contains(String text, String regex) {
            boolean result = Regex.getPattern(regex).matcher(text).find();
            return result;
        }
    }

    private static class SortTerm
    extends AbstractTerm {
        private static final String ASC = "";
        private static final String DESC = "-";
        private String[] columns;

        public SortTerm(String gridName, String[] columns) {
            super(gridName);
            if (debug.ON) {
                debug.out("new SortTerm");
                int i = 0;
                while (i < columns.length) {
                    debug.out("column[" + i + "]: " + columns[i]);
                    ++i;
                }
            }
            this.columns = columns;
        }

        public boolean isSorted(String columnName) {
            if (this.columns == null) {
                return false;
            }
            return this.columns.length >= 1 && this.columns[0] != null && this.columns[0].endsWith(columnName);
        }

        public int getSortDirection(String columnName) {
            if (debug.ON) {
                debug.out("columnName: " + columnName);
            }
            if (this.columns == null) {
                return 0;
            }
            if (this.columns.length >= 1 && this.columns[0] != null) {
                if (this.columns[0].startsWith(DESC)) {
                    return 2;
                }
                return 1;
            }
            return 0;
        }

        public SortTerm alterSort(String columnName) {
            if (debug.ON) {
                debug.here();
            }
            String canonical = this.columns[0].startsWith(DESC) ? this.columns[0].substring(1) : this.columns[0];
            Object newSort = null;
            if (canonical.equals(columnName)) {
                if (this.columns[0].startsWith(DESC)) {
                    return new SortTerm(this.getGridName(), new String[]{columnName});
                }
                return new SortTerm(this.getGridName(), new String[]{DESC + columnName});
            }
            return new SortTerm(this.getGridName(), new String[]{columnName, this.columns[0]});
        }

        public String writeURLParam() {
            UnsyncStringBuffer buf = new UnsyncStringBuffer(32);
            buf.append(this.getGridName());
            buf.append(SortFilterService.DELIM);
            int i = 0;
            while (i < this.columns.length && i < 2) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(this.columns[i]);
                ++i;
            }
            return buf.toString();
        }

        public String writeDatabaseFilterParam() {
            UnsyncStringBuffer buf = new UnsyncStringBuffer(32);
            buf.append(this.getGridName());
            buf.append(SortFilterService.BASE_SORT_KEY);
            buf.append("=");
            int i = 0;
            while (i < this.columns.length && i < 2) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(this.columns[i]);
                ++i;
            }
            return buf.toString();
        }
    }

    private static class FilterTerm
    extends AbstractTerm {
        private String op;
        private String value;
        private String columnName;

        public FilterTerm(String gridName, String columnName, String op, String value) {
            super(gridName);
            this.columnName = columnName;
            this.op = op;
            this.value = value;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getOperation() {
            return this.op;
        }

        public String getValue() {
            return this.value;
        }

        public void setOperation(String op) {
            this.op = op;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String writeURLParam() {
            UnsyncStringBuffer buf = new UnsyncStringBuffer(32);
            buf.append(this.getGridName());
            buf.append(SortFilterService.DELIM);
            buf.append(this.columnName);
            buf.append(SortFilterService.DELIM);
            buf.append(this.op);
            buf.append(SortFilterService.DELIM);
            buf.append(this.value);
            return buf.toString();
        }

        public String writeDatabaseFilterParam() {
            UnsyncStringBuffer buf = new UnsyncStringBuffer(32);
            buf.append(this.getGridName());
            buf.append(this.columnName);
            buf.append(SortFilterService.DELIM);
            buf.append(this.op);
            buf.append("=");
            buf.append(this.value);
            return buf.toString();
        }
    }

    private static abstract class AbstractTerm {
        protected static final String EQUALS = "=";
        private String gridName = null;

        public AbstractTerm(String gridName) {
            this.gridName = gridName;
        }

        public String getGridName() {
            return this.gridName;
        }

        public abstract String writeURLParam();

        public abstract String writeDatabaseFilterParam();

        public String toString() {
            return this.writeURLParam();
        }
    }
}

