/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.databinding.script.el;

import com.bea.wlw.netui.script.el.VariableResolver;
import com.bea.wlw.netui.script.el.util.ContextFactory;
import com.bea.wlw.netui.script.el.util.PageContextAttributeMap;
import com.bea.wlw.netui.script.el.util.ScriptableObject;
import com.bea.wlw.netui.tags.databinding.bundle.BundleContext;
import com.bea.wlw.netui.util.logging.Logger;
import java.util.Iterator;
import javax.servlet.jsp.PageContext;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;
import weblogic.utils.UnsyncStringBuffer;

public class BundleVariableResolver
extends ScriptableObject {
    private Logger _logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$databinding$script$el$BundleVariableResolver == null ? (class$com$bea$wlw$netui$databinding$script$el$BundleVariableResolver = BundleVariableResolver.class$("com.bea.wlw.netui.databinding.script.el.BundleVariableResolver")) : class$com$bea$wlw$netui$databinding$script$el$BundleVariableResolver));
    private VariableResolver vr = null;
    static /* synthetic */ Class class$com$bea$wlw$netui$databinding$script$el$BundleVariableResolver;

    public BundleVariableResolver(VariableResolver vr) {
        this.vr = vr;
    }

    public Object get(String name) {
        PageContext pc = (PageContext)((PageContextAttributeMap)this.vr.resolveVariable("pageContext")).unwrap();
        if (pc == null) {
            String msg = "The PageContext could not be found; can not create the bundle binding context";
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)msg);
            }
            throw new RuntimeException(msg);
        }
        BundleContext bc = null;
        Object obj = pc.getAttribute("_netui_pageContext_bundleContext");
        if (obj != null && obj instanceof BundleContext) {
            bc = (BundleContext)obj;
        } else if (obj != null) {
            String msg = "The PageContext contains an attribute under the BundleContext key of the wrong type \"" + obj.getClass().getName() + "\".";
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)msg);
            }
            throw new RuntimeException(msg);
        }
        return this._get(name, pc, bc);
    }

    private Object _get(String name, PageContext pageContext, BundleContext bundleContext) {
        MessageResources resources;
        if (bundleContext != null && bundleContext.containsBundle(name)) {
            try {
                return new ScriptableBundle(name, bundleContext.getBundle(name));
            }
            catch (Exception e) {
                String msg = "Unable to load bundle named \"" + name + "\"; Cause: " + e.getMessage() + ".  Cause: " + e;
                if (this._logger.isErrorEnabled()) {
                    this._logger.error((Object)msg, (Throwable)e);
                }
                throw new RuntimeException(msg, e);
            }
        }
        if (name.equals("default")) {
            resources = (MessageResources)pageContext.getAttribute("org.apache.struts.action.MESSAGE", 2);
            if (resources != null) {
                BundleContext.BundleNode bundleNode = BundleContext.createBundleNode(name, resources, RequestUtils.retrieveUserLocale((PageContext)pageContext, null));
                return new ScriptableBundle(name, bundleNode);
            }
        } else if (pageContext.getAttribute(name, 4) != null && (resources = (MessageResources)pageContext.getAttribute(name, 4)) != null) {
            BundleContext.BundleNode bundleNode = BundleContext.createBundleNode(name, resources, RequestUtils.retrieveUserLocale((PageContext)pageContext, null));
            return new ScriptableBundle(name, bundleNode);
        }
        String bundleList = this.createBundleList(bundleContext);
        String strutsBundleList = this.createStrutsBundleList(pageContext);
        String msg = "The bundle named \"" + name + "\" was not found in the list of registered bundles with names " + bundleList + " or implicit bundle names " + strutsBundleList + ".";
        if (this._logger.isErrorEnabled()) {
            this._logger.error((Object)msg);
        }
        throw new RuntimeException(msg);
    }

    private final String createBundleList(BundleContext bundleContext) {
        UnsyncStringBuffer nameList = new UnsyncStringBuffer(32);
        nameList.append("[");
        if (bundleContext != null) {
            Iterator iterator = bundleContext.getBundleNames();
            int i = 0;
            while (iterator.hasNext()) {
                if (i > 0) {
                    nameList.append(", ");
                }
                nameList.append(iterator.next().toString());
                ++i;
            }
        }
        nameList.append("]");
        return nameList.toString();
    }

    private final String createStrutsBundleList(PageContext pageContext) {
        MessageResourcesConfig[] mrs;
        UnsyncStringBuffer strutsNameList = new UnsyncStringBuffer(32);
        strutsNameList.append("[");
        ModuleConfig config = (ModuleConfig)pageContext.getRequest().getAttribute("org.apache.struts.action.MODULE");
        if (config != null && (mrs = config.findMessageResourcesConfigs()) != null) {
            int i = 0;
            while (i < mrs.length) {
                if (i > 0) {
                    strutsNameList.append(", ");
                }
                if (mrs[i].getKey().equals("org.apache.struts.action.MESSAGE")) {
                    strutsNameList.append("default");
                } else {
                    strutsNameList.append(mrs[i].getKey() + config.getPrefix());
                }
                ++i;
            }
        }
        strutsNameList.append("]");
        return strutsNameList.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ScriptableBundle
    extends ScriptableObject {
        private BundleContext.BundleNode bundle = null;
        private String propertiesName = null;

        ScriptableBundle(String propertiesName, BundleContext.BundleNode bundle) {
            this.bundle = bundle;
            this.propertiesName = propertiesName;
        }

        public final Object get(String name) {
            String result = this.bundle.getString(name);
            if (result == null) {
                String msg = "The bundle property name \"" + name + "\" could not be found in the properties bundle \"" + this.propertiesName + "\".";
                if (BundleVariableResolver.this._logger.isErrorEnabled()) {
                    BundleVariableResolver.this._logger.error((Object)msg);
                }
                throw new RuntimeException(msg);
            }
            return result;
        }
    }

    public static class BundleContextFactory
    extends ContextFactory {
        public ScriptableObject getInstance(VariableResolver vr) {
            return new BundleVariableResolver(vr);
        }
    }
}

