/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.databinding.jsp;

import com.bea.wlw.netui.tags.databinding.SortFilterService;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.debug.Debug;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.utils.UnsyncStringBuffer;

public final class FilterWindowService {
    private static final Debug debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$databinding$jsp$FilterWindowService == null ? (class$com$bea$wlw$netui$databinding$jsp$FilterWindowService = FilterWindowService.class$("com.bea.wlw.netui.databinding.jsp.FilterWindowService")) : class$com$bea$wlw$netui$databinding$jsp$FilterWindowService));
    private static final String FILTER_KEY = "_autoscope__filter";
    private static String[][] options = null;
    static /* synthetic */ Class class$com$bea$wlw$netui$databinding$jsp$FilterWindowService;

    public static FilterWindowData getFilterWindowData(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null) {
            throw new IllegalStateException(Bundle.getErrorString((String)"FilterWindowService_nullRequestOrResponse"));
        }
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new IllegalStateException(Bundle.getErrorString((String)"FilterWindowService_illegalRequestOrResponseType", (Object[])new Object[]{request.getClass().getName(), response.getClass().getName()}));
        }
        return new FilterWindowData(request, response);
    }

    public static String[][] getOptions() {
        return options;
    }

    public static boolean isBooleanType(int columnType) {
        if (FilterWindowService.debug.ON) {
            debug.out("columnType: " + columnType + " BIT: " + -7 + " BOOLEAN: " + 16);
        }
        return columnType == 16 || columnType == -7;
    }

    public static boolean isDateType(int columnType) {
        return columnType == 91 || columnType == 93 || columnType == 92;
    }

    public static boolean isStringType(int columnType) {
        return columnType == 12 || columnType == 1 || columnType == -1;
    }

    private static int lookupFilterOp(String opStr) {
        if (opStr == null) {
            return -1;
        }
        int i = 0;
        while (i < options.length) {
            if (opStr.equals(options[i][1])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int getDefaultSelection(int columnType) {
        return FilterWindowService.isStringType(columnType) ? 8 : 1;
    }

    private static Filter[] findCurrentQueries(String prefix, String queryStr, String gridName, String columnName, String encoding) {
        String filterKey = prefix + FILTER_KEY;
        String columnKey = filterKey + "=" + (gridName != null ? gridName : "") + "~" + columnName;
        Filter[] currFilters = new Filter[2];
        String[] query = FilterWindowService.splitSearchString(queryStr);
        Object filterOp = null;
        if (FilterWindowService.debug.ON) {
            debug.out("columnKey: " + columnKey);
        }
        int which = 0;
        int equals = -1;
        int i = 0;
        while (i < query.length) {
            if (which == 2) {
                return currFilters;
            }
            String val = null;
            try {
                String q = URLDecoder.decode(query[i], encoding);
                if (FilterWindowService.debug.ON) {
                    debug.out("query[" + i + "]: " + q);
                }
                if (q.startsWith(columnKey) && q.indexOf("~") > -1) {
                    int op = -1;
                    String[] parts = q.split("~", 4);
                    if (parts.length < 3) {
                        System.err.println(Bundle.getErrorString((String)"FilterWindowService_illegalFilter", (Object[])new Object[]{q}));
                        return currFilters;
                    }
                    op = FilterWindowService.lookupFilterOp("~" + parts[2]);
                    val = parts.length == 4 ? parts[3] : "";
                    val = URLDecoder.decode(val, encoding);
                    if (FilterWindowService.debug.ON) {
                        debug.out("create new filter with op=" + op + " and value=" + val);
                    }
                    currFilters[which] = new Filter(op, val);
                    ++which;
                }
                val = null;
            }
            catch (UnsupportedEncodingException uee) {
                System.err.println(Bundle.getErrorString((String)"FilterWindowService_encodingException", (Object[])new Object[]{val}));
                uee.printStackTrace();
            }
            ++i;
        }
        if (FilterWindowService.debug.ON) {
            if (currFilters != null && currFilters.length == 1) {
                debug.out("filter 1: " + currFilters[0]);
            }
            if (currFilters != null && currFilters.length == 2) {
                debug.out("filter 1: " + currFilters[1]);
            }
        }
        return currFilters;
    }

    private static String[] splitSearchString(String search) {
        String[] query;
        if (search == null) {
            return new String[0];
        }
        if (search.startsWith("?")) {
            search = search.substring(1);
        }
        if ((query = search.split("&")) == null) {
            query = new String[]{search};
        }
        return query;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        options = new String[][]{{Bundle.getString((String)"FilterWindow_noFilter").trim(), "*"}, {Bundle.getString((String)"FilterWindow_equals").trim(), "~eq"}, {Bundle.getString((String)"FilterWindow_doesNotEqual").trim(), "~ne"}, {Bundle.getString((String)"FilterWindow_isGreaterThan").trim(), "~gt"}, {Bundle.getString((String)"FilterWindow_isLessThan").trim(), "~lt"}, {Bundle.getString((String)"FilterWindow_isGreaterThanOrEqualTo").trim(), "~ge"}, {Bundle.getString((String)"FilterWindow_isLessThanOrEqualTo").trim(), "~le"}, {Bundle.getString((String)"FilterWindow_isOneOf").trim(), "~in"}, {Bundle.getString((String)"FilterWindow_startsWith").trim(), "~startswith"}, {Bundle.getString((String)"FilterWindow_contains").trim(), "~contains"}, {Bundle.getString((String)"FilterWindow_isEmpty").trim(), "~isempty"}, {Bundle.getString((String)"FilterWindow_isNotEmpty").trim(), "~isnotempty"}};
    }

    public static class Filter {
        private int operation = -1;
        private String value = null;

        private Filter(int operation, String value) {
            this.operation = operation;
            this.value = value;
        }

        public int getOperation() {
            return this.operation;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            UnsyncStringBuffer buf = new UnsyncStringBuffer();
            buf.append("operation: " + this.operation + "\n");
            buf.append("value: " + this.value + "\n");
            return buf.toString();
        }
    }

    public static final class FilterWindowData {
        private static final String SEARCH_KEY = "_search";
        private static final String ACTION_KEY = "_filterAction";
        private static final String COLUMN_KEY = "_column";
        private static final String JDBC_TYPE_KEY = "_jdbcColumnType";
        private static final String GRID_KEY = "_grid";
        private static final String PREFIX_KEY = "_prefix";
        private HttpServletRequest request = null;
        private String currentSearch = null;
        private String filterAction = null;
        private String currentColumn = null;
        private String columnTypeStr = null;
        private int columnType = -1;
        private String currentGridName = null;
        private String columnKey = null;
        private Filter[] filters = null;
        private String clearAllFilters = null;
        private String clearColumnFilters = null;
        private int defaultFilterOperation = -1;
        private String prefix = null;
        private String encoding = null;

        private FilterWindowData(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.encoding = response.getCharacterEncoding();
            this.initialize();
        }

        private void initialize() {
            if (debug.ON) {
                debug.out("query string: " + this.request.getQueryString());
            }
            this.currentSearch = this.request.getParameter(SEARCH_KEY);
            try {
                this.currentSearch = URLDecoder.decode(this.currentSearch, this.encoding);
            }
            catch (UnsupportedEncodingException uee) {
                System.err.println(Bundle.getErrorString((String)"FilterWindowService_encodingException", (Object[])new Object[]{this.currentSearch, this.encoding}));
                uee.printStackTrace();
            }
            this.filterAction = this.request.getParameter(ACTION_KEY);
            this.currentColumn = this.request.getParameter(COLUMN_KEY);
            this.columnTypeStr = this.request.getParameter(JDBC_TYPE_KEY);
            this.prefix = this.request.getParameter(PREFIX_KEY);
            this.prefix = this.prefix != null ? this.prefix : "";
            this.columnType = this.columnTypeStr != null && !this.columnTypeStr.trim().equals("undefined") ? Integer.parseInt(this.columnTypeStr) : -1;
            this.currentGridName = this.request.getParameter(GRID_KEY) != null ? this.request.getParameter(GRID_KEY) : "";
            this.filters = FilterWindowService.findCurrentQueries(this.prefix, this.currentSearch, this.currentGridName, this.currentColumn, this.encoding);
            SortFilterService svc = SortFilterService.getInstance(this.request);
            this.clearAllFilters = SortFilterService.getQueryParamsStringOmitFilter(this.prefix, this.currentSearch, this.currentGridName, null, this.encoding);
            this.clearColumnFilters = SortFilterService.getQueryParamsStringOmitFilter(this.prefix, this.currentSearch, this.currentGridName, this.currentColumn, this.encoding);
            this.defaultFilterOperation = FilterWindowService.getDefaultSelection(this.columnType);
            if (debug.ON) {
                debug.out("FilterWindowService (" + this.request.getQueryString() + "):\n" + this.toString());
            }
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getFilterKey() {
            return this.prefix + FilterWindowService.FILTER_KEY;
        }

        public String getColumnName() {
            return this.currentColumn;
        }

        public String getClearAllFiltersQueryString() {
            return this.clearAllFilters;
        }

        public String getClearColumnFiltersQueryString() {
            return this.clearColumnFilters;
        }

        public String getFilterAction() {
            return this.filterAction;
        }

        public String getGridName() {
            return this.currentGridName;
        }

        public Filter[] getFilters() {
            return this.filters;
        }

        public int getJDBCColumnType() {
            return this.columnType;
        }

        public int getDefaultFilterOperation() {
            return this.defaultFilterOperation;
        }

        public String toString() {
            UnsyncStringBuffer buf = new UnsyncStringBuffer(256);
            buf.append("original request:\n");
            buf.append("currentSearch: " + this.currentSearch + "\n");
            buf.append("filterAction: " + this.filterAction + "\n");
            buf.append("currentColumn: " + this.currentColumn + "\n");
            buf.append("columnTypeStr: " + this.columnTypeStr + "\n");
            buf.append("computed parameters: \n");
            buf.append("columnName: " + this.getColumnName() + "\n");
            buf.append("clearAll: " + this.getClearAllFiltersQueryString() + "\n");
            buf.append("clearColumn: " + this.getClearColumnFiltersQueryString() + "\n");
            buf.append("filterAction: " + this.getFilterAction() + "\n");
            buf.append("gridName: " + this.getGridName() + "\n");
            buf.append("jdbcColumnType: " + this.getJDBCColumnType() + "\n");
            buf.append("defaultFilterOp: " + this.getDefaultFilterOperation() + "\n");
            buf.append("prefix: " + this.prefix + "\n");
            buf.append("filter 1: " + (this.filters != null && this.filters.length >= 1 && this.filters[0] != null ? this.filters[0].toString() : "null") + "\n");
            buf.append("filter 2: " + (this.filters != null && this.filters.length >= 2 && this.filters[1] != null ? this.filters[1].toString() : "null") + "\n");
            return buf.toString();
        }
    }
}

