/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom3.DOMConfiguration;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xml.serialize.XML11Serializer;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMWriter;
import org.w3c.dom.ls.DOMWriterFilter;

public class DOMWriterImpl
implements DOMWriter,
DOMConfiguration {
    private String fEncoding;
    private XMLSerializer serializer = new XMLSerializer();
    private XML11Serializer xml11Serializer;

    public DOMWriterImpl() {
        this.initSerializer(this.serializer);
    }

    public DOMConfiguration getConfig() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setParameter(String name, Object value) throws DOMException {
        if (this.serializer.fFeatures.containsKey(name)) {
            if (!(value instanceof Boolean)) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            if (!this.canSetParameter(name, value)) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            this.serializer.fFeatures.put(name, value);
            if (name.equals("xml-declaration")) {
                this.serializer._format.setOmitXMLDeclaration((Boolean)value == false);
                return;
            }
            if (!name.equals("namespaces")) return;
            this.serializer.fNamespaces = value == Boolean.TRUE;
            return;
        }
        if (name.equals("error-handler")) {
            if (value instanceof DOMErrorHandler) {
                this.serializer.fDOMErrorHandler = (DOMErrorHandler)value;
                return;
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (!(name.equals("entity-resolver") || name.equals("schema-location") || name.equals("schema-type"))) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
            throw new DOMException(8, msg);
        }
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
        throw new DOMException(9, msg);
    }

    public boolean canSetParameter(String name, Object state) {
        if (name.equals("normalize-characters") && state == Boolean.TRUE) {
            return false;
        }
        if (name.equals("validate") && state == Boolean.TRUE) {
            return false;
        }
        if (name.equals("whitespace-in-element-content") && state == Boolean.FALSE) {
            return false;
        }
        if (name.equals("canonical-form") && state == Boolean.TRUE) {
            return false;
        }
        if (name.equals("format-pretty-print") && state == Boolean.TRUE) {
            return false;
        }
        return this.serializer.fFeatures.get(name) != null || name.equals("error-handler");
    }

    public Object getParameter(String name) throws DOMException {
        Object state = this.serializer.fFeatures.get(name);
        if (state == null) {
            if (name.equals("error-handler")) {
                return this.serializer.fDOMErrorHandler;
            }
            if (name.equals("entity-resolver") || name.equals("schema-location") || name.equals("schema-type")) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
            throw new DOMException(8, msg);
        }
        return (Boolean)state;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String encoding) {
        this.serializer._format.setEncoding(encoding);
        this.fEncoding = this.serializer._format.getEncoding();
    }

    public DOMErrorHandler getErrorHandler() {
        return this.serializer.fDOMErrorHandler;
    }

    public void setErrorHandler(DOMErrorHandler errorHandler) {
        this.serializer.fDOMErrorHandler = errorHandler;
    }

    public boolean writeNode(OutputStream destination, Node wnode) {
        block12: {
            Document doc = wnode instanceof Document ? (Document)wnode : wnode.getOwnerDocument();
            Method getVersion = null;
            XMLSerializer ser = null;
            String ver = null;
            try {
                getVersion = doc.getClass().getMethod("getVersion", new Class[0]);
                if (getVersion != null) {
                    ver = (String)getVersion.invoke((Object)doc, null);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ver != null && ver.equals("1.1")) {
                if (this.xml11Serializer == null) {
                    this.xml11Serializer = new XML11Serializer();
                    this.initSerializer(this.xml11Serializer);
                }
                this.copySettings(this.serializer, this.xml11Serializer);
                ser = this.xml11Serializer;
            } else {
                ser = this.serializer;
            }
            this.checkAllFeatures(ser);
            try {
                this.reset(ser);
                ser.setOutputByteStream(destination);
                if (wnode == null) {
                    return false;
                }
                if (wnode.getNodeType() == 9) {
                    ser.serialize((Document)wnode);
                    break block12;
                }
                if (wnode.getNodeType() == 11) {
                    ser.serialize((DocumentFragment)wnode);
                    break block12;
                }
                if (wnode.getNodeType() == 1) {
                    ser.serialize((Element)wnode);
                    break block12;
                }
                return false;
            }
            catch (Exception e) {
                if (ser.fDOMErrorHandler == null) break block12;
                DOMErrorImpl error = new DOMErrorImpl();
                error.fException = e;
                error.fMessage = e.getMessage();
                error.fSeverity = 1;
                ser.fDOMErrorHandler.handleError(error);
            }
        }
        return true;
    }

    public String writeToString(Node wnode) throws DOMException {
        StringWriter destination;
        block12: {
            Document doc = wnode instanceof Document ? (Document)wnode : wnode.getOwnerDocument();
            Method getVersion = null;
            XMLSerializer ser = null;
            String ver = null;
            try {
                getVersion = doc.getClass().getMethod("getVersion", new Class[0]);
                if (getVersion != null) {
                    ver = (String)getVersion.invoke((Object)doc, null);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ver != null && ver.equals("1.1")) {
                if (this.xml11Serializer == null) {
                    this.xml11Serializer = new XML11Serializer();
                    this.initSerializer(this.xml11Serializer);
                }
                this.copySettings(this.serializer, this.xml11Serializer);
                ser = this.xml11Serializer;
            } else {
                ser = this.serializer;
            }
            this.checkAllFeatures(ser);
            destination = new StringWriter();
            try {
                this.reset(ser);
                ser.setOutputCharStream(destination);
                if (wnode == null) {
                    return null;
                }
                if (wnode.getNodeType() == 9) {
                    ser.serialize((Document)wnode);
                    break block12;
                }
                if (wnode.getNodeType() == 11) {
                    ser.serialize((DocumentFragment)wnode);
                    break block12;
                }
                if (wnode.getNodeType() == 1) {
                    ser.serialize((Element)wnode);
                    break block12;
                }
                return null;
            }
            catch (IOException ioe) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "STRING_TOO_LONG", new Object[]{ioe.getMessage()});
                throw new DOMException(2, msg);
            }
        }
        return destination.toString();
    }

    public void setNewLine(String newLine) {
        this.serializer._format.setLineSeparator(newLine);
    }

    public String getNewLine() {
        return this.serializer._format.getLineSeparator();
    }

    public DOMWriterFilter getFilter() {
        return null;
    }

    public void setFilter(DOMWriterFilter filter) {
        this.serializer.fDOMFilter = filter;
    }

    private void reset(XMLSerializer ser) {
        ser.reset();
        ser.fNSBinder.reset();
        ser.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        ser.fNamespaceCounter = 1;
    }

    private void checkAllFeatures(XMLSerializer ser) {
        if (this.getParameter("whitespace-in-element-content") == Boolean.TRUE) {
            ser._format.setPreserveSpace(true);
        } else {
            ser._format.setPreserveSpace(false);
        }
    }

    private void initSerializer(XMLSerializer ser) {
        ser.fNamespaces = true;
        ser.fNSBinder = new NamespaceSupport();
        ser.fLocalNSBinder = new NamespaceSupport();
        ser.fSymbolTable = new SymbolTable();
        ser.fFeatures = new Hashtable();
        ser.fFeatures.put("namespaces", Boolean.TRUE);
        ser.fFeatures.put("normalize-characters", Boolean.FALSE);
        ser.fFeatures.put("split-cdata-sections", Boolean.TRUE);
        ser.fFeatures.put("validate", Boolean.FALSE);
        ser.fFeatures.put("entities", Boolean.FALSE);
        ser.fFeatures.put("whitespace-in-element-content", Boolean.TRUE);
        ser.fFeatures.put("discard-default-content", Boolean.TRUE);
        ser.fFeatures.put("canonical-form", Boolean.FALSE);
        ser.fFeatures.put("format-pretty-print", Boolean.FALSE);
        ser.fFeatures.put("xml-declaration", Boolean.TRUE);
        ser.fFeatures.put("unknown-characters", Boolean.TRUE);
    }

    private void copySettings(XMLSerializer src, XMLSerializer dest) {
        dest._format.setOmitXMLDeclaration(src._format.getOmitXMLDeclaration());
        dest.fNamespaces = src.fNamespaces;
        dest.fDOMErrorHandler = src.fDOMErrorHandler;
        dest._format.setEncoding(src._format.getEncoding());
        dest._format.setLineSeparator(src._format.getLineSeparator());
        dest.fDOMFilter = src.fDOMFilter;
        Enumeration keys = src.fFeatures.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object val = src.fFeatures.get(key);
            dest.fFeatures.put(key, val);
        }
    }
}

