/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractParticleTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDGroupTraverser
extends XSDAbstractParticleTraverser {
    XSDGroupTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    XSParticleDecl traverseLocal(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, false, schemaDoc);
        QName refAttr = (QName)attrValues[XSAttributeChecker.ATTIDX_REF];
        XInt minAttr = (XInt)attrValues[XSAttributeChecker.ATTIDX_MINOCCURS];
        XInt maxAttr = (XInt)attrValues[XSAttributeChecker.ATTIDX_MAXOCCURS];
        XSGroupDecl group = null;
        if (refAttr == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{"group (local)", "ref"}, elmNode);
        } else {
            group = (XSGroupDecl)this.fSchemaHandler.getGlobalDecl(schemaDoc, 4, refAttr, elmNode);
        }
        Element child = DOMUtil.getFirstChildElement(elmNode);
        if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
            child = DOMUtil.getNextSiblingElement(child);
        }
        if (child != null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{"group (local)", "(annotation?)"}, elmNode);
        }
        int minOccurs = minAttr.intValue();
        int maxOccurs = maxAttr.intValue();
        XSParticleDecl particle = null;
        if (group != null && group.fModelGroup != null && (minOccurs != 0 || maxOccurs != 0)) {
            particle = this.fSchemaHandler.fDeclPool != null ? this.fSchemaHandler.fDeclPool.getParticleDecl() : new XSParticleDecl();
            particle.fType = (short)3;
            particle.fValue = group.fModelGroup;
            particle.fMinOccurs = minOccurs;
            particle.fMaxOccurs = maxOccurs;
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return particle;
    }

    XSGroupDecl traverseGlobal(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object redefinedGrp;
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, true, schemaDoc);
        String strNameAttr = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        if (strNameAttr == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{"group (global)", "name"}, elmNode);
        }
        XSGroupDecl group = null;
        XSParticleDecl particle = null;
        Element l_elmChild = DOMUtil.getFirstChildElement(elmNode);
        if (l_elmChild == null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{"group (global)", "(annotation?, (all | choice | sequence))"}, elmNode);
        } else {
            String childName = l_elmChild.getLocalName();
            if (childName.equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(l_elmChild, attrValues, true, schemaDoc);
                l_elmChild = DOMUtil.getNextSiblingElement(l_elmChild);
                if (l_elmChild != null) {
                    childName = l_elmChild.getLocalName();
                }
            }
            if (l_elmChild == null) {
                this.reportSchemaError("s4s-elt-must-match", new Object[]{"group (global)", "(annotation?, (all | choice | sequence))"}, elmNode);
            } else if (childName.equals(SchemaSymbols.ELT_ALL)) {
                particle = this.traverseAll(l_elmChild, schemaDoc, grammar, 4, null);
            } else if (childName.equals(SchemaSymbols.ELT_CHOICE)) {
                particle = this.traverseChoice(l_elmChild, schemaDoc, grammar, 4, null);
            } else if (childName.equals(SchemaSymbols.ELT_SEQUENCE)) {
                particle = this.traverseSequence(l_elmChild, schemaDoc, grammar, 4, null);
            } else {
                this.reportSchemaError("s4s-elt-must-match", new Object[]{"group (global)", "(annotation?, (all | choice | sequence))"}, l_elmChild);
            }
            if (l_elmChild != null && DOMUtil.getNextSiblingElement(l_elmChild) != null) {
                this.reportSchemaError("s4s-elt-must-match", new Object[]{"group (global)", "(annotation?, (all | choice | sequence))"}, DOMUtil.getNextSiblingElement(l_elmChild));
            }
            if (strNameAttr != null) {
                group = new XSGroupDecl();
                group.fName = strNameAttr;
                group.fTargetNamespace = schemaDoc.fTargetNamespace;
                if (particle != null) {
                    group.fModelGroup = (XSModelGroupImpl)particle.fValue;
                }
                grammar.addGlobalGroupDecl(group);
            }
        }
        if (group != null && (redefinedGrp = this.fSchemaHandler.getGrpOrAttrGrpRedefinedByRestriction(4, new QName(XMLSymbols.EMPTY_STRING, strNameAttr, strNameAttr, schemaDoc.fTargetNamespace), schemaDoc, elmNode)) != null) {
            grammar.addRedefinedGroupDecl(group, (XSGroupDecl)redefinedGrp, this.fSchemaHandler.element2Locator(elmNode));
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return group;
    }
}

