/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.pageflow.internal;

import com.bea.compiler.IDiagnostic;
import com.bea.compiler.IDiagnosticSet;
import com.bea.wlw.netui.pageflow.PageFlowUtils;
import com.bea.wlw.netui.pageflow.ServerAdapter;
import com.bea.wlw.netui.pageflow.scoping.ScopedServletContext;
import com.bea.wlw.netui.pageflow.scoping.ScopedServletUtils;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.cache.ConcurrentReaderHashMap;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.logging.Logger;
import com.bea.wlw.runtime.core.bean.WLSUtil;
import com.bea.wlw.runtime.core.compiler.ProjectCompiler;
import com.bea.wlw.runtime.core.dispatcher.AppManager;
import com.bea.wlw.runtime.core.dispatcher.LoadContext;
import com.bea.wlw.runtime.core.dispatcher.WlwProxySupport;
import com.bea.wlw.runtime.core.metadata.AnnotatedClassV2;
import com.bea.wlw.runtime.core.metadata.Annotation;
import com.bea.wlw.runtime.core.metadata.AnnotationMap;
import com.bea.wlw.runtime.core.util.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OptionalDataException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.upload.MultipartRequestWrapper;
import weblogic.jws.WlwProxy;
import weblogic.jws.WlwProxyException;
import weblogic.management.Admin;
import weblogic.management.configuration.WebAppComponentMBean;
import weblogic.management.descriptors.webapp.SecurityConstraintMBean;
import weblogic.management.descriptors.webapp.UserDataConstraintMBean;
import weblogic.management.descriptors.webapp.WebAppDescriptorMBean;
import weblogic.management.descriptors.webapp.WebResourceCollectionMBean;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.security.ServletAuthentication;

public class WebLogicServerAdapter
implements ServerAdapter {
    private static final String TRANSPORT_CONFIDENTIAL = "CONFIDENTIAL";
    private static final String TRANSPORT_INTEGRAL = "INTEGRAL";
    private static final String TRANSPORT_NONE = "NONE";
    private static final Integer PROTOCOL_SECURE;
    private static final Integer PROTOCOL_UNSECURE;
    private static final Integer PROTOCOL_UNSPECIFIED;
    private static final String URI_SECURITY_CACHE_HASH;
    private static final String URI_SECURITY_CACHE;
    private static final String ALREADY_PRINTED_WARNINGS_ATTR;
    private static final String WAC_MBEAN_NAME = "weblogic.servlet.WebAppComponentMBean";
    private static final String CONTROL_TAG_PREFIX = "jc:";
    private static final String CONTROL_FIELD_ANNOTATION = "common:control";
    private static final Debug debug;
    private static final Logger logger;
    private static final AppManager.RedeployCallback REDEPLOY_CALLBACK;
    private static ConcurrentReaderHashMap _controlFieldCache;
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$PageFlowUtils;
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$internal$WebLogicServerAdapter;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$weblogic$servlet$internal$WebAppServletContext;

    public final boolean isInProductionMode(HttpServletRequest request) {
        return Admin.getInstance().getActiveDomain().isProductionModeEnabled();
    }

    private final boolean isInEar(File file) {
        return file.getPath().indexOf(".wlnotdelete") != -1;
    }

    public Boolean isSecureResource(String uri, ServletContext servletContext, HttpServletRequest request) {
        String transportGuarantee;
        UserDataConstraintMBean udc;
        Integer cachedResult;
        if (PageFlowUtils.isAbsoluteURI((String)uri)) {
            return null;
        }
        int query = uri.indexOf(63);
        if (query != -1) {
            uri = uri.substring(0, query);
        }
        uri = ScopedServletUtils.normalizeURI((String)uri);
        Long cachedHash = (Long)servletContext.getAttribute(URI_SECURITY_CACHE_HASH);
        Map<String, Integer> cache = (Map<String, Integer>)servletContext.getAttribute(URI_SECURITY_CACHE);
        if (cachedHash == null || cachedHash != (long)servletContext.hashCode()) {
            if (debug.isOn()) {
                debug.out("Creating cache for URI transport-guarantees.");
            }
            cache = Collections.synchronizedMap(new HashMap());
            servletContext.setAttribute(URI_SECURITY_CACHE_HASH, (Object)new Long(servletContext.hashCode()));
            servletContext.setAttribute(URI_SECURITY_CACHE, cache);
        }
        if ((cachedResult = (Integer)cache.get(uri)) != null) {
            Boolean val;
            if (cachedResult.equals(PROTOCOL_SECURE)) {
                val = Boolean.TRUE;
            } else if (cachedResult.equals(PROTOCOL_UNSECURE)) {
                val = Boolean.FALSE;
            } else {
                if (!$assertionsDisabled && !cachedResult.equals(PROTOCOL_UNSPECIFIED)) {
                    throw new AssertionError(cachedResult);
                }
                val = null;
            }
            if (debug.isOn()) {
                debug.out("Found cached security-value of " + val + " for URI " + uri);
            }
            return val;
        }
        String fileExtension = PageFlowUtils.getFileExtension((String)uri);
        WebAppServletContext wlContext = null;
        if (servletContext instanceof WebAppServletContext) {
            wlContext = (WebAppServletContext)servletContext;
        } else if (servletContext instanceof ScopedServletContext) {
            wlContext = (WebAppServletContext)((ScopedServletContext)servletContext).getRealContext();
        }
        WebAppDescriptorMBean wad = wlContext.getWebAppDescriptor();
        SecurityConstraintMBean[] securityConstraints = wad.getSecurityConstraints();
        SecurityConstraintMBean matchingConstraint = null;
        int matchingPathLen = -1;
        boolean foundExact = false;
        int i = 0;
        while (i < securityConstraints.length && !foundExact) {
            SecurityConstraintMBean securityConstraint = securityConstraints[i];
            WebResourceCollectionMBean[] wrcs = securityConstraint.getWebResourceCollection();
            int j = 0;
            while (j < wrcs.length && !foundExact) {
                String[] urlPatterns = wrcs[j].getUrlPatterns();
                int k = 0;
                while (k < urlPatterns.length) {
                    String pattern = urlPatterns[k];
                    if (pattern.length() > matchingPathLen && pattern.endsWith("/*")) {
                        if (uri.startsWith(pattern.substring(0, pattern.length() - 1))) {
                            matchingConstraint = securityConstraint;
                            matchingPathLen = pattern.length();
                        }
                    } else if (matchingConstraint == null && pattern.equals("*." + fileExtension)) {
                        matchingConstraint = securityConstraint;
                    } else if (pattern.equals(uri)) {
                        matchingConstraint = securityConstraint;
                        foundExact = true;
                        break;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (matchingConstraint != null && (udc = matchingConstraint.getUserDataConstraint()) != null && (transportGuarantee = udc.getTransportGuarantee()) != null) {
            if (debug.isOn()) {
                debug.out("Found transport-guarantee of " + transportGuarantee + " for URI " + uri);
            }
            if (transportGuarantee.equalsIgnoreCase(TRANSPORT_CONFIDENTIAL) || transportGuarantee.equalsIgnoreCase(TRANSPORT_INTEGRAL)) {
                cache.put(uri, PROTOCOL_SECURE);
                return Boolean.TRUE;
            }
            if (transportGuarantee.equalsIgnoreCase(TRANSPORT_NONE)) {
                cache.put(uri, PROTOCOL_UNSECURE);
                return Boolean.FALSE;
            }
        }
        cache.put(uri, PROTOCOL_UNSPECIFIED);
        return null;
    }

    public boolean ensureAppDeployment(HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        try {
            WebAppServletContext wlContext = null;
            if (!(context instanceof WebAppServletContext)) {
                if (debug.isOn()) {
                    debug.out("ServletContext is of type " + context.getClass().getName() + " (not " + (class$weblogic$servlet$internal$WebAppServletContext == null ? (class$weblogic$servlet$internal$WebAppServletContext = WebLogicServerAdapter.class$("weblogic.servlet.internal.WebAppServletContext")) : class$weblogic$servlet$internal$WebAppServletContext).getName() + ").  Skipping ensureAppDeployment.");
                }
                return false;
            }
            wlContext = (WebAppServletContext)context;
            if (AppManager.ensureAppDeployment((HttpServletRequest)request, (HttpServletResponse)response, (WebAppServletContext)wlContext, (AppManager.RedeployCallback)REDEPLOY_CALLBACK, (AppManager.RedeployCallback)REDEPLOY_CALLBACK)) {
                if (debug.isOn()) {
                    System.err.println("A redeploy occurred.  The request has been reforwarded.");
                    System.err.println("The request was " + request.getRequestURI());
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error((Object)"Error during recompilation/redeployment", (Throwable)e);
            if (debug.isOn()) {
                debug.out("An exception occurred during ensureAppDeployment(): " + e.getMessage());
                e.printStackTrace();
            }
            logger.error((Object)"An exception occurred during ensureAppDeployment", (Throwable)e);
            return false;
        }
    }

    public ServletContext getServletContext(HttpServletRequest request) {
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
        }
        HttpServletRequest internalRequest = request;
        while (internalRequest instanceof HttpServletRequestWrapper) {
            internalRequest = ((HttpServletRequestWrapper)internalRequest).getRequest();
        }
        if (!$assertionsDisabled && !(internalRequest instanceof ServletRequestImpl)) {
            throw new AssertionError((Object)internalRequest.getClass().getName());
        }
        return ((ServletRequestImpl)internalRequest).getContext();
    }

    public boolean checkSecurity(String uri, HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        ServletResponseImpl wlsResponse;
        ServletRequestImpl wlsRequest;
        WebAppServletContext wlsContext;
        if (context instanceof WebAppServletContext) {
            wlsContext = (WebAppServletContext)context;
            while (!(request instanceof ServletRequestImpl) && request instanceof ServletRequestWrapper) {
                request = (HttpServletRequest)((ServletRequestWrapper)request).getRequest();
            }
            while (!(response instanceof ServletResponseImpl) && response instanceof ServletResponseWrapper) {
                response = (HttpServletResponse)((ServletResponseWrapper)response).getResponse();
            }
            if (!$assertionsDisabled && !(request instanceof ServletRequestImpl)) {
                throw new AssertionError((Object)request.getClass().getName());
            }
            if (!$assertionsDisabled && !(response instanceof ServletResponseImpl)) {
                throw new AssertionError((Object)response.getClass().getName());
            }
            wlsRequest = (ServletRequestImpl)request;
            wlsResponse = (ServletResponseImpl)response;
        } else if (context instanceof ScopedServletContext) {
            wlsContext = (WebAppServletContext)((ScopedServletContext)context).getRealContext();
            wlsRequest = (ServletRequestImpl)ScopedServletUtils.unwrapRequest((ServletRequest)request).getOuterRequest();
            wlsResponse = (ServletResponseImpl)ScopedServletUtils.unwrapResponse((ServletResponse)response).getOuterResponse();
        } else {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)context.getClass().getName());
            }
            return false;
        }
        return !wlsContext.webflowCheckAccess(uri, wlsRequest, wlsResponse);
    }

    public final int getListenPort(HttpServletRequest request) {
        return Admin.getInstance().getLocalServer().getListenPort();
    }

    public final int getSecureListenPort(HttpServletRequest request) {
        return Admin.getInstance().getLocalServer().getSSL().getListenPort();
    }

    public void login(String username, String password, HttpServletRequest request) throws LoginException {
        int result;
        if (debug.isOn()) {
            debug.out("User login: ", (Object)username);
        }
        if ((result = ServletAuthentication.weak((String)username, (String)password, (HttpServletRequest)request)) != 0) {
            throw new FailedLoginException(Bundle.getString((String)"PageFlow_LoginFailed", (Object)username));
        }
    }

    public void logout(boolean invalidateSessions, HttpServletRequest request) {
        if (invalidateSessions) {
            if (debug.isOn()) {
                debug.out("Logout - invalidate sessions");
            }
            ServletAuthentication.invalidateAll((HttpServletRequest)request);
        } else {
            if (debug.isOn()) {
                debug.out("Logout - leave session");
            }
            ServletAuthentication.logout((HttpServletRequest)request);
        }
    }

    public boolean printCompileErrors(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, PrintWriter writer, String overrideURI) {
        block14: {
            String filePath;
            String modulePath;
            String pfClassName;
            if (Config.iterativeDevDisabled()) {
                return false;
            }
            IDiagnosticSet diagnostics = null;
            String requestURI = overrideURI != null ? overrideURI : PageFlowUtils.getRelativeURI((HttpServletRequest)request, null);
            int lastSlash = requestURI.lastIndexOf(47);
            if (lastSlash != -1 && (pfClassName = PageFlowUtils.getPageFlowClassName((String)(modulePath = requestURI.substring(0, lastSlash)), (ServletRequest)request, (ServletContext)servletContext)) != null) {
                requestURI = PageFlowUtils.getPageFlowURI((String)pfClassName);
            }
            if ((filePath = servletContext.getRealPath(requestURI)) == null) {
                return false;
            }
            File sourceFile = new File(filePath);
            ProjectCompiler projectCompiler = WebLogicServerAdapter.getProjectCompiler(servletContext);
            if (projectCompiler == null) {
                return false;
            }
            if (sourceFile.exists() && !this.isInEar(sourceFile)) {
                diagnostics = WebLogicServerAdapter.getDiagnostics(sourceFile, projectCompiler);
            }
            if (diagnostics == null) break block14;
            if (diagnostics.getErrorCount() > 0) {
                try {
                    if (writer == null && response != null) {
                        writer = response.getWriter();
                    }
                    if (writer != null) {
                        WebLogicServerAdapter.sendCompileErrors(writer, diagnostics, sourceFile, false, servletContext, projectCompiler);
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"Could not print compile errors to the response.", (Throwable)e);
                }
                return true;
            }
            if (diagnostics.getWarningCount() > 0 || diagnostics.getInfoCount() > 0) {
                try {
                    if (servletContext.getAttribute(ALREADY_PRINTED_WARNINGS_ATTR + sourceFile) == null) {
                        servletContext.setAttribute(ALREADY_PRINTED_WARNINGS_ATTR + sourceFile, (Object)Boolean.TRUE);
                        PrintWriter errWriter = new PrintWriter(new OutputStreamWriter(System.err));
                        WebLogicServerAdapter.sendCompileErrors(errWriter, diagnostics, sourceFile, true, servletContext, projectCompiler);
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"Could not print compile errors to the response.", (Throwable)e);
                }
            }
        }
        return false;
    }

    protected static ProjectCompiler getProjectCompiler(ServletContext servletContext) {
        WebAppComponentMBean wac = WebLogicServerAdapter.getWebAppComponentMBean(servletContext);
        if (wac == null) {
            return null;
        }
        LoadContext.LoadParams lp = new LoadContext.LoadParams(wac);
        LoadContext.DeployParams dp = new LoadContext.DeployParams(wac);
        LoadContext loadContext = new LoadContext(lp.getWebAppContextPath() + "/dummy", lp, dp);
        AppManager appManager = AppManager.ensureAppManager((LoadContext)loadContext);
        String compilerKey = WLSUtil.getWACRt((WebAppComponentMBean)wac).getContextRoot();
        return appManager.getProjectCompiler(compilerKey);
    }

    protected static IDiagnosticSet getDiagnostics(File sourceFile, ProjectCompiler projectCompiler) {
        try {
            sourceFile = sourceFile.getCanonicalFile();
        }
        catch (IOException e) {
            if (debug.isOn()) {
                debug.out("Exception while getting the canonical path for " + sourceFile);
                e.printStackTrace();
            }
            return null;
        }
        return projectCompiler.getDiagnostics(sourceFile.toURI(), true);
    }

    protected static WebAppComponentMBean getWebAppComponentMBean(ServletContext servletContext) {
        WebAppComponentMBean wac = (WebAppComponentMBean)servletContext.getAttribute(WAC_MBEAN_NAME);
        if (wac == null) {
            if (servletContext instanceof ScopedServletContext) {
                servletContext = ((ScopedServletContext)servletContext).getRealContext();
                wac = (WebAppComponentMBean)servletContext.getAttribute(WAC_MBEAN_NAME);
                if (!$assertionsDisabled && wac == null) {
                    throw new AssertionError();
                }
            } else if (debug.isOn()) {
                debug.out("context attribute weblogic.servlet.WebAppComponentMBean was null");
            }
        }
        return wac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void sendCompileErrors(PrintWriter writer, IDiagnosticSet diagnostics, File sourceFile, boolean onlyWarningsToConsole, ServletContext context, ProjectCompiler projectCompiler) throws IOException {
        Object[] args = new Object[]{sourceFile};
        String console = onlyWarningsToConsole ? "Console" : "";
        writer.println(Bundle.getString((String)("PageFlow_CompileErrorHeader" + console), (Object[])args));
        String webappRootPath = projectCompiler.getWebAppDir().getPath();
        Iterator i = diagnostics.iterator();
        while (true) {
            String sourceLine;
            IDiagnostic diag;
            block18: {
                Object var20_22;
                if (!i.hasNext()) {
                    writer.println(Bundle.getString((String)("PageFlow_CompileErrorFooter" + console), null));
                    writer.flush();
                    return;
                }
                diag = (IDiagnostic)i.next();
                if (onlyWarningsToConsole && diag.getType() == 1 || diag.getType() == 4) continue;
                Reader rawInput = null;
                sourceLine = null;
                try {
                    File diagFile = new File(diag.getFile().getPath());
                    if (!$assertionsDisabled && !diagFile.getPath().startsWith(webappRootPath)) {
                        throw new AssertionError((Object)(diagFile.getPath() + ", " + webappRootPath));
                    }
                    String pathFromRoot = diagFile.getPath().substring(webappRootPath.length());
                    InputStream stream = context.getResourceAsStream(pathFromRoot = pathFromRoot.replace(File.separatorChar, '/'));
                    if (stream != null) {
                        rawInput = new InputStreamReader(stream);
                        BufferedReader reader = new BufferedReader(rawInput);
                        int j = 0;
                        int lineNum = diag.getFirstLine();
                        while (true) {
                            if (j >= lineNum) {
                                break;
                            }
                            sourceLine = reader.readLine();
                            if (sourceLine == null) break;
                            ++j;
                        }
                    }
                    var20_22 = null;
                    if (rawInput == null) break block18;
                }
                catch (Throwable throwable) {
                    var20_22 = null;
                    if (rawInput != null) {
                        rawInput.close();
                    }
                    throw throwable;
                }
                rawInput.close();
            }
            StringBuffer underline = new StringBuffer();
            if (sourceLine != null && diag.getFirstColumn() >= 0) {
                int k = 0;
                while (true) {
                    if (k >= diag.getFirstColumn() - 1) break;
                    underline.append(' ');
                    ++k;
                }
                underline.append('<');
                int k2 = diag.getFirstColumn();
                while (true) {
                    if (k2 >= diag.getLastColumn() - 1) {
                        underline.append('>');
                        break;
                    }
                    underline.append('-');
                    ++k2;
                }
            }
            String errType = "Error";
            switch (diag.getType()) {
                case 1: {
                    errType = Bundle.getString((String)"PageFlow_Error");
                    break;
                }
                case 2: {
                    errType = Bundle.getString((String)"PageFlow_Warning");
                    break;
                }
                case 3: {
                    errType = Bundle.getString((String)"PageFlow_Info");
                    break;
                }
            }
            Object[] args2 = new Object[]{new Integer(diag.getFirstLine()), new Integer(diag.getFirstColumn()), new File(diag.getFile().getPath()).getPath(), sourceLine != null ? sourceLine : "", sourceLine != null ? underline.toString() : "", diag.getDescription(), diag.getPrescription() != null ? diag.getPrescription() : "", errType};
            writer.println(Bundle.getString((String)("PageFlow_CompileErrorItem" + console), (Object[])args2));
        }
    }

    private static Map getAccessibleControlFieldAnnotations(Class controlContainerClass) {
        String className = controlContainerClass.getName();
        Map cached = (Map)_controlFieldCache.get((Object)className);
        if (cached != null) {
            return cached;
        }
        AnnotatedClass annotatedThis = null;
        try {
            annotatedThis = new AnnotatedClass(className, controlContainerClass.getClassLoader());
        }
        catch (Exception e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)(className + ": " + e.getMessage()));
            }
            logger.error((Object)("Could not parse annotations for class " + className), (Throwable)e);
            return new HashMap();
        }
        Field[] fields = controlContainerClass.getDeclaredFields();
        HashMap<Field, AnnotationMap> ret = new HashMap<Field, AnnotationMap>();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            AnnotationMap annotations = annotatedThis.getFieldAnnotationsV2(field.getName());
            if (annotations != null && annotations.getAnnotation(CONTROL_FIELD_ANNOTATION) != null) {
                if (!$assertionsDisabled && Modifier.isTransient(field.getModifiers())) {
                    throw new AssertionError((Object)field.getName());
                }
                field.setAccessible(true);
                ret.put(field, annotations);
            }
            ++i;
        }
        _controlFieldCache.put((Object)className, ret);
        return ret;
    }

    public void initBusinessControls(HttpServletRequest request, Object controlContainer) {
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
        }
        Map controlFields = WebLogicServerAdapter.getAccessibleControlFieldAnnotations(controlContainer.getClass());
        Iterator i = controlFields.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry ent = i.next();
            Field field = (Field)ent.getKey();
            AnnotationMap fieldAnnotations = (AnnotationMap)ent.getValue();
            if (!$assertionsDisabled && Modifier.isTransient(field.getModifiers())) {
                throw new AssertionError((Object)field.getName());
            }
            field.setAccessible(true);
            try {
                if (field.get(controlContainer) != null) continue;
                if (debug.isOn()) {
                    debug.out("Initializing field " + field.getName() + " (" + field.getType().getName() + ") with a business control proxy...");
                }
                WlwProxySupport proxy = (WlwProxySupport)WlwProxy.create(field.getType(), (HttpServletRequest)request);
                if (!$assertionsDisabled && proxy == null) {
                    throw new AssertionError((Object)("WlwProxy.create() returned null for " + field.getType()));
                }
                proxy.setConversationalControlSupport(true);
                field.set(controlContainer, proxy);
                Iterator j = fieldAnnotations.getAnnotations().entrySet().iterator();
                while (j.hasNext()) {
                    Map.Entry entry = j.next();
                    String tagName = (String)entry.getKey();
                    if (!tagName.startsWith(CONTROL_TAG_PREFIX)) continue;
                    tagName = '@' + tagName;
                    List tags = (List)entry.getValue();
                    int t = 0;
                    while (t < tags.size()) {
                        Annotation ann = (Annotation)tags.get(t);
                        String[] attrNames = ann.getAttributeNames();
                        HashMap<String, String> attrMap = new HashMap<String, String>();
                        int k = 0;
                        while (k < attrNames.length) {
                            String attrName = attrNames[k];
                            String attrVal = ann.getAttribute(attrName);
                            if (debug.isOn()) {
                                debug.out("Setting '" + tagName + " " + attrName + "=\"" + attrVal + "\"' on field " + field.getName());
                            }
                            attrMap.put(attrName, attrVal);
                            ++k;
                        }
                        proxy.addControlAttributes(tagName, attrMap);
                        ++t;
                    }
                }
            }
            catch (WlwProxyException e) {
                logger.error((Object)("Exception while initializing business control " + field.getName()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)("Exception while initializing business control " + field.getName()), (Throwable)e);
            }
        }
    }

    public void uninitBusinessControls(Object controlContainer) {
        Map controlFields = WebLogicServerAdapter.getAccessibleControlFieldAnnotations(controlContainer.getClass());
        Iterator i = controlFields.keySet().iterator();
        while (i.hasNext()) {
            Field controlField = (Field)i.next();
            try {
                WlwProxySupport proxy = (WlwProxySupport)controlField.get(controlContainer);
                if (proxy == null) continue;
                controlField.set(controlContainer, null);
                proxy.finishConversation();
            }
            catch (IllegalAccessException e) {
                logger.error((Object)("Exception while uninitializing business control " + controlField.getName()), (Throwable)e);
            }
        }
    }

    public boolean isIterativeDevEnabled(ServletRequest request) {
        return !Config.iterativeDevDisabled();
    }

    public String getFullContextPath(HttpServletRequest request) {
        String ret = request.getContextPath();
        if (ret.length() == 0) {
            ServletContext servletContext = this.getServletContext(request);
            if (!$assertionsDisabled && !(servletContext instanceof WebAppServletContext)) {
                throw new AssertionError((Object)servletContext.getClass().getName());
            }
            if (servletContext instanceof WebAppServletContext) {
                return ((WebAppServletContext)servletContext).getName();
            }
        }
        return ret;
    }

    public void ensureFailover(String attrName, Object attrVal, HttpServletRequest request) {
        request.getSession().setAttribute(attrName, attrVal);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$wlw$netui$pageflow$internal$WebLogicServerAdapter == null ? (class$com$bea$wlw$netui$pageflow$internal$WebLogicServerAdapter = WebLogicServerAdapter.class$("com.bea.wlw.netui.pageflow.internal.WebLogicServerAdapter")) : class$com$bea$wlw$netui$pageflow$internal$WebLogicServerAdapter).desiredAssertionStatus();
        PROTOCOL_SECURE = new Integer(2);
        PROTOCOL_UNSECURE = new Integer(1);
        PROTOCOL_UNSPECIFIED = new Integer(0);
        URI_SECURITY_CACHE_HASH = (class$com$bea$wlw$netui$pageflow$PageFlowUtils == null ? (class$com$bea$wlw$netui$pageflow$PageFlowUtils = WebLogicServerAdapter.class$("com.bea.wlw.netui.pageflow.PageFlowUtils")) : class$com$bea$wlw$netui$pageflow$PageFlowUtils).getName() + ".uriSecurityCacheHash";
        URI_SECURITY_CACHE = (class$com$bea$wlw$netui$pageflow$PageFlowUtils == null ? (class$com$bea$wlw$netui$pageflow$PageFlowUtils = WebLogicServerAdapter.class$("com.bea.wlw.netui.pageflow.PageFlowUtils")) : class$com$bea$wlw$netui$pageflow$PageFlowUtils).getName() + ".uriSecurityCache";
        ALREADY_PRINTED_WARNINGS_ATTR = (class$com$bea$wlw$netui$pageflow$PageFlowUtils == null ? (class$com$bea$wlw$netui$pageflow$PageFlowUtils = WebLogicServerAdapter.class$("com.bea.wlw.netui.pageflow.PageFlowUtils")) : class$com$bea$wlw$netui$pageflow$PageFlowUtils).getName() + "_warnings:";
        debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$pageflow$internal$WebLogicServerAdapter == null ? (class$com$bea$wlw$netui$pageflow$internal$WebLogicServerAdapter = WebLogicServerAdapter.class$("com.bea.wlw.netui.pageflow.internal.WebLogicServerAdapter")) : class$com$bea$wlw$netui$pageflow$internal$WebLogicServerAdapter));
        logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$pageflow$internal$WebLogicServerAdapter == null ? (class$com$bea$wlw$netui$pageflow$internal$WebLogicServerAdapter = WebLogicServerAdapter.class$("com.bea.wlw.netui.pageflow.internal.WebLogicServerAdapter")) : class$com$bea$wlw$netui$pageflow$internal$WebLogicServerAdapter));
        REDEPLOY_CALLBACK = new AppRedeployCallback();
        _controlFieldCache = new ConcurrentReaderHashMap();
    }

    static class AnnotatedClass
    extends AnnotatedClassV2 {
        public AnnotatedClass(String className, ClassLoader cl) throws ClassNotFoundException, IOException, OptionalDataException {
            super(className, cl);
        }
    }

    protected static final class AppRedeployCallback
    implements AppManager.RedeployCallback {
        protected AppRedeployCallback() {
        }

        public void beforeRedeploy(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                if (debug.isOn()) {
                    debug.out("A redeploy is occurring.  Invalidating the session.");
                    System.err.println("---------------------------------------------------");
                    Thread.dumpStack();
                    System.err.println("---------------------------------------------------");
                }
                logger.info((Object)"A redeploy is occurring.  Invalidating the session.");
                session.invalidate();
            }
        }

        public void afterRedeploy(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        }
    }
}

