/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.InvoiceItemListResponse;
import org.openapitools.client.model.Revenue;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;

@ApiModel(description="Order line items")
public class LineItemCreateRequest {
    public static final String SERIALIZED_NAME_UNIT_OF_MEASURE = "unit_of_measure";
    @SerializedName(value="unit_of_measure")
    private String unitOfMeasure;
    public static final String SERIALIZED_NAME_UNIT_AMOUNT = "unit_amount";
    @SerializedName(value="unit_amount")
    private BigDecimal unitAmount;
    public static final String SERIALIZED_NAME_TARGET_DATE = "target_date";
    @SerializedName(value="target_date")
    private LocalDate targetDate;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_DEFERRED_REVENUE_ACCOUNT = "deferred_revenue_account";
    @SerializedName(value="deferred_revenue_account")
    private String deferredRevenueAccount;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_REVENUE = "revenue";
    @SerializedName(value="revenue")
    private Revenue revenue;
    public static final String SERIALIZED_NAME_DISCOUNT_UNIT_AMOUNT = "discount_unit_amount";
    @SerializedName(value="discount_unit_amount")
    private BigDecimal discountUnitAmount;
    public static final String SERIALIZED_NAME_DISCOUNT_PERCENT = "discount_percent";
    @SerializedName(value="discount_percent")
    private BigDecimal discountPercent;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private CategoryEnum category;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ITEM_NUMBER = "item_number";
    @SerializedName(value="item_number")
    private String itemNumber;
    public static final String SERIALIZED_NAME_LIST_UNIT_PRICE = "list_unit_price";
    @SerializedName(value="list_unit_price")
    private BigDecimal listUnitPrice;
    public static final String SERIALIZED_NAME_PRODUCT_CODE = "product_code";
    @SerializedName(value="product_code")
    private String productCode;
    public static final String SERIALIZED_NAME_PRICE_ID = "price_id";
    @SerializedName(value="price_id")
    private String priceId;
    public static final String SERIALIZED_NAME_PURCHASE_ORDER_NUMBER = "purchase_order_number";
    @SerializedName(value="purchase_order_number")
    private String purchaseOrderNumber;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private BigDecimal quantity;
    public static final String SERIALIZED_NAME_RECOGNIZED_REVENUE_ACCOUNT = "recognized_revenue_account";
    @SerializedName(value="recognized_revenue_account")
    private String recognizedRevenueAccount;
    public static final String SERIALIZED_NAME_REVENUE_RECOGNITION_RULE_NAME = "revenue_recognition_rule_name";
    @SerializedName(value="revenue_recognition_rule_name")
    private String revenueRecognitionRuleName;
    public static final String SERIALIZED_NAME_SOLD_TO_ID = "sold_to_id";
    @SerializedName(value="sold_to_id")
    private String soldToId;
    public static final String SERIALIZED_NAME_TAX_CODE = "tax_code";
    @SerializedName(value="tax_code")
    private String taxCode;
    public static final String SERIALIZED_NAME_TAX_INCLUSIVE = "tax_inclusive";
    @SerializedName(value="tax_inclusive")
    private Boolean taxInclusive;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_INVOICE_ITEMS = "invoice_items";
    @SerializedName(value="invoice_items")
    private InvoiceItemListResponse invoiceItems;
    public static final String SERIALIZED_NAME_RELATED_SUBSCRIPTION_NUMBER = "related_subscription_number";
    @SerializedName(value="related_subscription_number")
    private String relatedSubscriptionNumber;
    public static final String SERIALIZED_NAME_BILLING_RULE = "billing_rule";
    @SerializedName(value="billing_rule")
    private BillingRuleEnum billingRule;

    public LineItemCreateRequest() {
    }

    public LineItemCreateRequest(InvoiceItemListResponse invoiceItems) {
        this();
        this.invoiceItems = invoiceItems;
    }

    public LineItemCreateRequest unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A configured unit of measure. This field is required for per-unit prices.")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public LineItemCreateRequest unitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unit amount of the price. Specify this field if you want to override the original price with a per-unit price.")
    public BigDecimal getUnitAmount() {
        return this.unitAmount;
    }

    public void setUnitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
    }

    public LineItemCreateRequest targetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The target date for the order line item to be picked up by bill run for billing.")
    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public LineItemCreateRequest customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public LineItemCreateRequest putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public LineItemCreateRequest deferredRevenueAccount(String deferredRevenueAccount) {
        this.deferredRevenueAccount = deferredRevenueAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getDeferredRevenueAccount() {
        return this.deferredRevenueAccount;
    }

    public void setDeferredRevenueAccount(String deferredRevenueAccount) {
        this.deferredRevenueAccount = deferredRevenueAccount;
    }

    public LineItemCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LineItemCreateRequest revenue(Revenue revenue) {
        this.revenue = revenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Revenue getRevenue() {
        return this.revenue;
    }

    public void setRevenue(Revenue revenue) {
        this.revenue = revenue;
    }

    public LineItemCreateRequest discountUnitAmount(BigDecimal discountUnitAmount) {
        this.discountUnitAmount = discountUnitAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Discount amount. Specify this field if you offer an amount-based discount.")
    public BigDecimal getDiscountUnitAmount() {
        return this.discountUnitAmount;
    }

    public void setDiscountUnitAmount(BigDecimal discountUnitAmount) {
        this.discountUnitAmount = discountUnitAmount;
    }

    public LineItemCreateRequest discountPercent(BigDecimal discountPercent) {
        this.discountPercent = discountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Discount percent. Specify this field if you offer a percentage-based discount.")
    public BigDecimal getDiscountPercent() {
        return this.discountPercent;
    }

    public void setDiscountPercent(BigDecimal discountPercent) {
        this.discountPercent = discountPercent;
    }

    public LineItemCreateRequest category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The category for the order line item, to indicate a product sale or return.")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public LineItemCreateRequest state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of an order line item. If you want to generate billing documents for order line items, you must set this field to `sent_to_billing`. For invoice preview, you do not need to set this field.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public LineItemCreateRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of the order line item.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public LineItemCreateRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The name of the order line item.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LineItemCreateRequest itemNumber(String itemNumber) {
        this.itemNumber = itemNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the order item. It can be user-supplied.")
    public String getItemNumber() {
        return this.itemNumber;
    }

    public void setItemNumber(String itemNumber) {
        this.itemNumber = itemNumber;
    }

    public LineItemCreateRequest listUnitPrice(BigDecimal listUnitPrice) {
        this.listUnitPrice = listUnitPrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list price per unit for the order line item.")
    public BigDecimal getListUnitPrice() {
        return this.listUnitPrice;
    }

    public void setListUnitPrice(BigDecimal listUnitPrice) {
        this.listUnitPrice = listUnitPrice;
    }

    public LineItemCreateRequest productCode(String productCode) {
        this.productCode = productCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The product code for the order line item.")
    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public LineItemCreateRequest priceId(String priceId) {
        this.priceId = priceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the price.")
    public String getPriceId() {
        return this.priceId;
    }

    public void setPriceId(String priceId) {
        this.priceId = priceId;
    }

    public LineItemCreateRequest purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used by customers to specify the Purchase Order Number provided by the buyer.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public LineItemCreateRequest quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The quantity of units, such as the number of authors in a hosted wiki service.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public LineItemCreateRequest recognizedRevenueAccount(String recognizedRevenueAccount) {
        this.recognizedRevenueAccount = recognizedRevenueAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getRecognizedRevenueAccount() {
        return this.recognizedRevenueAccount;
    }

    public void setRecognizedRevenueAccount(String recognizedRevenueAccount) {
        this.recognizedRevenueAccount = recognizedRevenueAccount;
    }

    public LineItemCreateRequest revenueRecognitionRuleName(String revenueRecognitionRuleName) {
        this.revenueRecognitionRuleName = revenueRecognitionRuleName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The revenue recognition rule for the order line item.")
    public String getRevenueRecognitionRuleName() {
        return this.revenueRecognitionRuleName;
    }

    public void setRevenueRecognitionRuleName(String revenueRecognitionRuleName) {
        this.revenueRecognitionRuleName = revenueRecognitionRuleName;
    }

    public LineItemCreateRequest soldToId(String soldToId) {
        this.soldToId = soldToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad0823f8040e52d0180433026b156fe", value="Customer address used for calculating tax.")
    public String getSoldToId() {
        return this.soldToId;
    }

    public void setSoldToId(String soldToId) {
        this.soldToId = soldToId;
    }

    public LineItemCreateRequest taxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A tax code identifier. If a `tax_code` of a price is not provided when you create or update a price, Zuora will treat the charged amount as non-taxable. If this code is provide, Zuora considers that this price is taxable and the charged amount will be handled accordingly.")
    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public LineItemCreateRequest taxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this field is set to `true`, it indicates that amounts are inclusive of tax.")
    public Boolean getTaxInclusive() {
        return this.taxInclusive;
    }

    public void setTaxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
    }

    public LineItemCreateRequest startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date a transaction starts. The default value of this field is the order date.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LineItemCreateRequest endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date a transaction is completed. The default value of this field is the transaction start date. Also, the value of this field should always equal or be later than the value of the `start_date` field.")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    @Nullable
    @ApiModelProperty(value="List of invoice items. EXPANDABLE")
    public InvoiceItemListResponse getInvoiceItems() {
        return this.invoiceItems;
    }

    public LineItemCreateRequest relatedSubscriptionNumber(String relatedSubscriptionNumber) {
        this.relatedSubscriptionNumber = relatedSubscriptionNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Relates an order line item to a subscription when you create the order line item.")
    public String getRelatedSubscriptionNumber() {
        return this.relatedSubscriptionNumber;
    }

    public void setRelatedSubscriptionNumber(String relatedSubscriptionNumber) {
        this.relatedSubscriptionNumber = relatedSubscriptionNumber;
    }

    public LineItemCreateRequest billingRule(BillingRuleEnum billingRule) {
        this.billingRule = billingRule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The billing rule for the Order Line Item.")
    public BillingRuleEnum getBillingRule() {
        return this.billingRule;
    }

    public void setBillingRule(BillingRuleEnum billingRule) {
        this.billingRule = billingRule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineItemCreateRequest lineItemCreateRequest = (LineItemCreateRequest)o;
        return Objects.equals(this.unitOfMeasure, lineItemCreateRequest.unitOfMeasure) && Objects.equals(this.unitAmount, lineItemCreateRequest.unitAmount) && Objects.equals(this.targetDate, lineItemCreateRequest.targetDate) && Objects.equals(this.customFields, lineItemCreateRequest.customFields) && Objects.equals(this.deferredRevenueAccount, lineItemCreateRequest.deferredRevenueAccount) && Objects.equals(this.description, lineItemCreateRequest.description) && Objects.equals(this.revenue, lineItemCreateRequest.revenue) && Objects.equals(this.discountUnitAmount, lineItemCreateRequest.discountUnitAmount) && Objects.equals(this.discountPercent, lineItemCreateRequest.discountPercent) && Objects.equals((Object)this.category, (Object)lineItemCreateRequest.category) && Objects.equals((Object)this.state, (Object)lineItemCreateRequest.state) && Objects.equals((Object)this.type, (Object)lineItemCreateRequest.type) && Objects.equals(this.name, lineItemCreateRequest.name) && Objects.equals(this.itemNumber, lineItemCreateRequest.itemNumber) && Objects.equals(this.listUnitPrice, lineItemCreateRequest.listUnitPrice) && Objects.equals(this.productCode, lineItemCreateRequest.productCode) && Objects.equals(this.priceId, lineItemCreateRequest.priceId) && Objects.equals(this.purchaseOrderNumber, lineItemCreateRequest.purchaseOrderNumber) && Objects.equals(this.quantity, lineItemCreateRequest.quantity) && Objects.equals(this.recognizedRevenueAccount, lineItemCreateRequest.recognizedRevenueAccount) && Objects.equals(this.revenueRecognitionRuleName, lineItemCreateRequest.revenueRecognitionRuleName) && Objects.equals(this.soldToId, lineItemCreateRequest.soldToId) && Objects.equals(this.taxCode, lineItemCreateRequest.taxCode) && Objects.equals(this.taxInclusive, lineItemCreateRequest.taxInclusive) && Objects.equals(this.startDate, lineItemCreateRequest.startDate) && Objects.equals(this.endDate, lineItemCreateRequest.endDate) && Objects.equals(this.invoiceItems, lineItemCreateRequest.invoiceItems) && Objects.equals(this.relatedSubscriptionNumber, lineItemCreateRequest.relatedSubscriptionNumber) && Objects.equals((Object)this.billingRule, (Object)lineItemCreateRequest.billingRule);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.unitOfMeasure, this.unitAmount, this.targetDate, this.customFields, this.deferredRevenueAccount, this.description, this.revenue, this.discountUnitAmount, this.discountPercent, this.category, this.state, this.type, this.name, this.itemNumber, this.listUnitPrice, this.productCode, this.priceId, this.purchaseOrderNumber, this.quantity, this.recognizedRevenueAccount, this.revenueRecognitionRuleName, this.soldToId, this.taxCode, this.taxInclusive, this.startDate, this.endDate, this.invoiceItems, this.relatedSubscriptionNumber, this.billingRule});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LineItemCreateRequest {\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    unitAmount: ").append(this.toIndentedString(this.unitAmount)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    deferredRevenueAccount: ").append(this.toIndentedString(this.deferredRevenueAccount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    revenue: ").append(this.toIndentedString(this.revenue)).append("\n");
        sb.append("    discountUnitAmount: ").append(this.toIndentedString(this.discountUnitAmount)).append("\n");
        sb.append("    discountPercent: ").append(this.toIndentedString(this.discountPercent)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    itemNumber: ").append(this.toIndentedString(this.itemNumber)).append("\n");
        sb.append("    listUnitPrice: ").append(this.toIndentedString(this.listUnitPrice)).append("\n");
        sb.append("    productCode: ").append(this.toIndentedString(this.productCode)).append("\n");
        sb.append("    priceId: ").append(this.toIndentedString(this.priceId)).append("\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    recognizedRevenueAccount: ").append(this.toIndentedString(this.recognizedRevenueAccount)).append("\n");
        sb.append("    revenueRecognitionRuleName: ").append(this.toIndentedString(this.revenueRecognitionRuleName)).append("\n");
        sb.append("    soldToId: ").append(this.toIndentedString(this.soldToId)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString(this.taxCode)).append("\n");
        sb.append("    taxInclusive: ").append(this.toIndentedString(this.taxInclusive)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    invoiceItems: ").append(this.toIndentedString(this.invoiceItems)).append("\n");
        sb.append("    relatedSubscriptionNumber: ").append(this.toIndentedString(this.relatedSubscriptionNumber)).append("\n");
        sb.append("    billingRule: ").append(this.toIndentedString((Object)this.billingRule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BillingRuleEnum {
        WITHOUT_FULFILLMENT("trigger_without_fulfillment"),
        ON_FULFILLMENT("trigger_on_fulfillment"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private BillingRuleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BillingRuleEnum fromValue(String value) {
            for (BillingRuleEnum b : BillingRuleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BillingRuleEnum> {
            public void write(JsonWriter jsonWriter, BillingRuleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BillingRuleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BillingRuleEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        PRODUCT("product"),
        FEE("fee"),
        SERVICES("services"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        PENDING("pending"),
        BOOKED("booked"),
        SENT_TO_BILLING("sent_to_billing"),
        COMPLETE("complete"),
        CANCELED("canceled"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CategoryEnum {
        SALE("sale"),
        RETURN("return"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CategoryEnum> {
            public void write(JsonWriter jsonWriter, CategoryEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CategoryEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CategoryEnum.fromValue(value);
            }
        }
    }
}

