/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.Mandate;

@ApiModel(description="If the `type` of the payment method is `sepa_debit`, this hash contains details about the SEPA bank account.")
public class SepaDebit {
    public static final String SERIALIZED_NAME_I_B_A_N = "IBAN";
    @SerializedName(value="IBAN")
    private String IBAN;
    public static final String SERIALIZED_NAME_MANDATE = "mandate";
    @SerializedName(value="mandate")
    private Mandate mandate;
    public static final String SERIALIZED_NAME_BUSINESS_IDENTIFICATION_CODE = "business_identification_code";
    @SerializedName(value="business_identification_code")
    private String businessIdentificationCode;

    public SepaDebit IBAN(String IBAN) {
        this.IBAN = IBAN;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="International Bank Account Number used to create the SEPA Debit payment method.")
    public String getIBAN() {
        return this.IBAN;
    }

    public void setIBAN(String IBAN) {
        this.IBAN = IBAN;
    }

    public SepaDebit mandate(Mandate mandate) {
        this.mandate = mandate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Mandate getMandate() {
        return this.mandate;
    }

    public void setMandate(Mandate mandate) {
        this.mandate = mandate;
    }

    public SepaDebit businessIdentificationCode(String businessIdentificationCode) {
        this.businessIdentificationCode = businessIdentificationCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The BIC code used with the Sepa Debit payment method.")
    public String getBusinessIdentificationCode() {
        return this.businessIdentificationCode;
    }

    public void setBusinessIdentificationCode(String businessIdentificationCode) {
        this.businessIdentificationCode = businessIdentificationCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SepaDebit sepaDebit = (SepaDebit)o;
        return Objects.equals(this.IBAN, sepaDebit.IBAN) && Objects.equals(this.mandate, sepaDebit.mandate) && Objects.equals(this.businessIdentificationCode, sepaDebit.businessIdentificationCode);
    }

    public int hashCode() {
        return Objects.hash(this.IBAN, this.mandate, this.businessIdentificationCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SepaDebit {\n");
        sb.append("    IBAN: ").append(this.toIndentedString(this.IBAN)).append("\n");
        sb.append("    mandate: ").append(this.toIndentedString(this.mandate)).append("\n");
        sb.append("    businessIdentificationCode: ").append(this.toIndentedString(this.businessIdentificationCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

