/*
 * Decompiled with CFR 0.152.
 */
package com.zuora;

import com.google.common.annotations.Beta;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ZuoraClientConfig;
import com.zuora.api.AccountingCodesApi;
import com.zuora.api.AccountingPeriodsApi;
import com.zuora.api.AccountsApi;
import com.zuora.api.ActionsApi;
import com.zuora.api.AdjustmentsApi;
import com.zuora.api.AggregateQueriesApi;
import com.zuora.api.AttachmentsApi;
import com.zuora.api.BillRunApi;
import com.zuora.api.BillingDocumentsApi;
import com.zuora.api.BillingPreviewRunApi;
import com.zuora.api.BookingDateBackfillJobApi;
import com.zuora.api.CatalogGroupsApi;
import com.zuora.api.ContactSnapshotsApi;
import com.zuora.api.ContactsApi;
import com.zuora.api.CreditMemosApi;
import com.zuora.api.CustomExchangeRatesApi;
import com.zuora.api.CustomObjectDefinitionsApi;
import com.zuora.api.CustomObjectJobsApi;
import com.zuora.api.CustomObjectRecordsApi;
import com.zuora.api.CustomPaymentMethodTypesApi;
import com.zuora.api.DataBackfillJobApi;
import com.zuora.api.DataLabelingApi;
import com.zuora.api.DataQueriesApi;
import com.zuora.api.DebitMemosApi;
import com.zuora.api.DeploymentApi;
import com.zuora.api.DeploymentConfigurationTemplatesApi;
import com.zuora.api.DescribeApi;
import com.zuora.api.EInvoicingApi;
import com.zuora.api.FilesApi;
import com.zuora.api.FulfillmentsApi;
import com.zuora.api.HostedPagesApi;
import com.zuora.api.ImportsApi;
import com.zuora.api.InvoiceSchedulesApi;
import com.zuora.api.InvoicesApi;
import com.zuora.api.JournalRunsApi;
import com.zuora.api.MassUpdaterApi;
import com.zuora.api.OAuthApi;
import com.zuora.api.ObjectQueriesApi;
import com.zuora.api.OmniChannelSubscriptionsApi;
import com.zuora.api.OperationsApi;
import com.zuora.api.OrderActionsApi;
import com.zuora.api.OrderLineItemsApi;
import com.zuora.api.OrdersApi;
import com.zuora.api.PaymentAuthorizationApi;
import com.zuora.api.PaymentGatewayReconciliationApi;
import com.zuora.api.PaymentGatewaysApi;
import com.zuora.api.PaymentMethodSnapshotsApi;
import com.zuora.api.PaymentMethodTransactionLogsApi;
import com.zuora.api.PaymentMethodUpdaterApi;
import com.zuora.api.PaymentMethodsApi;
import com.zuora.api.PaymentRunsApi;
import com.zuora.api.PaymentSchedulesApi;
import com.zuora.api.PaymentTransactionLogsApi;
import com.zuora.api.PaymentsApi;
import com.zuora.api.ProductRatePlanChargeTiersApi;
import com.zuora.api.ProductRatePlanChargesApi;
import com.zuora.api.ProductRatePlansApi;
import com.zuora.api.ProductsApi;
import com.zuora.api.RampsApi;
import com.zuora.api.RatePlansApi;
import com.zuora.api.RefundsApi;
import com.zuora.api.RegenerateApi;
import com.zuora.api.RevenueAccountingCodesApi;
import com.zuora.api.RevenueIntegrationApi;
import com.zuora.api.RsaSignaturesApi;
import com.zuora.api.SequenceSetsApi;
import com.zuora.api.SettingsApi;
import com.zuora.api.SignUpApi;
import com.zuora.api.SubscriptionChangeLogsApi;
import com.zuora.api.SubscriptionsApi;
import com.zuora.api.SummaryJournalEntriesApi;
import com.zuora.api.TaxationItemsApi;
import com.zuora.api.UsageApi;
import com.zuora.api.WorkflowsApi;
import com.zuora.model.CreateTokenRequestGrantType;
import com.zuora.sdk.Zuora;
import com.zuora.sdk.auth.AuthenticationProvider;
import com.zuora.sdk.auth.OAuthClientCredentials;
import com.zuora.sdk.auth.OAuthTokenProvider;
import com.zuora.sdk.catalog.Catalog;
import com.zuora.sdk.config.RetrialConfig;
import com.zuora.sdk.config.SdkConfig;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;

public class ZuoraClient {
    private static final Map<String, String> zuoraBaseUrls = Arrays.stream(ZuoraEnv.values()).collect(Collectors.toMap(env -> env.name(), env -> env.getBaseUrl()));
    private ApiClient apiClient;
    private final Timer timer;
    private TimerTask reinitTask;
    private String bearerToken;
    private com.zuora.sdk.ZuoraClient quickStartClient;
    private Zuora catalogClient;
    private ZuoraClientConfig zuoraClientConfig = new ZuoraClientConfig();

    public ZuoraClient(String clientId, String clientSecret, ZuoraEnv env) {
        this(clientId, clientSecret, env.baseUrl);
    }

    public static String getZuoraBaseUrls(String env) {
        return zuoraBaseUrls.get(env);
    }

    public ZuoraClient(String clientId, String clientSecret, String zuoraBaseUrl) {
        this.zuoraClientConfig.setClientSecret(clientSecret);
        this.zuoraClientConfig.setClientId(clientId);
        this.zuoraClientConfig.setBaseUrl(zuoraBaseUrl);
        this.apiClient = new ApiClient();
        this.apiClient.setBasePath(zuoraBaseUrl);
        this.apiClient.setConnectTimeout(this.zuoraClientConfig.getConnectionTimeout());
        this.apiClient.setReadTimeout(this.zuoraClientConfig.getReadTimeout());
        this.apiClient.setWriteTimeout(this.zuoraClientConfig.getWriteTimeout());
        this.timer = new Timer(true);
    }

    private ZuoraClient(ZuoraClientConfig zuoraClientConfig, ApiClient apiClient) {
        this.zuoraClientConfig = zuoraClientConfig;
        if (apiClient == null) {
            this.apiClient = new ApiClient();
        } else {
            this.apiClient = apiClient;
            if (apiClient.getConnectTimeout() != this.zuoraClientConfig.getConnectionTimeout() && this.zuoraClientConfig.getConnectionTimeout() == 65000) {
                this.zuoraClientConfig.setConnectionTimeout(apiClient.getConnectTimeout());
            }
            if (apiClient.getReadTimeout() != this.zuoraClientConfig.getReadTimeout() && this.zuoraClientConfig.getReadTimeout() == 65000) {
                this.zuoraClientConfig.setReadTimeout(apiClient.getReadTimeout());
            }
            if (apiClient.getWriteTimeout() != this.zuoraClientConfig.getWriteTimeout() && this.zuoraClientConfig.getWriteTimeout() == 65000) {
                this.zuoraClientConfig.setWriteTimeout(apiClient.getWriteTimeout());
            }
            if (this.zuoraClientConfig.getUserAgent() == null && apiClient.getUserAgent() != null) {
                this.zuoraClientConfig.setUserAgent(apiClient.getUserAgent());
            }
            if (this.zuoraClientConfig.getZuoraVersion() == null && apiClient.getZuoraVersion() != null) {
                this.zuoraClientConfig.setZuoraVersion(apiClient.getZuoraVersion());
            }
        }
        this.apiClient.setBasePath(this.zuoraClientConfig.getBaseUrl());
        OkHttpClient.Builder okHttpClientBuilder = this.apiClient.getHttpClient().newBuilder().connectTimeout((long)this.zuoraClientConfig.getConnectionTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)this.zuoraClientConfig.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)this.zuoraClientConfig.getWriteTimeout(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(this.zuoraClientConfig.isRetryOnConnectionFailure());
        this.apiClient.setHttpClient(okHttpClientBuilder.build());
        this.apiClient.setDebugging(this.zuoraClientConfig.isDebugging());
        this.zuoraClientConfig.getDefaultHeaders().forEach(this.apiClient::addDefaultHeader);
        this.timer = new Timer(true);
    }

    public ZuoraClientConfig getZuoraClientConfig() {
        return this.zuoraClientConfig;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setDebugging(boolean debugging) {
        this.zuoraClientConfig.setDebugging(debugging);
        this.apiClient.setDebugging(debugging);
    }

    public boolean isDebugging() {
        return this.zuoraClientConfig.isDebugging();
    }

    public void addDefaultHeaders(Map<String, String> defaultHeaders) {
        this.zuoraClientConfig.addDefaultHeaders(defaultHeaders);
        this.zuoraClientConfig.getDefaultHeaders().forEach(this.apiClient::addDefaultHeader);
    }

    public void setZuoraVersion(String zuoraVersion) {
        this.apiClient.setZuoraVersion(zuoraVersion);
        this.zuoraClientConfig.setZuoraVersion(zuoraVersion);
    }

    public String getZuoraVersion() {
        return this.zuoraClientConfig.getZuoraVersion();
    }

    public void setEntityId(String entityId) {
        this.zuoraClientConfig.setZuoraEntityIds(entityId);
        this.apiClient.addDefaultHeader("Zuora-Entity-Ids", entityId);
    }

    public String getEntityId() {
        return this.zuoraClientConfig.getZuoraEntityIds();
    }

    public void setOrgIds(String orgIds) {
        this.zuoraClientConfig.setZuoraOrgIds(orgIds);
        this.apiClient.addDefaultHeader("Zuora-Org-Ids", orgIds);
    }

    public String getOrgIds() {
        return this.zuoraClientConfig.getZuoraOrgIds();
    }

    public String getContentType() {
        return this.zuoraClientConfig.getDefaultHeaders().getOrDefault("Content-Type", null);
    }

    public void setAcceptEncoding(String acceptEncoding) {
        this.zuoraClientConfig.setAcceptEncoding(acceptEncoding);
        this.apiClient.addDefaultHeader("Accept-Encoding", acceptEncoding);
    }

    public String getAcceptEncoding() {
        return this.zuoraClientConfig.getAcceptEncoding();
    }

    public void setContentEncoding(String contentEncoding) {
        this.zuoraClientConfig.setContentEncoding(contentEncoding);
        this.apiClient.addDefaultHeader("Content-Encoding", contentEncoding);
    }

    public void setConnectTimeout(int connectionTimeout) {
        this.zuoraClientConfig.setConnectionTimeout(connectionTimeout);
        this.apiClient.setConnectTimeout(connectionTimeout);
    }

    public void setReadTimeout(int readTimeout) {
        this.zuoraClientConfig.setReadTimeout(readTimeout);
        this.apiClient.setReadTimeout(readTimeout);
    }

    public void setWriteTimeout(int writeTimeout) {
        this.zuoraClientConfig.setWriteTimeout(writeTimeout);
        this.apiClient.setWriteTimeout(writeTimeout);
    }

    protected String fetchBearerToken() {
        for (int attempt = 1; attempt <= this.zuoraClientConfig.getMaxRetries(); ++attempt) {
            try {
                return this.oAuthApi().createTokenApi(this.zuoraClientConfig.getClientId(), this.zuoraClientConfig.getClientSecret(), CreateTokenRequestGrantType.CLIENT_CREDENTIALS).execute().getAccessToken();
            }
            catch (ApiException e) {
                System.err.println("Authentication attempt " + attempt + " failed: " + e.getMessage());
                if (attempt == this.zuoraClientConfig.getMaxRetries()) {
                    System.err.println("All " + this.zuoraClientConfig.getMaxRetries() + " authentication attempts failed. Last error: " + e.getMessage());
                    continue;
                }
                int delay = this.zuoraClientConfig.getRetryBaseDelayMs() * (int)Math.pow(2.0, attempt - 1);
                System.out.println("Retrying authentication in " + delay + "ms...");
                try {
                    Thread.sleep(delay);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        return null;
    }

    protected void auth() {
        String token = this.fetchBearerToken();
        this.setBearerToken(token);
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    protected void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
        this.apiClient.setBearerToken(bearerToken);
    }

    public void initialize() {
        if (this.reinitTask != null) {
            return;
        }
        this.auth();
        int reinitInterval = 600000;
        final ZuoraClient zc = this;
        this.reinitTask = new TimerTask(){

            @Override
            public void run() {
                zc.auth();
            }
        };
        this.timer.scheduleAtFixedRate(this.reinitTask, 0L, (long)reinitInterval);
    }

    public String getBaseUrl() {
        return this.zuoraClientConfig.getBaseUrl();
    }

    public void setRetryConfig(int maxRetries, int retryBaseDelayMs) {
        this.zuoraClientConfig.setRetryConfig(maxRetries, retryBaseDelayMs);
    }

    public Map<String, Object> getRetryConfig() {
        return this.zuoraClientConfig.getRetryConfig();
    }

    public ZuoraClient retryOnConnectionFailure(boolean retryOnConnectionFailure) {
        this.zuoraClientConfig.setRetryOnConnectionFailure(retryOnConnectionFailure);
        this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().retryOnConnectionFailure(retryOnConnectionFailure).build());
        return this;
    }

    public com.zuora.sdk.ZuoraClient quickStartApi() {
        if (this.quickStartClient == null) {
            this.quickStartClient = new com.zuora.sdk.ZuoraClient(this.zuoraClientConfig.getClientId(), this.zuoraClientConfig.getClientSecret(), this.zuoraClientConfig.getBaseUrl());
            this.quickStartClient.initialize();
        }
        return this.quickStartClient;
    }

    @Beta
    public Catalog catalogApi() {
        if (this.catalogClient == null) {
            this.catalogClient = new Zuora(SdkConfig.builder().zuoraBaseUrl(this.zuoraClientConfig.getBaseUrl()).retrialConfig(RetrialConfig.builder().retryStatusCodes(Set.of(Integer.valueOf(429), Integer.valueOf(500), Integer.valueOf(502), Integer.valueOf(503), Integer.valueOf(504))).build()).build(), (AuthenticationProvider)new OAuthTokenProvider(this.zuoraClientConfig.getBaseUrl(), OAuthClientCredentials.builder().clientId(this.zuoraClientConfig.getClientId()).clientSecret(this.zuoraClientConfig.getClientSecret()).build()));
        }
        String orgIds = this.getOrgIds();
        return new Catalog(this.catalogClient, this.getEntityId(), orgIds == null ? null : Arrays.asList(orgIds.split(",")));
    }

    public AccountingCodesApi accountingCodesApi() {
        return new AccountingCodesApi(this.apiClient);
    }

    public AccountingPeriodsApi accountingPeriodsApi() {
        return new AccountingPeriodsApi(this.apiClient);
    }

    public AccountsApi accountsApi() {
        return new AccountsApi(this.apiClient);
    }

    public ActionsApi actionsApi() {
        return new ActionsApi(this.apiClient);
    }

    public AdjustmentsApi adjustmentsApi() {
        return new AdjustmentsApi(this.apiClient);
    }

    public AggregateQueriesApi aggregateQueriesApi() {
        return new AggregateQueriesApi(this.apiClient);
    }

    public AttachmentsApi attachmentsApi() {
        return new AttachmentsApi(this.apiClient);
    }

    public BillingDocumentsApi billingDocumentsApi() {
        return new BillingDocumentsApi(this.apiClient);
    }

    public BillingPreviewRunApi billingPreviewRunApi() {
        return new BillingPreviewRunApi(this.apiClient);
    }

    public BillRunApi billRunApi() {
        return new BillRunApi(this.apiClient);
    }

    public BookingDateBackfillJobApi bookingDateBackfillJobApi() {
        return new BookingDateBackfillJobApi(this.apiClient);
    }

    public CatalogGroupsApi catalogGroupsApi() {
        return new CatalogGroupsApi(this.apiClient);
    }

    public ContactsApi contactsApi() {
        return new ContactsApi(this.apiClient);
    }

    public ContactSnapshotsApi contactSnapshotsApi() {
        return new ContactSnapshotsApi(this.apiClient);
    }

    public CreditMemosApi creditMemosApi() {
        return new CreditMemosApi(this.apiClient);
    }

    public CustomExchangeRatesApi customExchangeRatesApi() {
        return new CustomExchangeRatesApi(this.apiClient);
    }

    public CustomObjectDefinitionsApi customObjectDefinitionsApi() {
        return new CustomObjectDefinitionsApi(this.apiClient);
    }

    public CustomObjectJobsApi customObjectJobsApi() {
        return new CustomObjectJobsApi(this.apiClient);
    }

    public CustomObjectRecordsApi customObjectRecordsApi() {
        return new CustomObjectRecordsApi(this.apiClient);
    }

    public CustomPaymentMethodTypesApi customPaymentMethodTypesApi() {
        return new CustomPaymentMethodTypesApi(this.apiClient);
    }

    public DataBackfillJobApi dataBackfillJobApi() {
        return new DataBackfillJobApi(this.apiClient);
    }

    public DataLabelingApi dataLabelingApi() {
        return new DataLabelingApi(this.apiClient);
    }

    public DataQueriesApi dataQueriesApi() {
        return new DataQueriesApi(this.apiClient);
    }

    public DebitMemosApi debitMemosApi() {
        return new DebitMemosApi(this.apiClient);
    }

    public DeploymentApi deploymentApi() {
        return new DeploymentApi(this.apiClient);
    }

    public DeploymentConfigurationTemplatesApi deploymentConfigurationTemplatesApi() {
        return new DeploymentConfigurationTemplatesApi(this.apiClient);
    }

    public DescribeApi describeApi() {
        return new DescribeApi(this.apiClient);
    }

    public EInvoicingApi eInvoicingApi() {
        return new EInvoicingApi(this.apiClient);
    }

    public FilesApi filesApi() {
        return new FilesApi(this.apiClient);
    }

    public FulfillmentsApi fulfillmentsApi() {
        return new FulfillmentsApi(this.apiClient);
    }

    public HostedPagesApi hostedPagesApi() {
        return new HostedPagesApi(this.apiClient);
    }

    public ImportsApi importsApi() {
        return new ImportsApi(this.apiClient);
    }

    public InvoicesApi invoicesApi() {
        return new InvoicesApi(this.apiClient);
    }

    public InvoiceSchedulesApi invoiceSchedulesApi() {
        return new InvoiceSchedulesApi(this.apiClient);
    }

    public JournalRunsApi journalRunsApi() {
        return new JournalRunsApi(this.apiClient);
    }

    public MassUpdaterApi massUpdaterApi() {
        return new MassUpdaterApi(this.apiClient);
    }

    public OAuthApi oAuthApi() {
        return new OAuthApi(this.apiClient);
    }

    public ObjectQueriesApi objectQueriesApi() {
        return new ObjectQueriesApi(this.apiClient);
    }

    public OmniChannelSubscriptionsApi omniChannelSubscriptionsApi() {
        return new OmniChannelSubscriptionsApi(this.apiClient);
    }

    public OperationsApi operationsApi() {
        return new OperationsApi(this.apiClient);
    }

    public OrderActionsApi orderActionsApi() {
        return new OrderActionsApi(this.apiClient);
    }

    public OrderLineItemsApi orderLineItemsApi() {
        return new OrderLineItemsApi(this.apiClient);
    }

    public OrdersApi ordersApi() {
        return new OrdersApi(this.apiClient);
    }

    public PaymentAuthorizationApi paymentAuthorizationApi() {
        return new PaymentAuthorizationApi(this.apiClient);
    }

    public PaymentGatewayReconciliationApi paymentGatewayReconciliationApi() {
        return new PaymentGatewayReconciliationApi(this.apiClient);
    }

    public PaymentGatewaysApi paymentGatewaysApi() {
        return new PaymentGatewaysApi(this.apiClient);
    }

    public PaymentMethodsApi paymentMethodsApi() {
        return new PaymentMethodsApi(this.apiClient);
    }

    public PaymentMethodSnapshotsApi paymentMethodSnapshotsApi() {
        return new PaymentMethodSnapshotsApi(this.apiClient);
    }

    public PaymentMethodTransactionLogsApi paymentMethodTransactionLogsApi() {
        return new PaymentMethodTransactionLogsApi(this.apiClient);
    }

    public PaymentMethodUpdaterApi paymentMethodUpdaterApi() {
        return new PaymentMethodUpdaterApi(this.apiClient);
    }

    public PaymentRunsApi paymentRunsApi() {
        return new PaymentRunsApi(this.apiClient);
    }

    public PaymentsApi paymentsApi() {
        return new PaymentsApi(this.apiClient);
    }

    public PaymentSchedulesApi paymentSchedulesApi() {
        return new PaymentSchedulesApi(this.apiClient);
    }

    public PaymentTransactionLogsApi paymentTransactionLogsApi() {
        return new PaymentTransactionLogsApi(this.apiClient);
    }

    public ProductRatePlanChargesApi productRatePlanChargesApi() {
        return new ProductRatePlanChargesApi(this.apiClient);
    }

    public ProductRatePlanChargeTiersApi productRatePlanChargeTiersApi() {
        return new ProductRatePlanChargeTiersApi(this.apiClient);
    }

    public ProductRatePlansApi productRatePlansApi() {
        return new ProductRatePlansApi(this.apiClient);
    }

    public ProductsApi productsApi() {
        return new ProductsApi(this.apiClient);
    }

    public RampsApi rampsApi() {
        return new RampsApi(this.apiClient);
    }

    public RatePlansApi ratePlansApi() {
        return new RatePlansApi(this.apiClient);
    }

    public RefundsApi refundsApi() {
        return new RefundsApi(this.apiClient);
    }

    public RegenerateApi regenerateApi() {
        return new RegenerateApi(this.apiClient);
    }

    public RevenueAccountingCodesApi revenueAccountingCodesApi() {
        return new RevenueAccountingCodesApi(this.apiClient);
    }

    public RevenueIntegrationApi revenueIntegrationApi() {
        return new RevenueIntegrationApi(this.apiClient);
    }

    public RsaSignaturesApi rsaSignaturesApi() {
        return new RsaSignaturesApi(this.apiClient);
    }

    public SequenceSetsApi sequenceSetsApi() {
        return new SequenceSetsApi(this.apiClient);
    }

    public SettingsApi settingsApi() {
        return new SettingsApi(this.apiClient);
    }

    public SignUpApi signUpApi() {
        return new SignUpApi(this.apiClient);
    }

    public SubscriptionChangeLogsApi subscriptionChangeLogsApi() {
        return new SubscriptionChangeLogsApi(this.apiClient);
    }

    public SubscriptionsApi subscriptionsApi() {
        return new SubscriptionsApi(this.apiClient);
    }

    public SummaryJournalEntriesApi summaryJournalEntriesApi() {
        return new SummaryJournalEntriesApi(this.apiClient);
    }

    public TaxationItemsApi taxationItemsApi() {
        return new TaxationItemsApi(this.apiClient);
    }

    public UsageApi usageApi() {
        return new UsageApi(this.apiClient);
    }

    public WorkflowsApi workflowsApi() {
        return new WorkflowsApi(this.apiClient);
    }

    public static class Builder {
        private ZuoraClientConfig config;
        private ApiClient apiClient;

        public Builder() {
            this.config = new ZuoraClientConfig();
        }

        public Builder(ZuoraClient client) {
            this.config = client.zuoraClientConfig;
            this.apiClient = client.apiClient;
        }

        public Builder withApiClient(ApiClient apiClient) {
            this.apiClient = apiClient;
            return this;
        }

        public Builder withClientId(String clientId) {
            this.config.setClientId(clientId);
            return this;
        }

        public Builder withClientSecret(String clientSecret) {
            this.config.setClientSecret(clientSecret);
            return this;
        }

        public Builder withBaseUrl(String baseUrl) {
            this.config.setBaseUrl(baseUrl);
            return this;
        }

        public Builder withZuoraEnv(ZuoraEnv env) {
            this.config.setBaseUrl(env.baseUrl);
            return this;
        }

        public Builder withConnectionTimeout(int connectionTimeout) {
            this.config.setConnectionTimeout(connectionTimeout);
            return this;
        }

        public Builder withReadTimeout(int readTimeout) {
            this.config.setReadTimeout(readTimeout);
            return this;
        }

        public Builder withWriteTimeout(int writeTimeout) {
            this.config.setWriteTimeout(writeTimeout);
            return this;
        }

        public Builder withDebuggingEnabled(boolean debugging) {
            this.config.setDebugging(debugging);
            return this;
        }

        public Builder withHeaders(Map<String, String> headers) {
            this.config.addDefaultHeaders(headers);
            return this;
        }

        public Builder withHeader(String key, String value) {
            this.config.addDefaultHeader(key, value);
            return this;
        }

        public Builder withZuoraVersion(String zuoraVersion) {
            this.config.setZuoraVersion(zuoraVersion);
            return this;
        }

        public Builder withZuoraEntityIds(String zuoraEntityIds) {
            this.config.setZuoraEntityIds(zuoraEntityIds);
            return this;
        }

        public Builder withZuoraOrgIds(String zuoraOrgIds) {
            this.config.setZuoraOrgIds(zuoraOrgIds);
            return this;
        }

        public Builder withRetryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.config.setRetryOnConnectionFailure(retryOnConnectionFailure);
            return this;
        }

        public Builder withUserAgent(String userAgent) {
            this.config.setUserAgent(userAgent);
            return this;
        }

        public Builder withAcceptEncoding(String acceptEncoding) {
            this.config.setAcceptEncoding(acceptEncoding);
            return this;
        }

        public Builder withContentEncoding(String contentEncoding) {
            this.config.setContentEncoding(contentEncoding);
            return this;
        }

        public Builder withRetryConfig(int maxRetries, int retryBaseDelayMs) {
            this.config.setRetryConfig(maxRetries, retryBaseDelayMs);
            return this;
        }

        public ZuoraClient build() {
            return new ZuoraClient(this.config, this.apiClient);
        }
    }

    public static enum ZuoraEnv {
        SBX("https://rest.apisandbox.zuora.com"),
        SBX_NA("https://rest.sandbox.na.zuora.com"),
        SBX_EU("https://rest.sandbox.eu.zuora.com"),
        CSBX("https://rest.test.zuora.com"),
        CSBX_EU("https://rest.test.eu.zuora.com"),
        CSBX_AP("https://rest.test.ap.zuora.com"),
        PROD("https://rest.zuora.com"),
        PROD_NA("https://rest.na.zuora.com"),
        PROD_EU("https://rest.eu.zuora.com"),
        PROD_AP("https://rest.ap.zuora.com");

        private final String baseUrl;

        public String getBaseUrl() {
            return this.baseUrl;
        }

        private ZuoraEnv(String baseUrl) {
            this.baseUrl = baseUrl;
        }
    }
}

